/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.Diamond;
import com.taobao.diamond.client.SnapShotSwitch;
import com.taobao.diamond.client.impl.ConcurrentDiskUtil;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.IOUtils;
import com.taobao.diamond.client.impl.JVMUtil;
import com.taobao.diamond.domain.ConfigInfoEx;
import com.taobao.diamond.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class LocalConfigInfoProcessor {
    public static final LocalConfigInfoProcessor singleton = new LocalConfigInfoProcessor();
    public static final String localFileRootPath = System.getProperty("JM.LOG.PATH", System.getProperty("user.home")) + File.separator + "diamond";
    public static final String localSnapShotPath = System.getProperty("JM.SNAPSHOT.PATH", System.getProperty("user.home")) + File.separator + "diamond";

    public static String getFailover(DiamondEnv env, String dataId, String group, String tenant) {
        File localPath = LocalConfigInfoProcessor.getFailoverFile(env, dataId, group, tenant);
        if (!localPath.exists() || !localPath.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(localPath);
        }
        catch (IOException ioe) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "get failover error, " + localPath + ioe.toString());
            return null;
        }
    }

    public static String getSnapshot(DiamondEnv env, String dataId, String group, String tenant) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return null;
        }
        File file = LocalConfigInfoProcessor.getSnapshotFile(env, dataId, group, tenant);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(file);
        }
        catch (IOException ioe) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "get snapshot error, " + file + ", " + ioe.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        if (JVMUtil.isMultiInstance().booleanValue()) {
            return ConcurrentDiskUtil.getFileContent(file, "GBK");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = IOUtils.toString(is, "GBK");
            return string;
        }
        finally {
            try {
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void batchSaveSnapshot(DiamondEnv env, List<ConfigInfoEx> configInfos) {
        for (ConfigInfoEx config : configInfos) {
            if (config.getStatus() == 2) continue;
            LocalConfigInfoProcessor.saveSnapshot(env, config.getDataId(), config.getGroup(), config.getTenant(), config.getContent());
        }
    }

    public static void saveSnapshot(DiamondEnv env, String dataId, String group, String tenant, String config) {
        LocalConfigInfoProcessor.saveSnapshot(env.serverMgr.name, dataId, group, tenant, config);
    }

    public static void saveSnapshot(String envName, String dataId, String group, String tenant, String config) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return;
        }
        File file = LocalConfigInfoProcessor.getSnapshotFile(envName, dataId, group, tenant);
        LocalConfigInfoProcessor.write(envName, config, file);
    }

    static void write(String envName, String content, File file) {
        if (null == content) {
            try {
                IOUtils.delete(file);
            }
            catch (IOException ioe) {
                DiamondEnv.log.error(envName, "DIAMOND-XXXX", "delete snapshot error, " + file + ", " + ioe.toString());
            }
        } else {
            try {
                file.getParentFile().mkdirs();
                if (JVMUtil.isMultiInstance().booleanValue()) {
                    ConcurrentDiskUtil.writeFileContent(file, content, "GBK");
                } else {
                    IOUtils.writeStringToFile(file, content, "GBK");
                }
            }
            catch (IOException ioe) {
                DiamondEnv.log.error(envName, "DIAMOND-XXXX", "save snapshot error, " + file + ", " + ioe.toString());
            }
        }
    }

    public static void cleanAllSnapshot() {
        try {
            File rootFile = new File(localSnapShotPath);
            File[] files = rootFile.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            for (File file : files) {
                if (!file.getName().endsWith("_diamond")) continue;
                IOUtils.cleanDirectory(file);
            }
        }
        catch (IOException ioe) {
            DiamondEnv.log.error("DIAMOND-XXXX", "clean all snapshot error, " + ioe.toString(), ioe);
        }
    }

    public static void cleanEnvSnapshot(String envName) {
        File tmp = new File(localSnapShotPath, envName + "_diamond");
        tmp = new File(tmp, "snapshot");
        try {
            IOUtils.cleanDirectory(tmp);
            DiamondEnv.log.info("success dlelet " + envName + "-snapshot");
        }
        catch (IOException e) {
            DiamondEnv.log.info("fail dlelet " + envName + "-snapshot, " + e.toString());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        Diamond.getConfig("test", "test", 2000L);
    }

    static File getFailoverFile(DiamondEnv env, String dataId, String group, String tenant) {
        File tmp = new File(localSnapShotPath, env.serverMgr.name + "_diamond");
        tmp = new File(tmp, "data");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "config-data");
        } else {
            tmp = new File(tmp, "config-data-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    static File getSnapshotFile(DiamondEnv env, String dataId, String group, String tenant) {
        return LocalConfigInfoProcessor.getSnapshotFile(env.serverMgr.name, dataId, group, tenant);
    }

    static File getSnapshotFile(String envName, String dataId, String group, String tenant) {
        File tmp = new File(localSnapShotPath, envName + "_diamond");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "snapshot");
        } else {
            tmp = new File(tmp, "snapshot-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    static {
        DiamondEnv.log.warn("localSnapShotPath:{}", localSnapShotPath);
    }
}

