/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.alibaba.acm.shaded.com.alibaba.metrics.FastCompass;
import com.taobao.diamond.client.impl.CacheData;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.client.impl.LocalEncryptedDataKeyProcessor;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.common.Constants;
import com.taobao.diamond.common.GroupKey;
import com.taobao.diamond.domain.ConfigInfo;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.maintenance.DiamondMetric;
import com.taobao.diamond.md5.MD5;
import com.taobao.diamond.mockserver.MockServer;
import com.taobao.diamond.utils.ContentUtils;
import com.taobao.diamond.utils.StringUtils;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ClientWorker {
    final ScheduledExecutorService executor;
    final ExecutorService executorService;
    final DiamondEnv env;
    private boolean isHealthServer = true;
    private double currentLongingTaskCount = 0.0;

    static ConfigInfo getServerConfig(DiamondEnv env, String dataId, String group, long readTimeout) throws DiamondException {
        return ClientWorker.getServerConfig(env, dataId, group, TenantUtil.getUserTenant(), false, readTimeout);
    }

    static ConfigInfo getServerConfig(DiamondEnv env, String dataId, String group, String tenant, boolean notify, long readTimeout) throws DiamondException {
        if (StringUtils.isBlank(group)) {
            group = "DEFAULT_GROUP";
        }
        if (MockServer.isTestMode()) {
            ConfigInfo configInfo = new ConfigInfo();
            configInfo.setContent(MockServer.getConfigInfo(dataId, group, env));
            return configInfo;
        }
        HttpSimpleClient.HttpResult result = null;
        FastCompass compass = DiamondMetric.getConfigCompass();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            List<String> params = null;
            params = StringUtils.isBlank(tenant) ? Arrays.asList("dataId", dataId, "group", group) : Arrays.asList("dataId", dataId, "group", group, "tenant", tenant);
            List<String> headers = null;
            if (notify) {
                headers = Arrays.asList("notify", String.valueOf(notify));
            }
            result = env.agent.httpGet("/config.co", headers, params, "GBK", readTimeout);
        }
        catch (IOException e) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server] get server config exception, dataId={}, group={}, tenant={}, msg={}", dataId, group, tenant, e.toString());
            compass.record(0L, "error");
            end = System.currentTimeMillis();
            DiamondMetric.getClusterHistogram().update(end - start);
            throw new DiamondException(500, e.getMessage(), e);
        }
        compass.record(0L, "success");
        end = System.currentTimeMillis();
        DiamondMetric.getClusterHistogram().update(end - start);
        switch (result.code) {
            case 200: {
                ConfigInfo configInfo = new ConfigInfo();
                configInfo.setDataId(dataId);
                configInfo.setGroup(group);
                configInfo.setTenant(tenant);
                configInfo.setContent(result.content);
                ClientWorker.setEncryptedDataKey(configInfo, result);
                LocalConfigInfoProcessor.saveSnapshot(env, dataId, group, tenant, result.content);
                LocalEncryptedDataKeyProcessor.saveEncryptDataKeySnapshot(env, dataId, group, tenant, configInfo.getEncryptedDataKey());
                return configInfo;
            }
            case 404: {
                LocalConfigInfoProcessor.saveSnapshot(env, dataId, group, tenant, null);
                LocalEncryptedDataKeyProcessor.saveEncryptDataKeySnapshot(env, dataId, group, tenant, null);
                return null;
            }
            case 409: {
                DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", dataId, group, tenant);
                throw new DiamondException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
            }
            case 403: {
                DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error] no right, dataId={}, group={}, tenant={}", dataId, group, tenant);
                throw new DiamondException(result.code, result.content);
            }
        }
        DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error]  dataId={}, group={}, tenant={}, code={}", dataId, group, tenant, result.code);
        throw new DiamondException(result.code, "http error, code=" + result.code + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
    }

    private static void setEncryptedDataKey(ConfigInfo configInfo, HttpSimpleClient.HttpResult result) {
        List<String> list;
        Map<String, List<String>> headers = result.headers;
        if (headers != null && !headers.isEmpty() && (list = headers.get("Encrypted-Data-Key")) != null && !list.isEmpty()) {
            configInfo.setEncryptedDataKey(list.get(0));
        }
    }

    static void checkLocalConfig(DiamondEnv env, CacheData cacheData) {
        String dataId = cacheData.dataId;
        String group = cacheData.group;
        String tenant = cacheData.tenant;
        File path = LocalConfigInfoProcessor.getFailoverFile(env, dataId, group, tenant);
        if (!cacheData.isUseLocalConfigInfo() && path.exists()) {
            String content = LocalConfigInfoProcessor.getFailover(env, dataId, group, tenant);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(env, dataId, group, tenant);
            cacheData.setEncryptedDataKey(encryptedDataKey);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file created. dataId={}, group={}, tenant={}, md5={}, content={}", dataId, group, tenant, md5, ContentUtils.truncateContent(content));
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && !path.exists()) {
            cacheData.setUseLocalConfigInfo(false);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file deleted. dataId={}, group={}, tenant={}", dataId, group, tenant);
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && path.exists() && cacheData.getLocalConfigInfoVersion() != path.lastModified()) {
            String content = LocalConfigInfoProcessor.getFailover(env, dataId, group, tenant);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(env, dataId, group, tenant);
            cacheData.setEncryptedDataKey(encryptedDataKey);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file changed. dataId={}, group={}, tenant={}, md5={}, content={}", dataId, group, tenant, md5, ContentUtils.truncateContent(content));
            return;
        }
    }

    public void checkConfigInfo() {
        this.checkConfigInfo(this.env);
    }

    public void checkConfigInfo(DiamondEnv env) {
        int listenerSize = env.getAllCacheDataSize();
        int longingTaskCount = (int)Math.ceil((double)listenerSize / env.getPER_TASK_CONFIG_SIZE());
        if ((double)longingTaskCount > this.currentLongingTaskCount) {
            for (int i = (int)this.currentLongingTaskCount; i < longingTaskCount; ++i) {
                this.executorService.execute(new LongPullingRunnable(i));
            }
            this.currentLongingTaskCount = longingTaskCount;
        }
    }

    List<String> checkUpdateDataIds(List<CacheData> cacheDatas, List<String> inInitializingCacheList) {
        if (MockServer.isTestMode()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ArrayList<String> updateList = new ArrayList<String>();
            for (CacheData cacheData : cacheDatas) {
                if (cacheData.isInitializing()) {
                    inInitializingCacheList.add(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant));
                }
                if (CacheData.getMd5String(MockServer.getConfigInfo(cacheData.dataId, cacheData.group, cacheData.tenant, this.env)).equals(cacheData.getMd5())) continue;
                updateList.add(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant));
            }
            return updateList;
        }
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : cacheDatas) {
            if (cacheData.isUseLocalConfigInfo()) continue;
            sb.append(cacheData.dataId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.group).append(Constants.WORD_SEPARATOR);
            if (StringUtils.isBlank(cacheData.tenant)) {
                sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
            } else {
                sb.append(cacheData.getMd5()).append(Constants.WORD_SEPARATOR);
                sb.append(cacheData.getTenant()).append(Constants.LINE_SEPARATOR);
            }
            if (!cacheData.isInitializing()) continue;
            inInitializingCacheList.add(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant));
        }
        boolean isInitializingCacheList = !inInitializingCacheList.isEmpty();
        return this.checkUpdateConfigStr(sb.toString(), isInitializingCacheList);
    }

    List<String> checkUpdateConfigStr(String probeUpdateString, boolean isInitializingCacheList) {
        List<String> params = Arrays.asList("Probe-Modify-Request", probeUpdateString);
        long timeout = TimeUnit.SECONDS.toMillis(30L);
        ArrayList<String> headers = new ArrayList<String>(2);
        headers.add("longPullingTimeout");
        headers.add("" + timeout);
        if (isInitializingCacheList) {
            headers.add("longPullingNoHangUp");
            headers.add("true");
        }
        if (StringUtils.isBlank(probeUpdateString)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return Collections.emptyList();
        }
        try {
            HttpSimpleClient.HttpResult result = this.env.agent.httpPost("/config.co", headers, params, "GBK", timeout);
            if (200 == result.code) {
                this.setHealthServer(true);
                return this.parseUpdateDataIdResponse(this.env, result.content);
            }
            this.setHealthServer(false);
            if (result.code == 500) {
                DiamondEnv.log.error("Diamond-0007", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0007", "\u73af\u5883\u95ee\u9898", "[check-update] get changed dataId error"));
            }
            DiamondEnv.log.error(this.env.getName(), "DIAMOND-XXXX", "[check-update] get changed dataId error, code={}", result.code);
        }
        catch (IOException e) {
            this.setHealthServer(false);
            DiamondEnv.log.error(this.env.getName(), "DIAMOND-XXXX", "[check-update] get changed dataId exception, msg={}", e.toString());
        }
        return Collections.emptyList();
    }

    private List<String> parseUpdateDataIdResponse(DiamondEnv env, String response) {
        if (StringUtils.isBlank(response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[polling-resp] decode modifiedDataIdsString error", e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        for (String dataIdAndGroup : response.split(Constants.LINE_SEPARATOR)) {
            if (StringUtils.isBlank(dataIdAndGroup)) continue;
            String[] keyArr = dataIdAndGroup.split(Constants.WORD_SEPARATOR);
            String dataId = keyArr[0];
            String group = keyArr[1];
            if (keyArr.length == 2) {
                updateList.add(GroupKey.getKey(dataId, group));
                DiamondEnv.log.info(env.getName(), "[polling-resp] config changed. dataId={}, group={}", dataId, group);
                continue;
            }
            if (keyArr.length == 3) {
                String tenant = keyArr[2];
                updateList.add(GroupKey.getKeyTenant(dataId, group, tenant));
                DiamondEnv.log.info(env.getName(), "[polling-resp] config changed. dataId={}, group={}, tenant={}", dataId, group, tenant);
                continue;
            }
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[polling-resp] invalid dataIdAndGroup error", dataIdAndGroup);
        }
        return updateList;
    }

    ClientWorker(final DiamondEnv env) {
        this.env = env;
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.taobao.diamond.client.Worker." + env.serverMgr.name);
                t.setDaemon(true);
                return t;
            }
        });
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.taobao.diamond.client.Worker.longPulling" + env.serverMgr.name);
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientWorker.this.checkConfigInfo();
                }
                catch (Throwable e) {
                    DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-check] rotate check error", e);
                }
            }
        }, 1L, 10L, TimeUnit.MILLISECONDS);
    }

    public boolean isHealthServer() {
        return this.isHealthServer;
    }

    private void setHealthServer(boolean isHealthServer) {
        this.isHealthServer = isHealthServer;
    }

    class LongPullingRunnable
    implements Runnable {
        private int taskId;

        public LongPullingRunnable(int taskId) {
            this.taskId = taskId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList<CacheData> cacheDatas = new ArrayList<CacheData>();
                for (CacheData cacheData : ClientWorker.this.env.getAllCacheDataSnapshot()) {
                    if (cacheData.getTaskId() != this.taskId) continue;
                    cacheDatas.add(cacheData);
                    try {
                        ClientWorker.checkLocalConfig(ClientWorker.this.env, cacheData);
                        if (!cacheData.isUseLocalConfigInfo()) continue;
                        cacheData.checkListenerMd5();
                    }
                    catch (Exception e) {
                        DiamondEnv.log.error("DIAMOND-CLIENT", "get local config info error", e);
                    }
                }
                ArrayList<String> inInitializingCacheList = new ArrayList<String>();
                List<String> changedGroupKeys = ClientWorker.this.checkUpdateDataIds(cacheDatas, inInitializingCacheList);
                for (String groupKey : changedGroupKeys) {
                    String[] key = GroupKey.parseKey(groupKey);
                    String dataId = key[0];
                    String group = key[1];
                    String tenant = null;
                    if (key.length == 3) {
                        tenant = key[2];
                    }
                    try {
                        CacheData cache = ClientWorker.this.env.getCache(dataId, group, tenant);
                        ConfigInfo configInfo = cache.isInitializing() ? ClientWorker.getServerConfig(ClientWorker.this.env, dataId, group, tenant, false, 3000L) : ClientWorker.getServerConfig(ClientWorker.this.env, dataId, group, tenant, true, 3000L);
                        String content = null;
                        String encryptedDataKey = null;
                        if (configInfo != null) {
                            content = configInfo.getContent();
                            encryptedDataKey = configInfo.getEncryptedDataKey();
                        }
                        cache.setContent(content);
                        cache.setEncryptedDataKey(encryptedDataKey);
                        DiamondEnv.log.info(ClientWorker.this.env.getName(), "[data-received] dataId={}, group={}, tenant={}, md5={}, content={}", dataId, group, tenant, cache.getMd5(), ContentUtils.truncateContent(content));
                    }
                    catch (DiamondException ioe) {
                        DiamondEnv.log.error(ClientWorker.this.env.getName(), "DIAMOND-XXXX", "[get-update] get changed config exception. dataId={}, group={}, tenant={}, msg={}", dataId, group, tenant, ioe.toString());
                    }
                }
                for (CacheData cacheData : cacheDatas) {
                    if (cacheData.isInitializing() && !inInitializingCacheList.contains(GroupKey.getKeyTenant(cacheData.dataId, cacheData.group, cacheData.tenant))) continue;
                    cacheData.checkListenerMd5();
                    cacheData.setInitializing(false);
                }
                inInitializingCacheList.clear();
            }
            catch (Throwable e) {
                DiamondEnv.log.error("500", "longPulling error", e);
            }
            finally {
                ClientWorker.this.executorService.execute(this);
            }
        }
    }
}

