/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.acm.shaded.com.alibaba.metrics;

import com.alibaba.acm.shaded.com.alibaba.metrics.MetricName;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String ILLEGAL_CHARS = "[^a-zA-Z0-9-_./\\p{L}]";
    private static final Pattern ILLEGAL_CHARS_PATTERN = Pattern.compile("[^a-zA-Z0-9-_./\\p{L}]");

    public static void checkMetricName(MetricName name) {
        if (name == null) {
            return;
        }
        if (ILLEGAL_CHARS_PATTERN.matcher(name.getKey()).find()) {
            throw new IllegalArgumentException("Illegal metric key: " + name.getKey());
        }
        for (String tagV : name.getTags().values()) {
            StringUtils.checkTagValue(tagV);
        }
    }

    public static void checkTagValue(String tagValue) {
        if (tagValue == null) {
            return;
        }
        if (ILLEGAL_CHARS_PATTERN.matcher(tagValue).find()) {
            throw new IllegalArgumentException("Illegal tag value: " + tagValue);
        }
    }

    @Deprecated
    public static String removeIllegalOpentsdbChars(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll(ILLEGAL_CHARS, "_");
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean isNotBlank(String s) {
        return s != null && !"".equals(s);
    }

    public static boolean isBlank(String s) {
        return s == null || "".equals(s);
    }
}

