/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.support;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.util.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class URLResource
implements Resource {
    private final URL url;
    private final File file;

    public URLResource(URL url) {
        this.url = Assert.assertNotNull(url, "url", new Object[0]);
        this.file = URLResource.toFile(url);
    }

    private static File toFile(URL url) {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public URL getURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return this.url.openStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        if (this.file != null) {
            return this.file.exists();
        }
        InputStream istream = null;
        boolean exists = false;
        try {
            istream = this.url.openStream();
            exists = true;
        }
        catch (IOException e) {
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
        return exists;
    }

    public long lastModified() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        URLConnection conn = null;
        long lastModified = 0L;
        try {
            conn = this.url.openConnection();
            lastModified = conn.getLastModified();
        }
        catch (IOException e) {
            // empty catch block
        }
        return lastModified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URLResource other = (URLResource)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        if (this.file != null) {
            if (this.file.exists()) {
                buf.append(this.file.isFile() ? "file: " : "directory: ");
                buf.append(this.file.getAbsolutePath());
            } else {
                buf.append("file or directory does not exist: ").append(this.file.getAbsolutePath());
            }
        } else {
            buf.append("URL: ").append(this.url.toExternalForm());
        }
        buf.append("]");
        return buf.toString();
    }
}

