/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.session;

import com.alibaba.citrus.service.mail.MailException;
import com.alibaba.citrus.service.mail.session.MailSession;
import com.alibaba.citrus.service.mail.session.MailStoreHandler;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Store;

public class MailStore
extends MailSession {
    private String storeProtocol;
    private String storeFolder;
    private MailStoreHandler handler;
    private Store store;

    public MailStore() {
    }

    public MailStore(MailStore store, Properties overrideProps) {
        super(store, overrideProps);
        this.storeProtocol = store.storeProtocol;
        this.storeFolder = store.storeFolder;
    }

    public String getProtocol() {
        return ObjectUtil.defaultIfNull(this.storeProtocol, "pop3");
    }

    public void setProtocol(String protocol) {
        this.storeProtocol = StringUtil.trimToNull(protocol);
    }

    public String getFolder() {
        return ObjectUtil.defaultIfNull(this.storeFolder, "INBOX");
    }

    public void setFolder(String folder) {
        this.storeFolder = StringUtil.trimToNull(folder);
    }

    public MailStoreHandler getHandler() {
        return this.handler;
    }

    public void setHandler(MailStoreHandler newHandler) {
        if (newHandler != null) {
            this.handler = newHandler;
        }
    }

    public boolean isConnected() {
        return this.store != null && this.store.isConnected();
    }

    public void connect() throws MailException {
        if (!this.isConnected()) {
            try {
                this.store = this.getSession().getStore(this.getProtocol());
                this.store.connect(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
                if (this.getHandler() != null) {
                    this.getHandler().prepareConnection(this.store);
                }
            }
            catch (NoSuchProviderException e) {
                this.store = null;
                throw new MailException("Could not find a provider of " + this.getProtocol() + " protocol", e);
            }
            catch (MessagingException me) {
                this.store = null;
                throw new MailException("Could not connect to the store", me);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (MessagingException messagingException) {
            }
            finally {
                this.store = null;
            }
        }
    }

    public void receive() throws MailException {
        this.receive(null);
    }

    public void receive(MailStoreHandler handler) throws MailException {
        Folder inbox = null;
        boolean autoClose = false;
        this.setHandler(handler);
        if (!this.isConnected()) {
            autoClose = true;
            this.connect();
        }
        try {
            int max;
            inbox = this.store.getFolder(this.getFolder());
            inbox.open(2);
            int messageCount = inbox.getMessageCount();
            if (this.getHandler() != null && (max = this.getHandler().getMessageCount(messageCount)) >= 0 && max <= messageCount) {
                messageCount = max;
            }
            for (int i = 1; i <= messageCount; ++i) {
                Message message = inbox.getMessage(i);
                boolean deleteMessage = false;
                if (this.getHandler() != null) {
                    deleteMessage = this.getHandler().processMessage(message);
                }
                message.setFlag(Flags.Flag.DELETED, deleteMessage);
            }
        }
        catch (MessagingException me) {
            throw new MailException("Could not receive messages", me);
        }
        finally {
            try {
                if (inbox != null && inbox.isOpen()) {
                    inbox.close(true);
                }
            }
            catch (MessagingException e) {}
            if (autoClose) {
                this.close();
            }
        }
    }

    protected void toString(ToStringBuilder.MapBuilder mb) {
        mb.append("protocol", this.getProtocol());
        mb.append("folder", this.getFolder());
    }
}

