/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl;

import com.alibaba.citrus.service.form.Form;
import com.alibaba.citrus.service.form.Group;
import com.alibaba.citrus.service.form.MessageContext;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.configuration.FormConfig;
import com.alibaba.citrus.service.form.configuration.GroupConfig;
import com.alibaba.citrus.service.form.impl.FormParameters;
import com.alibaba.citrus.service.form.impl.GroupImpl;
import com.alibaba.citrus.service.form.impl.MessageContextFactory;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormImpl
implements Form {
    protected static final Logger log = LoggerFactory.getLogger(Form.class);
    private final FormConfig formConfig;
    private final String formKey;
    private final boolean forcePostOnly;
    private final Map<String, Group> groups = CollectionUtil.createLinkedHashMap();
    private final Collection<Group> groupList = Collections.unmodifiableCollection(this.groups.values());
    private final MessageContext messageContext;
    private boolean valid;
    private SimpleTypeConverter typeConverter;

    public FormImpl(FormConfig formConfig, String formKey, boolean forcePostOnly) {
        this.formConfig = formConfig;
        this.formKey = formKey;
        this.messageContext = MessageContextFactory.newInstance(this);
        this.forcePostOnly = forcePostOnly;
    }

    @Override
    public FormConfig getFormConfig() {
        return this.formConfig;
    }

    @Override
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = new SimpleTypeConverter();
            this.getFormConfig().getPropertyEditorRegistrar().registerCustomEditors((PropertyEditorRegistry)this.typeConverter);
        }
        return this.typeConverter;
    }

    @Override
    public boolean isForcePostOnly() {
        return this.forcePostOnly;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid &= valid;
    }

    @Override
    public void init() {
        this.init(null);
    }

    @Override
    public void init(HttpServletRequest request) {
        this.valid = true;
        this.groups.clear();
        if (request != null) {
            HashSet ignoredGroups = CollectionUtil.createHashSet();
            boolean logStarted = false;
            Enumeration e = request.getParameterNames();
            FormParameters params = new FormParameters(request);
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                FormParameters.FormParameter param = this.parseParameterKey(key);
                if (param == null) continue;
                if (!logStarted) {
                    logStarted = true;
                    log.debug("Initializing user-submitted form for validating");
                }
                params.addFormParameter(param);
                String groupKey = param.groupKey;
                String instanceKey = param.instanceKey;
                String groupInstanceKey = this.getGroupInstanceKey(groupKey, instanceKey);
                if (this.groups.containsKey(groupInstanceKey) || ignoredGroups.contains(groupInstanceKey)) continue;
                GroupConfig groupConfig = this.getFormConfig().getGroupConfigByKey(groupKey);
                if (groupConfig == null) {
                    log.debug("No group associated with parameter: {}", (Object)key);
                    continue;
                }
                if ((this.forcePostOnly || groupConfig.isPostOnly()) && !"post".equalsIgnoreCase(request.getMethod())) {
                    log.warn("Group {} can only read from POST request: {}", (Object)groupConfig.getName(), (Object)key);
                    ignoredGroups.add(groupInstanceKey);
                    this.setValid(false);
                    continue;
                }
                this.groups.put(groupInstanceKey, new GroupImpl(groupConfig, this, instanceKey));
            }
            for (Group group : this.groups.values()) {
                if (log.isDebugEnabled()) {
                    if ("_0".equals(group.getInstanceKey())) {
                        log.debug("Initializing form group: {}", (Object)group.getName());
                    } else {
                        log.debug("Initializing form group: {}[{}]", (Object)group.getName(), (Object)group.getInstanceKey());
                    }
                }
                if (!(group instanceof GroupImpl)) continue;
                ((GroupImpl)group).init(params);
            }
        }
    }

    private FormParameters.FormParameter parseParameterKey(String paramKey) {
        if (!paramKey.startsWith("_fm")) {
            return null;
        }
        String[] parts = StringUtil.split(paramKey, ".", 5);
        if (parts.length < 4 || !ObjectUtil.isEquals(parts[0], this.formKey)) {
            return null;
        }
        String groupKey = StringUtil.toLowerCase(parts[1]);
        String instanceKey = parts[2];
        String fieldKey = StringUtil.toLowerCase(parts[3]);
        String additionalInfo = parts.length > 4 ? parts[4] : null;
        GroupConfig groupConfig = this.getFormConfig().getGroupConfigByKey(groupKey);
        if (groupConfig != null) {
            groupKey = groupConfig.getKey();
            FieldConfig fieldConfig = groupConfig.getFieldConfigByKey(fieldKey);
            if (fieldConfig != null) {
                fieldKey = fieldConfig.getKey();
            }
        }
        String normalizedKey = "_fm." + groupKey + "." + instanceKey + "." + fieldKey;
        if (additionalInfo != null) {
            normalizedKey = normalizedKey + "." + additionalInfo;
        }
        return new FormParameters.FormParameter(groupKey, fieldKey, instanceKey, additionalInfo, paramKey, normalizedKey);
    }

    private String getGroupInstanceKey(String groupKey, String instanceKey) {
        return groupKey + "." + instanceKey;
    }

    @Override
    public void validate() {
        this.valid = true;
        for (Group group : this.getGroups()) {
            group.validate();
        }
    }

    @Override
    public String getKey() {
        return this.formKey;
    }

    @Override
    public Collection<Group> getGroups() {
        return this.groupList;
    }

    @Override
    public Collection<Group> getGroups(String groupName) {
        ArrayList<Group> resultGroups = CollectionUtil.createArrayList(this.groups.size());
        for (Group group : this.groups.values()) {
            if (!group.getName().equalsIgnoreCase(groupName)) continue;
            resultGroups.add(group);
        }
        return resultGroups;
    }

    @Override
    public Group getGroup(String groupName) {
        return this.getGroup(groupName, null, true);
    }

    @Override
    public Group getGroup(String groupName, String instanceKey) {
        return this.getGroup(groupName, instanceKey, true);
    }

    @Override
    public Group getGroup(String groupName, String instanceKey, boolean create) {
        GroupConfig groupConfig = this.getFormConfig().getGroupConfig(groupName);
        if (groupConfig == null) {
            return null;
        }
        instanceKey = ObjectUtil.defaultIfNull(StringUtil.trimToNull(instanceKey), "_0");
        String groupInstanceKey = this.getGroupInstanceKey(groupConfig.getKey(), instanceKey);
        Group group = this.groups.get(groupInstanceKey);
        if (group == null && create) {
            group = new GroupImpl(groupConfig, this, instanceKey);
            this.groups.put(groupInstanceKey, group);
            group.init();
        }
        return group;
    }

    protected MessageContext getMessageContext() {
        return this.messageContext;
    }

    public String toString() {
        return "Form[groups: " + this.getFormConfig().getGroupConfigList().size() + ", group instances: " + this.getGroups().size() + ", valid: " + this.isValid() + "]";
    }
}

