/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.ClassTypeInfo;
import com.alibaba.citrus.generictype.FieldInfo;
import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.MethodInfo;
import com.alibaba.citrus.generictype.RawTypeInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.generictype.impl.AbstractGenericDeclarationInfo;
import com.alibaba.citrus.generictype.impl.TypeInfoFactory;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.internal.LazyLoader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RawTypeImpl
extends AbstractGenericDeclarationInfo
implements RawTypeInfo {
    private static final Map<String, TypeInfo> PRIMITIVE_WRAPPERS = CollectionUtil.createHashMap();
    private final LazyLoader<Supertypes, Object> supertypesLoader = LazyLoader.getDefault(new SupertypesLoader());

    RawTypeImpl(Class<?> rawClass) {
        super(rawClass);
    }

    @Override
    public Class<?> getRawType() {
        return (Class)this.declaration;
    }

    @Override
    public String getName() {
        return this.getRawType().getName();
    }

    @Override
    public String getSimpleName() {
        return ClassUtil.getSimpleClassName(this.getRawType());
    }

    @Override
    public boolean isPrimitive() {
        return this.getRawType().isPrimitive();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return this.getRawType().isInterface();
    }

    @Override
    public TypeInfo getPrimitiveWrapperType() {
        if (this.isPrimitive()) {
            String name = this.getRawType().getName();
            TypeInfo wrapperType = PRIMITIVE_WRAPPERS.get(name);
            return Assert.assertNotNull(wrapperType, "Unknown primitive type: %s", name);
        }
        return this;
    }

    @Override
    public TypeInfo getComponentType() {
        return this;
    }

    @Override
    public TypeInfo getDirectComponentType() {
        return this;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public List<TypeInfo> getInterfaces() {
        return this.supertypesLoader.getInstance().interfaces;
    }

    @Override
    public List<TypeInfo> getSuperclasses() {
        return this.supertypesLoader.getInstance().superclasses;
    }

    @Override
    public List<TypeInfo> getSupertypes() {
        return this.supertypesLoader.getInstance().supertypes;
    }

    @Override
    public TypeInfo getSupertype(Class<?> equivalentClass) {
        return TypeInfoFactory.findSupertype(this, equivalentClass);
    }

    @Override
    public ClassTypeInfo resolve(GenericDeclarationInfo context) {
        return this;
    }

    @Override
    public ClassTypeInfo resolve(GenericDeclarationInfo context, boolean includeBaseType) {
        return this;
    }

    @Override
    public FieldInfo getField(String name) {
        return TypeInfoFactory.getField(this, this, name);
    }

    @Override
    public FieldInfo getField(ClassTypeInfo declaringType, String name) {
        return TypeInfoFactory.getField(this, declaringType, name);
    }

    @Override
    public MethodInfo getConstructor(Class<?> ... paramTypes) {
        return TypeInfoFactory.getConstructor(this, paramTypes);
    }

    @Override
    public MethodInfo getMethod(String methodName, Class<?> ... paramTypes) {
        return TypeInfoFactory.getMethod(this, methodName, paramTypes);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ClassUtil.getSimpleClassName(this.getRawType()));
        this.appendTypeParameters(buf);
        return buf.toString();
    }

    static {
        PRIMITIVE_WRAPPERS.put("boolean", factory.getType((Type)((Object)Boolean.class)));
        PRIMITIVE_WRAPPERS.put("byte", factory.getType((Type)((Object)Byte.class)));
        PRIMITIVE_WRAPPERS.put("char", factory.getType((Type)((Object)Character.class)));
        PRIMITIVE_WRAPPERS.put("double", factory.getType((Type)((Object)Double.class)));
        PRIMITIVE_WRAPPERS.put("float", factory.getType((Type)((Object)Float.class)));
        PRIMITIVE_WRAPPERS.put("int", factory.getType((Type)((Object)Integer.class)));
        PRIMITIVE_WRAPPERS.put("long", factory.getType((Type)((Object)Long.class)));
        PRIMITIVE_WRAPPERS.put("short", factory.getType((Type)((Object)Short.class)));
        PRIMITIVE_WRAPPERS.put("void", factory.getType((Type)((Object)Void.class)));
    }

    private static class InterfaceQueue {
        private final LinkedList<Type> queue = CollectionUtil.createLinkedList();
        private final Set<Class<?>> visited = CollectionUtil.createHashSet();

        private InterfaceQueue() {
        }

        public void push(Type[] types) {
            for (Type type : types) {
                this.push(type);
            }
        }

        public void push(Type type) {
            Class interfaceClass = null;
            if (type instanceof Class) {
                interfaceClass = (Class)type;
            } else if (type instanceof ParameterizedType) {
                interfaceClass = (Class)((ParameterizedType)type).getRawType();
            } else {
                Assert.unreachableCode("Unexpected interface type: %s", type);
            }
            if (!this.visited.contains(interfaceClass)) {
                this.queue.addLast(type);
                this.visited.add(interfaceClass);
            }
        }

        public Type pop() {
            return this.queue.removeFirst();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SupertypesLoader
    implements LazyLoader.Loader<Supertypes, Object> {
        private SupertypesLoader() {
        }

        @Override
        public Supertypes load(Object context) {
            return new Supertypes(RawTypeImpl.this);
        }
    }

    private static class Supertypes {
        private final List<TypeInfo> supertypes;
        private final List<TypeInfo> interfaces;
        private final List<TypeInfo> superclasses;

        private Supertypes(RawTypeImpl rawType) {
            LinkedList<TypeInfo> supertypes = CollectionUtil.createLinkedList();
            InterfaceQueue interfaceQueue = new InterfaceQueue();
            Type type = rawType.getRawType();
            Class<?> rawClass = rawType.getRawType();
            boolean hasObject = false;
            if (rawClass == Object.class) {
                hasObject = true;
            } else if (rawClass.isInterface()) {
                interfaceQueue.push(rawClass);
                hasObject = true;
            } else {
                supertypes.add(rawType);
                while (true) {
                    interfaceQueue.push(rawClass.getGenericInterfaces());
                    type = rawClass.getGenericSuperclass();
                    if (type == Object.class) {
                        hasObject = true;
                        break;
                    }
                    if (type == null) break;
                    TypeInfo typeInfo = TypeInfo.factory.getType(type);
                    supertypes.add(typeInfo);
                    rawClass = typeInfo.getRawType();
                }
            }
            int interfaceCount = 0;
            while (!interfaceQueue.isEmpty()) {
                type = interfaceQueue.pop();
                TypeInfo typeInfo = TypeInfo.factory.getType(type);
                supertypes.add(typeInfo);
                rawClass = typeInfo.getRawType();
                interfaceQueue.push(rawClass.getGenericInterfaces());
                ++interfaceCount;
            }
            if (hasObject) {
                supertypes.add(TypeInfo.OBJECT);
            }
            ArrayList interfaces = CollectionUtil.createArrayList(interfaceCount);
            ArrayList superclasses = CollectionUtil.createArrayList(supertypes.size() - interfaceCount);
            for (TypeInfo supertype : supertypes) {
                if (supertype.getRawType().isInterface()) {
                    interfaces.add(supertype);
                    continue;
                }
                superclasses.add(supertype);
            }
            Assert.assertTrue(interfaces.size() == interfaceCount, "interfaceCount", new Object[0]);
            this.supertypes = Collections.unmodifiableList(CollectionUtil.createArrayList(supertypes));
            this.interfaces = Collections.unmodifiableList(interfaces);
            this.superclasses = Collections.unmodifiableList(superclasses);
        }
    }
}

