/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.support;

import com.alibaba.citrus.service.pipeline.Pipeline;
import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextChainingService;
import com.alibaba.citrus.service.requestcontext.buffered.BufferedRequestContext;
import com.alibaba.citrus.service.requestcontext.lazycommit.LazyCommitRequestContext;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassLoaderUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.ServletUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.webx.BadRequestException;
import com.alibaba.citrus.webx.ResourceNotFoundException;
import com.alibaba.citrus.webx.WebxComponents;
import com.alibaba.citrus.webx.WebxException;
import com.alibaba.citrus.webx.WebxRootController;
import com.alibaba.citrus.webx.config.WebxConfiguration;
import com.alibaba.citrus.webx.handler.ErrorHandlerMapping;
import com.alibaba.citrus.webx.handler.RequestHandler;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.RequestHandlerMapping;
import com.alibaba.citrus.webx.handler.RequestHandlerNameAware;
import com.alibaba.citrus.webx.handler.impl.MainHandler;
import com.alibaba.citrus.webx.handler.impl.error.DetailedErrorHandler;
import com.alibaba.citrus.webx.handler.impl.error.PipelineErrorHandler;
import com.alibaba.citrus.webx.handler.impl.error.SendErrorHandler;
import com.alibaba.citrus.webx.servlet.PassThruSupportable;
import com.alibaba.citrus.webx.util.ErrorHandlerHelper;
import com.alibaba.citrus.webx.util.RequestURIFilter;
import com.alibaba.citrus.webx.util.WebxUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public abstract class AbstractWebxRootController
implements WebxRootController,
PassThruSupportable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String REQUEST_CONTEXT_OWNER_KEY = "_request_context_owner_";
    private static final String REQUEST_HANDLER_LOCATION = "META-INF/webx.internal-request-handlers";
    private static final String ERROR_PREFIX = "error";
    private WebxComponents components;
    private InternalRequestHandlerMapping internalHandlerMapping;
    private RequestContextChainingService requestContexts;
    private RequestURIFilter passthruFilter;

    public WebxComponents getComponents() {
        return this.components;
    }

    public WebxConfiguration getWebxConfiguration() {
        return this.getComponents().getParentWebxConfiguration();
    }

    public ServletContext getServletContext() {
        return this.getComponents().getParentApplicationContext().getServletContext();
    }

    @Override
    public void setPassthruFilter(RequestURIFilter passthru) {
        this.passthruFilter = passthru;
    }

    @Override
    public void init(WebxComponents components) {
        this.components = components;
    }

    @Override
    public void onRefreshContext() throws BeansException {
        this.initWebxConfiguration();
        this.initInternalRequestHandler();
        this.initRequestContexts();
    }

    private void initWebxConfiguration() {
        WebxConfiguration webxConfiguration = this.getWebxConfiguration();
        this.log.debug("Initializing Webx root context in {} mode, according to <webx-configuration>", (Object)(webxConfiguration.isProductionMode() ? "production" : "development"));
    }

    private void initInternalRequestHandler() {
        this.internalHandlerMapping = new InternalRequestHandlerMapping();
    }

    private void initRequestContexts() {
        this.requestContexts = this.getWebxConfiguration().getRequestContexts();
        this.log.debug("Using RequestContextChainingService: {}", (Object)this.requestContexts);
    }

    @Override
    public void onFinishedProcessContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void service(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        RequestContext requestContext;
        block8: {
            block7: {
                requestContext = null;
                requestContext = Assert.assertNotNull(this.getRequestContext(request, response), "could not get requestContext", new Object[0]);
                if (!this.isRequestFinished(requestContext)) break block7;
                this.commitRequest(requestContext);
                return;
            }
            request = requestContext.getRequest();
            response = requestContext.getResponse();
            if (!this.handleInternalRequest(request, response)) break block8;
            this.commitRequest(requestContext);
            return;
        }
        try {
            if (this.isRequestPassedThru(request) || !this.handleRequest(requestContext)) {
                this.giveUpControl(requestContext, chain);
            }
            this.commitRequest(requestContext);
        }
        catch (Throwable e) {
            try {
                this.handleException(requestContext, e);
                this.commitRequest(requestContext);
            }
            catch (Throwable throwable) {
                this.commitRequest(requestContext);
                throw throwable;
            }
        }
    }

    private boolean handleInternalRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestHandlerContext internalRequestHandlerContext = this.internalHandlerMapping.getRequestHandlerContext(request, response);
        if (internalRequestHandlerContext == null) {
            return false;
        }
        internalRequestHandlerContext.handleRequest();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(RequestContext requestContext, Throwable e) throws ServletException, IOException {
        HttpServletRequest request = requestContext.getRequest();
        HttpServletResponse response = requestContext.getResponse();
        try {
            try {
                response.setStatus(500);
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.clearBuffer(requestContext, response);
            RequestHandlerContext errorRequestHandlerContext = this.internalHandlerMapping.getRequestHandlerContextForError(request, response, e);
            Assert.assertNotNull(errorRequestHandlerContext, "Could not get exception handler for exception: %s", e);
            try {
                WebxUtil.setCurrentComponent(request, this.components.getComponent(null));
                errorRequestHandlerContext.handleRequest();
            }
            finally {
                WebxUtil.setCurrentComponent(request, null);
            }
        }
        catch (Throwable ee) {
            if (!ExceptionUtil.getCauses(ee).contains(e)) {
                Throwable rootCause = ExceptionUtil.getRootCause(e);
                String originalExceptionMessage = rootCause.getClass().getSimpleName() + ": " + rootCause.getMessage();
                this.log.error("Failed to handle an error caused by " + originalExceptionMessage, ee);
                this.log.error("Full stack trace of the error " + originalExceptionMessage, e);
            }
            this.clearBuffer(requestContext, response);
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new ServletException(e);
        }
    }

    private boolean isRequestPassedThru(HttpServletRequest request) {
        return this.passthruFilter != null && this.passthruFilter.matches(request);
    }

    private void giveUpControl(RequestContext requestContext, FilterChain chain) throws IOException, ServletException {
        BufferedRequestContext brc = RequestContextUtil.findRequestContext(requestContext, BufferedRequestContext.class);
        if (brc != null) {
            try {
                brc.setBuffering(false);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        try {
            requestContext.getResponse().setContentType(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        chain.doFilter((ServletRequest)requestContext.getRequest(), (ServletResponse)requestContext.getResponse());
    }

    protected boolean isRequestFinished(RequestContext requestContext) {
        LazyCommitRequestContext lcrc = RequestContextUtil.findRequestContext(requestContext, LazyCommitRequestContext.class);
        return lcrc != null && lcrc.isRedirected();
    }

    private void commitRequest(RequestContext requestContext) {
        if (requestContext == null) {
            return;
        }
        try {
            if (this == requestContext.getRequest().getAttribute(REQUEST_CONTEXT_OWNER_KEY)) {
                requestContext.getRequest().removeAttribute(REQUEST_CONTEXT_OWNER_KEY);
                this.requestContexts.commitRequestContext(requestContext);
            }
        }
        catch (Exception e) {
            this.log.error("Exception occurred while commit rundata", (Throwable)e);
        }
    }

    protected abstract boolean handleRequest(RequestContext var1) throws Exception;

    private void clearBuffer(RequestContext requestContext, HttpServletResponse response) {
        if (requestContext != null) {
            response = requestContext.getResponse();
        }
        if (!response.isCommitted()) {
            response.resetBuffer();
        }
    }

    private RequestContext getRequestContext(HttpServletRequest request, HttpServletResponse response) {
        RequestContext requestContext = RequestContextUtil.getRequestContext(request);
        if (requestContext == null) {
            requestContext = this.requestContexts.getRequestContext(this.getServletContext(), request, response);
            request.setAttribute(REQUEST_CONTEXT_OWNER_KEY, (Object)this);
        }
        return requestContext;
    }

    private class InternalRequestHandlerMapping
    implements RequestHandlerMapping,
    ErrorHandlerMapping {
        private final Pattern homepagePattern = Pattern.compile("(^|\\?|&)home(=|&|$)");
        private final boolean productionMode;
        private String internalPathPrefix;
        private RequestHandler mainHandler;
        private RequestHandler errorHandler;
        private Map<String, RequestHandler> internalHandlers = Collections.emptyMap();
        private final ErrorHandlerHelper.ExceptionCodeMapping exceptionCodeMapping = new ErrorHandlerHelper.ExceptionCodeMapping(){

            @Override
            public int getExceptionCode(Throwable exception) {
                if (exception instanceof ResourceNotFoundException) {
                    return 404;
                }
                if (exception instanceof BadRequestException) {
                    return 400;
                }
                return 0;
            }
        };

        public InternalRequestHandlerMapping() {
            this.productionMode = AbstractWebxRootController.this.getWebxConfiguration().isProductionMode();
            ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)AbstractWebxRootController.this.components.getParentApplicationContext()).getBeanFactory();
            beanFactory.registerResolvableDependency(RequestHandlerMapping.class, (Object)this);
            this.internalPathPrefix = AbstractWebxRootController.this.getWebxConfiguration().getInternalPathPrefix();
            this.internalPathPrefix = FileUtil.normalizeAbsolutePath(this.internalPathPrefix, true);
            if (StringUtil.isEmpty(this.internalPathPrefix)) {
                throw new IllegalArgumentException("Invalid internalPathPrefix: " + AbstractWebxRootController.this.getWebxConfiguration().getInternalPathPrefix());
            }
            if (this.productionMode) {
                Pipeline exceptionPipeline = AbstractWebxRootController.this.getWebxConfiguration().getExceptionPipeline();
                if (exceptionPipeline == null) {
                    AbstractWebxRootController.this.log.debug("No exceptionPipeline configured in <webx-configuration>.");
                    this.errorHandler = new SendErrorHandler();
                } else {
                    this.errorHandler = new PipelineErrorHandler(exceptionPipeline);
                }
            } else {
                this.errorHandler = new DetailedErrorHandler();
                ((DetailedErrorHandler)this.errorHandler).setName(AbstractWebxRootController.ERROR_PREFIX);
            }
            SpringExtUtil.autowireAndInitialize(this.errorHandler, (ApplicationContext)AbstractWebxRootController.this.components.getParentApplicationContext(), 0, AbstractWebxRootController.ERROR_PREFIX);
            AbstractWebxRootController.this.log.debug("Using Exception Handler: {}.", (Object)this.errorHandler.getClass().getName());
            if (!this.productionMode) {
                this.internalHandlers = this.loadInternalHandlers(AbstractWebxRootController.REQUEST_HANDLER_LOCATION);
                this.mainHandler = new MainHandler();
                ((MainHandler)this.mainHandler).setName("");
                SpringExtUtil.autowireAndInitialize(this.mainHandler, (ApplicationContext)AbstractWebxRootController.this.components.getParentApplicationContext(), 0, AbstractWebxRootController.ERROR_PREFIX);
            }
        }

        @Override
        public String[] getRequestHandlerNames() {
            return this.internalHandlers.keySet().toArray(new String[this.internalHandlers.size()]);
        }

        @Override
        public RequestHandlerContext getRequestHandlerContext(HttpServletRequest request, HttpServletResponse response) {
            String qs;
            String baseURL = ServletUtil.getBaseURL(request);
            String path = ServletUtil.getResourcePath(request).replace(' ', '+');
            String internalBaseURL = baseURL + this.internalPathPrefix;
            if (this.mainHandler != null && ("".equals(path) || "/".equals(path)) && (StringUtil.isEmpty(qs = request.getQueryString()) || !this.homepagePattern.matcher(qs).find())) {
                return new InternalRequestHandlerContext(request, response, internalBaseURL, internalBaseURL, path, this.mainHandler);
            }
            if (this.startsWithElement(path, this.internalPathPrefix)) {
                path = this.removeStartElement(path, this.internalPathPrefix);
                if (this.errorHandler != null && !this.productionMode && this.startsWithElement(path, AbstractWebxRootController.ERROR_PREFIX)) {
                    path = this.removeStartElement(path, AbstractWebxRootController.ERROR_PREFIX);
                    return new InternalRequestHandlerContext(request, response, internalBaseURL, internalBaseURL + "/" + AbstractWebxRootController.ERROR_PREFIX, path, this.errorHandler);
                }
                for (Map.Entry<String, RequestHandler> entry : this.internalHandlers.entrySet()) {
                    String prefix = entry.getKey();
                    if (!this.startsWithElement(path, prefix)) continue;
                    RequestHandler handler = entry.getValue();
                    path = this.removeStartElement(path, prefix);
                    return new InternalRequestHandlerContext(request, response, internalBaseURL, internalBaseURL + "/" + prefix, path, handler);
                }
                if (this.mainHandler != null) {
                    return new InternalRequestHandlerContext(request, response, internalBaseURL, internalBaseURL, path, this.mainHandler);
                }
                throw new ResourceNotFoundException(request.getRequestURI());
            }
            return null;
        }

        @Override
        public RequestHandlerContext getRequestHandlerContextForError(HttpServletRequest request, HttpServletResponse response, Throwable exception) {
            ErrorHandlerHelper helper = ErrorHandlerHelper.getInstance(request);
            helper.init("", exception, this.exceptionCodeMapping);
            response.setStatus(helper.getStatusCode());
            String internalBaseURL = ServletUtil.getBaseURL(request) + this.internalPathPrefix;
            return new InternalRequestHandlerContext(request, response, internalBaseURL, internalBaseURL + "/" + AbstractWebxRootController.ERROR_PREFIX, "", this.errorHandler);
        }

        private boolean startsWithElement(String path, String element) {
            if (path.equals(element)) {
                return true;
            }
            return path.startsWith(element) && path.charAt(element.length()) == '/';
        }

        private String removeStartElement(String path, String element) {
            if (path.equals(element)) {
                return "";
            }
            return path.substring(element.length() + 1);
        }

        private Map<String, RequestHandler> loadInternalHandlers(String location) {
            Properties handlerNames;
            ClassLoader loader = AbstractWebxRootController.this.components.getParentApplicationContext().getClassLoader();
            try {
                handlerNames = PropertiesLoaderUtils.loadAllProperties((String)location, (ClassLoader)loader);
            }
            catch (IOException e) {
                throw new WebxException("Could not load " + location, e);
            }
            TreeMap<String, RequestHandler> handlers = CollectionUtil.createTreeMap(new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int lenDiff = s2.length() - s1.length();
                    if (lenDiff != 0) {
                        return lenDiff;
                    }
                    return s1.compareTo(s2);
                }
            });
            for (Map.Entry<Object, Object> entry : handlerNames.entrySet()) {
                String name = FileUtil.normalizeRelativePath((String)entry.getKey(), true);
                String handlerClass = StringUtil.trimToNull((String)entry.getValue());
                if (StringUtil.isEmpty(name) || handlerClass == null) continue;
                if (AbstractWebxRootController.ERROR_PREFIX.equals(name)) {
                    AbstractWebxRootController.this.log.warn("Ignored request handler with reserved name [error]: " + handlerClass);
                    continue;
                }
                try {
                    Object handler = ClassLoaderUtil.newInstance(handlerClass, loader);
                    if (handler instanceof RequestHandlerNameAware) {
                        ((RequestHandlerNameAware)handler).setName(name);
                    }
                    SpringExtUtil.autowireAndInitialize(handler, (ApplicationContext)AbstractWebxRootController.this.components.getParentApplicationContext(), 0, name);
                    try {
                        handlers.put(name, (RequestHandler)RequestHandler.class.cast(handler));
                    }
                    catch (ClassCastException e) {
                        AbstractWebxRootController.this.log.error("Declared internal request handler must implement InternalRequestHandler: " + name + "=" + handlerClass, (Throwable)e);
                    }
                }
                catch (Exception e) {
                    AbstractWebxRootController.this.log.error("Could not create internal request handler: " + name + "=" + handlerClass, (Throwable)e);
                }
            }
            if (AbstractWebxRootController.this.log.isDebugEnabled()) {
                AbstractWebxRootController.this.log.debug(new ToStringBuilder().append("loading internal request handlers:").append(handlers).toString());
            }
            return handlers;
        }
    }

    private class InternalRequestHandlerContext
    extends RequestHandlerContext {
        private final RequestHandler handler;

        public InternalRequestHandlerContext(HttpServletRequest request, HttpServletResponse response, String internalBaseURL, String baseURL, String resourceName, RequestHandler handler) {
            super(request, response, AbstractWebxRootController.this.getServletContext(), internalBaseURL, baseURL, resourceName);
            this.handler = handler;
        }

        @Override
        public RequestHandler getRequestHandler() {
            return this.handler;
        }
    }
}

