/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.component;

import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.HumanReadableSize;
import com.alibaba.citrus.util.SystemUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.component.KeyValuesComponent;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import com.alibaba.citrus.webx.util.WebxUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.springframework.core.SpringVersion;

public class SystemInfoComponent
extends PageComponent
implements ProductionModeAware {
    private final KeyValuesComponent keyValuesComponent;
    private boolean productionMode;

    public SystemInfoComponent(PageComponentRegistry registry, String componentPath, KeyValuesComponent keyValuesComponent) {
        super(registry, componentPath);
        this.keyValuesComponent = keyValuesComponent;
    }

    @Override
    public void setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
    }

    public void visitTemplate(RequestHandlerContext context) {
        this.getTemplate().accept(new SystemInfoVisitor(context));
    }

    private class SystemInfoVisitor
    extends AbstractVisitor {
        public SystemInfoVisitor(RequestHandlerContext context) {
            super(context, SystemInfoComponent.this);
        }

        public void visitSysinfo() {
            LinkedHashMap<String, Object> keyValues = CollectionUtil.createLinkedHashMap();
            keyValues.put("Webx Version", WebxUtil.getWebxVersion());
            keyValues.put("Spring Version", SpringVersion.getVersion());
            keyValues.put("Running Mode", SystemInfoComponent.this.productionMode ? "Production Mode" : "Development Mode");
            keyValues.put("Java", ArrayUtil.arrayToMap(new Object[][]{{"Vendor", SystemUtil.getJavaInfo().getVendor()}, {"Version", SystemUtil.getJavaInfo().getVersion()}}, String.class, String.class));
            keyValues.put("Java Runtime", ArrayUtil.arrayToMap(new Object[][]{{"Name", SystemUtil.getJavaRuntimeInfo().getName()}, {"Version", SystemUtil.getJavaRuntimeInfo().getVersion()}, {"Home", SystemUtil.getJavaRuntimeInfo().getHomeDir()}}, String.class, String.class));
            keyValues.put("Java Spec.", ArrayUtil.arrayToMap(new Object[][]{{"Name", SystemUtil.getJavaSpecInfo().getName()}, {"Vendor", SystemUtil.getJavaSpecInfo().getVendor()}, {"Version", SystemUtil.getJavaSpecInfo().getVersion()}}, String.class, String.class));
            keyValues.put("JVM", ArrayUtil.arrayToMap(new Object[][]{{"Name", SystemUtil.getJvmInfo().getName()}, {"Vendor", SystemUtil.getJvmInfo().getVendor()}, {"Version", SystemUtil.getJvmInfo().getVersion()}, {"Info", SystemUtil.getJvmInfo().getInfo()}}, String.class, String.class));
            keyValues.put("JVM Spec.", ArrayUtil.arrayToMap(new Object[][]{{"Name", SystemUtil.getJvmSpecInfo().getName()}, {"Vendor", SystemUtil.getJvmSpecInfo().getVendor()}, {"Version", SystemUtil.getJvmSpecInfo().getVersion()}}, String.class, String.class));
            keyValues.put("OS", String.format("%s %s %s", SystemUtil.getOsInfo().getName(), SystemUtil.getOsInfo().getArch(), SystemUtil.getOsInfo().getVersion()));
            keyValues.put("File Encoding", SystemUtil.getOsInfo().getFileEncoding());
            keyValues.put("Host Name", SystemUtil.getHostInfo().getName());
            keyValues.put("Host Address", SystemUtil.getHostInfo().getAddress());
            try {
                TreeMap networkAddresses = CollectionUtil.createTreeMap();
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface networkInterface = e.nextElement();
                    String name = networkInterface.getDisplayName();
                    LinkedList addresses = CollectionUtil.createLinkedList();
                    Enumeration<InetAddress> e2 = networkInterface.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        addresses.add(e2.nextElement().getHostAddress());
                    }
                    networkAddresses.put(name, addresses);
                }
                keyValues.put("Server IPs", networkAddresses);
            }
            catch (Exception e) {
                keyValues.put("Server IPs", e.getMessage());
            }
            LinkedHashMap<String, String> memory = CollectionUtil.createLinkedHashMap();
            memory.put("Free", this.formatMemory(Runtime.getRuntime().freeMemory()));
            memory.put("Total", this.formatMemory(Runtime.getRuntime().totalMemory()));
            memory.put("Maximum", this.formatMemory(Runtime.getRuntime().maxMemory()));
            keyValues.put("Memory", memory);
            SystemInfoComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        private String formatMemory(long memory) {
            return String.format("%s (%,d)", new HumanReadableSize(memory), memory);
        }
    }
}

