/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.component;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class KeyValuesComponent
extends PageComponent {
    public KeyValuesComponent(PageComponentRegistry registry, String componentPath) {
        super(registry, componentPath);
    }

    public void visitTemplate(RequestHandlerContext context, Map<String, ?> keyValues) {
        this.getTemplate().accept(new KeyValuesVisitor(context, keyValues));
    }

    private class KeyValuesVisitor
    extends AbstractVisitor {
        private final Map<String, ?> keyValues;
        private String key;
        private Object values;
        private Object value;

        public KeyValuesVisitor(RequestHandlerContext context, Map<String, ?> keyValues) {
            super(context, KeyValuesComponent.this);
            this.keyValues = Assert.assertNotNull(keyValues, "keyValues", new Object[0]);
        }

        public void visitRow(Template emptyTemplate, Template rowTemplate) {
            if (this.keyValues.isEmpty()) {
                emptyTemplate.accept(this);
            } else {
                Iterator<String> i$ = this.keyValues.keySet().iterator();
                while (i$.hasNext()) {
                    String key;
                    this.key = key = i$.next();
                    this.values = this.keyValues.get(key);
                    if (this.values != null) {
                        if (this.values.getClass().isArray()) {
                            this.values = this.arrayToCollection(this.values);
                        } else if (this.values instanceof Map) {
                            this.values = ((Map)this.values).entrySet();
                        }
                    }
                    rowTemplate.accept(this);
                }
            }
        }

        public void visitKey() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.key));
        }

        public void visitValue() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(String.valueOf(this.value)));
        }

        public void visitEntryKey() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(String.valueOf(((Map.Entry)this.value).getKey())));
        }

        public void visitEntryValue() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(String.valueOf(((Map.Entry)this.value).getValue())));
        }

        public void visitValues(Template singleValueTemplate, Template multiValuesTemplate) {
            if (this.values instanceof Collection) {
                Collection valueCollection = (Collection)this.values;
                switch (valueCollection.size()) {
                    case 0: {
                        this.value = null;
                        singleValueTemplate.accept(this);
                        break;
                    }
                    case 1: {
                        this.value = valueCollection.iterator().next();
                        singleValueTemplate.accept(this);
                        break;
                    }
                    default: {
                        multiValuesTemplate.accept(this);
                        break;
                    }
                }
            } else {
                this.value = this.values;
                singleValueTemplate.accept(this);
            }
        }

        public void visitValueCount() {
            ((PrintWriter)this.out()).print(((Collection)this.values).size());
        }

        public void visitValueItem(Template valueItemTemplate, Template entryItemTemplate) {
            for (Object this.value : (Collection)this.values) {
                if (this.value instanceof Map.Entry) {
                    entryItemTemplate.accept(this);
                    continue;
                }
                valueItemTemplate.accept(this);
            }
        }

        private Collection<?> arrayToCollection(Object array) {
            int length = Array.getLength(array);
            ArrayList list = CollectionUtil.createArrayList(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
    }
}

