/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.util;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.citrus.turbine.support.TurbineRunDataImpl;
import com.alibaba.citrus.util.Assert;
import javax.servlet.http.HttpServletRequest;

public class TurbineUtil {
    private static final String TURBINE_RUNDATA_KEY = "_webx3_turbine_rundata_";
    private static final String TURBINE_RUNDATA_CONTEXT_KEY = "_webx3_turbine_rundata_context";

    public static TurbineRunData getTurbineRunData(HttpServletRequest request) {
        return TurbineUtil.getTurbineRunData(request, false);
    }

    public static TurbineRunData getTurbineRunData(HttpServletRequest request, boolean create) {
        TurbineRunData rundata = (TurbineRunData)request.getAttribute(TURBINE_RUNDATA_KEY);
        if (rundata == null && create) {
            Context context = (Context)request.getAttribute(TURBINE_RUNDATA_CONTEXT_KEY);
            rundata = new TurbineRunDataImpl(request, context);
            request.setAttribute(TURBINE_RUNDATA_KEY, (Object)rundata);
        }
        return Assert.assertNotNull(rundata, "TurbineRunData not found in request attributes", new Object[0]);
    }

    public static TurbineRunData getTurbineRunData(RequestContext requestContext) {
        return TurbineUtil.getTurbineRunData(requestContext.getRequest());
    }

    public static void saveTurbineRunDataContext(TurbineRunData rundata) {
        if (rundata instanceof TurbineRunDataInternal) {
            rundata.getRequest().setAttribute(TURBINE_RUNDATA_CONTEXT_KEY, (Object)((TurbineRunDataInternal)rundata).getContext());
        }
    }

    public static void cleanupTurbineRunData(HttpServletRequest request, boolean clearContext) {
        request.removeAttribute(TURBINE_RUNDATA_KEY);
        if (clearContext) {
            request.removeAttribute(TURBINE_RUNDATA_CONTEXT_KEY);
        }
    }
}

