/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.util;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DomUtil {
    public static org.dom4j.Element convertElement(Element element) {
        org.w3c.dom.Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Failed to create dom4j document", e);
        }
        Element clonedElement = (Element)doc.importNode(element, true);
        doc.appendChild(clonedElement);
        DOMReader reader = new DOMReader();
        Document dom4jDoc = reader.read(doc);
        return dom4jDoc.getRootElement();
    }

    public static void convertElement(Element element, ContentHandler contentHandler) throws SAXException {
        SAXWriter writer = new SAXWriter(contentHandler);
        if (contentHandler instanceof ErrorHandler) {
            writer.setErrorHandler((ErrorHandler)((Object)contentHandler));
        }
        if (contentHandler instanceof LexicalHandler) {
            writer.setLexicalHandler((LexicalHandler)((Object)contentHandler));
        }
        writer.write(DomUtil.convertElement(element));
    }

    public static List<Element> subElements(Element element) {
        return DomUtil.subElements(element, null);
    }

    public static List<Element> subElements(Element element, ElementSelector selector) {
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> subElements = CollectionUtil.createArrayList(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element subElement = (Element)node;
            if (selector != null && !selector.accept(subElement)) continue;
            subElements.add(subElement);
        }
        return subElements;
    }

    public static Element theOnlySubElement(Element element, ElementSelector selector) {
        List<Element> subElements = DomUtil.subElements(element, selector);
        switch (subElements.size()) {
            case 1: {
                return subElements.get(0);
            }
            case 0: {
                return null;
            }
        }
        Assert.fail("too more sub-elements of %s", element.getNodeName());
        return null;
    }

    public static ElementSelector sameNs(Element element) {
        return DomUtil.ns(Assert.assertNotNull(element, "element", new Object[0]).getNamespaceURI());
    }

    public static ElementSelector beansNs() {
        return DomUtil.ns("http://www.springframework.org/schema/beans");
    }

    public static ElementSelector any() {
        return new ElementSelector(){

            @Override
            public boolean accept(Element element) {
                return true;
            }

            public String toString() {
                return "any";
            }
        };
    }

    public static ElementSelector none() {
        return new ElementSelector(){

            @Override
            public boolean accept(Element element) {
                return false;
            }

            public String toString() {
                return "none";
            }
        };
    }

    public static ElementSelector ns(String nsUri) {
        final String trimmedNsUri = StringUtil.trimToNull(nsUri);
        return new ElementSelector(){

            @Override
            public boolean accept(Element element) {
                return ObjectUtil.isEquals(element.getNamespaceURI(), trimmedNsUri);
            }

            public String toString() {
                return "ns[" + (trimmedNsUri == null ? "no namespace" : trimmedNsUri) + "]";
            }
        };
    }

    public static ElementSelector name(String name) {
        final String trimmedName = Assert.assertNotNull(StringUtil.trimToNull(name), "elementName", new Object[0]);
        return new ElementSelector(){

            @Override
            public boolean accept(Element element) {
                String name = element.getNamespaceURI() == null ? element.getNodeName() : element.getLocalName();
                return ObjectUtil.isEquals(name, trimmedName);
            }

            public String toString() {
                return "name[" + trimmedName + "]";
            }
        };
    }

    public static ElementSelector or(final ElementSelector ... selectors) {
        return new ElementSelector(){

            @Override
            public boolean accept(Element element) {
                if (selectors != null) {
                    for (ElementSelector selector : selectors) {
                        if (!selector.accept(element)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            public String toString() {
                return "or" + CollectionUtil.asList(selectors);
            }
        };
    }

    public static ElementSelector and(final ElementSelector ... selectors) {
        return new ElementSelector(){

            @Override
            public boolean accept(Element element) {
                if (selectors != null) {
                    for (ElementSelector selector : selectors) {
                        if (selector.accept(element)) continue;
                        return false;
                    }
                }
                return true;
            }

            public String toString() {
                return "and" + CollectionUtil.asList(selectors);
            }
        };
    }

    public static ElementSelector not(final ElementSelector selector) {
        Assert.assertNotNull(selector, "selector", new Object[0]);
        return new ElementSelector(){

            @Override
            public boolean accept(Element element) {
                return !selector.accept(element);
            }

            public String toString() {
                return "not[" + selector + "]";
            }
        };
    }

    public static ElementSelector error() {
        return DomUtil.error(null, null);
    }

    public static ElementSelector error(final Assert.ExceptionType type, final String message) {
        return new ElementSelector(){

            @Override
            public boolean accept(Element element) {
                Assert.assertTrue(false, type, StringUtil.defaultIfEmpty(message, "Unexpected element: " + element.getNodeName()), new Object[0]);
                return false;
            }

            public String toString() {
                return "error";
            }
        };
    }

    public static interface ElementSelector {
        public boolean accept(Element var1);
    }
}

