/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.support;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.util.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileResource
implements Resource {
    private final File file;

    public FileResource(File file) {
        this.file = Assert.assertNotNull(file, "file", new Object[0]);
    }

    @Override
    public URL getURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileResource other = (FileResource)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        if (this.file.exists()) {
            buf.append(this.file.isFile() ? "file: " : "directory: ");
            buf.append(this.file.getAbsolutePath());
        } else {
            buf.append("file or directory does not exist: ").append(this.file.getAbsolutePath());
        }
        buf.append("]");
        return buf.toString();
    }
}

