/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.loader;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceLister;
import com.alibaba.citrus.service.resource.ResourceListerContext;
import com.alibaba.citrus.service.resource.ResourceLoaderContext;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceMatchResult;
import com.alibaba.citrus.service.resource.support.URLResource;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.web.context.ServletContextAware;

public class WebappResourceLoader
implements ResourceLister,
ServletContextAware {
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void init(ResourceLoadingService resourceLoadingService) {
    }

    @Override
    public Resource getResource(ResourceLoaderContext context, Set<ResourceLoadingOption> options) {
        return this.getServletResource(this.getNewResourceName(context), context, options);
    }

    @Override
    public String[] list(ResourceListerContext context, Set<ResourceLoadingOption> options) {
        Set nameSet;
        String path = this.getNewResourceName(context);
        Resource resource = this.getServletResource(path, context, options);
        if (resource == null) {
            return null;
        }
        boolean isDirectory = resource.getURL().getPath().endsWith("/");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((nameSet = this.servletContext.getResourcePaths(path)) == null || nameSet.isEmpty()) {
            if (isDirectory) {
                return BasicConstant.EMPTY_STRING_ARRAY;
            }
            return null;
        }
        ArrayList<String> names = CollectionUtil.createArrayList(nameSet.size());
        for (String name : nameSet) {
            int startIndex = path.length();
            int endIndex = name.length();
            if (endIndex > startIndex) {
                name = name.substring(startIndex, endIndex);
            }
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    private String getNewResourceName(ResourceMatchResult context) {
        return context.substitute("");
    }

    private Resource getServletResource(String resourceName, ResourceMatchResult context, Set<ResourceLoadingOption> options) {
        URL resourceURL = null;
        if (this.servletContext != null) {
            try {
                resourceURL = this.servletContext.getResource(resourceName);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        Resource resource = null;
        if (resourceURL != null) {
            resource = new URLResource(resourceURL);
        }
        if (resource != null && resource.getFile() != null && !resource.getFile().exists()) {
            resource = null;
        }
        return resource;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.servletContext + "]";
    }
}

