/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextChainingService;
import com.alibaba.citrus.service.requestcontext.RequestContextException;
import com.alibaba.citrus.service.requestcontext.RequestContextFactory;
import com.alibaba.citrus.service.requestcontext.RequestContextInfo;
import com.alibaba.citrus.service.requestcontext.impl.SimpleRequestContext;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestContextChainingServiceImpl
extends AbstractService<RequestContextChainingService>
implements RequestContextChainingService {
    private List<RequestContextFactory<?>> factories;
    private boolean sort;
    private boolean threadContextInheritable;

    public void setFactories(List<RequestContextFactory<?>> factories) {
        this.factories = CollectionUtil.createArrayList((Iterable)Assert.assertNotNull(factories, "factories", new Object[0]));
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public void setThreadContextInheritable(boolean threadContextInheritable) {
        this.threadContextInheritable = threadContextInheritable;
    }

    @Override
    protected void init() {
        if (this.factories == null) {
            this.getLogger().warn("no request context factory defined");
            this.factories = CollectionUtil.createArrayList();
        }
        if (this.sort) {
            LinkedHashMap<Integer, RequestContextFactory<?>> result = CollectionUtil.createLinkedHashMap();
            HashSet<Integer> processing = CollectionUtil.createHashSet();
            for (int i = 0; i < this.factories.size(); ++i) {
                if (result.containsKey(i)) continue;
                this.sort(i, this.factories.get(i), result, processing);
            }
            this.factories = CollectionUtil.createArrayList(result.values());
            HashSet usableFeatures = CollectionUtil.createHashSet();
            for (RequestContextFactory<?> f : this.factories) {
                usableFeatures.addAll(CollectionUtil.asList(f.getFeatures()));
                RequestContextInfo.FeatureOrder[] featureOrders = f.featureOrders();
                if (featureOrders == null) continue;
                for (RequestContextInfo.FeatureOrder requiresFeature : featureOrders) {
                    if (!(requiresFeature instanceof RequestContextInfo.RequiresFeature) || usableFeatures.contains(requiresFeature.feature)) continue;
                    throw new IllegalArgumentException(String.format("Missing feature of %s, which is required by %s", requiresFeature.feature, f));
                }
            }
        }
        this.getLogger().debug("Initialized {}", (Object)this);
    }

    private void sort(int index, RequestContextFactory<?> f, Map<Integer, RequestContextFactory<?>> result, Set<Integer> processing) {
        if (!processing.contains(index)) {
            processing.add(index);
            for (Map.Entry<Integer, RequestContextFactory<?>> entry : this.getFactoriesBefore(f).entrySet()) {
                this.sort(entry.getKey(), entry.getValue(), result, processing);
            }
            result.put(index, f);
            processing.remove(index);
        }
    }

    private Map<Integer, RequestContextFactory<?>> getFactoriesBefore(RequestContextFactory<?> f) {
        LinkedHashMap<Integer, RequestContextFactory<?>> allBefore = CollectionUtil.createLinkedHashMap();
        for (int i = 0; i < this.factories.size(); ++i) {
            RequestContextFactory<?> test = this.factories.get(i);
            if (f == test || this.compare(test, f) >= 0) continue;
            allBefore.put(i, test);
        }
        return allBefore;
    }

    private int compare(RequestContextFactory<?> f1, RequestContextFactory<?> f2) {
        boolean f1BeforeF2 = this.compare(f1, RequestContextInfo.BeforeFeature.class, f2);
        boolean f2AfterF1 = this.compare(f2, RequestContextInfo.AfterFeature.class, f1);
        if (f1BeforeF2 || f2AfterF1) {
            return -1;
        }
        boolean f2BeforeF1 = this.compare(f2, RequestContextInfo.BeforeFeature.class, f1);
        boolean f1AfterF2 = this.compare(f1, RequestContextInfo.AfterFeature.class, f2);
        if (f2BeforeF1 || f1AfterF2) {
            return 1;
        }
        boolean f1BeforeAll = this.compareWithAll(f1, RequestContextInfo.BeforeFeature.class);
        boolean f2AfterAll = this.compareWithAll(f2, RequestContextInfo.AfterFeature.class);
        if (f1BeforeAll || f2AfterAll) {
            return -1;
        }
        boolean f2BeforeAll = this.compareWithAll(f2, RequestContextInfo.BeforeFeature.class);
        boolean f1AfterAll = this.compareWithAll(f1, RequestContextInfo.AfterFeature.class);
        if (f2BeforeAll || f1AfterAll) {
            return 1;
        }
        return 0;
    }

    private boolean compare(RequestContextFactory<?> f1, Class<? extends RequestContextInfo.FeatureOrder> type, RequestContextFactory<?> f2) {
        RequestContextInfo.FeatureOrder[] featureOrders = f1.featureOrders();
        String[] features = f2.getFeatures();
        if (ArrayUtil.isEmptyArray(features) || ArrayUtil.isEmptyArray(featureOrders)) {
            return false;
        }
        for (String feature : features) {
            for (RequestContextInfo.FeatureOrder featureOrder : featureOrders) {
                if (!type.isInstance(featureOrder) || !ObjectUtil.isEquals(featureOrder.feature, feature)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareWithAll(RequestContextFactory<?> f1, Class<? extends RequestContextInfo.FeatureOrder> type) {
        RequestContextInfo.FeatureOrder[] featureOrders = f1.featureOrders();
        if (ArrayUtil.isEmptyArray(featureOrders)) {
            return false;
        }
        for (RequestContextInfo.FeatureOrder featureOrder : featureOrders) {
            if (!type.isInstance(featureOrder) || !ObjectUtil.isEquals(featureOrder.feature, "*")) continue;
            return true;
        }
        return false;
    }

    @Override
    public RequestContextInfo<?>[] getRequestContextInfos() {
        return this.factories.toArray(new RequestContextInfo[this.factories.size()]);
    }

    @Override
    public RequestContext getRequestContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.assertInitialized();
        SimpleRequestContext requestContext = new SimpleRequestContext(servletContext, request, response);
        RequestContextUtil.setRequestContext(requestContext);
        for (RequestContextFactory<?> factory : this.factories) {
            requestContext = factory.getRequestContextWrapper(requestContext);
            this.prepareRequestContext(requestContext);
            RequestContextUtil.setRequestContext(requestContext);
        }
        this.setupSpringWebEnvironment(requestContext.getRequest());
        return requestContext;
    }

    private void prepareRequestContext(RequestContext requestContext) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("Preparing request context: {}", (Object)requestContext.getClass().getSimpleName());
        }
        requestContext.prepare();
    }

    @Override
    public void commitRequestContext(RequestContext requestContext) throws RequestContextException {
        this.assertInitialized();
        for (RequestContext rc = requestContext; rc != null; rc = rc.getWrappedRequestContext()) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Committing request context: {}", (Object)rc.getClass().getSimpleName());
            }
            rc.commit();
        }
        this.cleanupSpringWebEnvironment(requestContext.getRequest());
        RequestContextUtil.removeRequestContext(requestContext.getRequest());
    }

    private void setupSpringWebEnvironment(HttpServletRequest request) {
        ServletRequestAttributes attributes = new ServletRequestAttributes(request);
        LocaleContextHolder.setLocale((Locale)request.getLocale(), (boolean)this.threadContextInheritable);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes, (boolean)this.threadContextInheritable);
        this.getLogger().debug("Bound request context to thread: {}", (Object)request);
    }

    private void cleanupSpringWebEnvironment(HttpServletRequest request) {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        RequestContextHolder.resetRequestAttributes();
        LocaleContextHolder.resetLocaleContext();
        if (attributes instanceof ServletRequestAttributes) {
            ((ServletRequestAttributes)attributes).requestCompleted();
        }
        this.getLogger().debug("Cleared thread-bound request context: {}", (Object)request);
    }

    @Override
    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.append(this.getBeanDescription()).start();
        for (RequestContextFactory<?> factory : this.factories) {
            buf.format("  %s with features %s, ordering %s\n", factory.getRequestContextInterface().getSimpleName(), CollectionUtil.asList(factory.getFeatures()), CollectionUtil.asList(factory.featureOrders()));
        }
        return buf.end().toString();
    }
}

