/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl.valve;

import com.alibaba.citrus.service.pipeline.Condition;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.PipelineInvocationHandle;
import com.alibaba.citrus.service.pipeline.impl.valve.LoopValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class WhileLoopValve
extends LoopValve {
    private Condition condition;

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        Assert.assertNotNull(this.condition, "no condition", new Object[0]);
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        this.assertInitialized();
        PipelineInvocationHandle handle = this.initLoop(pipelineContext);
        while (this.condition.isSatisfied(handle)) {
            this.invokeBody(handle);
            if (!handle.isBroken()) continue;
        }
        pipelineContext.invokeNext();
    }

    @Override
    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("condition", this.condition);
        mb.append("loopBody", this.getLoopBody());
        return new ToStringBuilder().append("WhileLoopValve").append(mb).toString();
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<WhileLoopValve> {
        protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "maxLoopCount", "loopCounterName");
            builder.addPropertyValue("loopBody", this.parsePipeline(element, parserContext));
            Object condition = this.parseCondition(element, parserContext, builder);
            if (condition != null) {
                builder.addPropertyValue("condition", condition);
            }
        }
    }
}

