/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl.valve;

import com.alibaba.citrus.service.pipeline.Pipeline;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.PipelineInvocationHandle;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class TryCatchFinallyValve
extends AbstractValve {
    private static final String DEFAULT_EXCEPTION_NAME = "exception";
    private Pipeline tryPipeline;
    private Pipeline catchPipeline;
    private Pipeline finallyPipeline;
    private String exceptionName;

    public Pipeline getTry() {
        return this.tryPipeline;
    }

    public void setTry(Pipeline tryPipeline) {
        this.tryPipeline = tryPipeline;
    }

    public Pipeline getCatch() {
        return this.catchPipeline;
    }

    public void setCatch(Pipeline catchPipeline) {
        this.catchPipeline = catchPipeline;
    }

    public String getExceptionName() {
        return ObjectUtil.defaultIfNull(this.exceptionName, DEFAULT_EXCEPTION_NAME);
    }

    public void setExceptionName(String exceptionName) {
        this.exceptionName = StringUtil.trimToNull(exceptionName);
    }

    public Pipeline getFinally() {
        return this.finallyPipeline;
    }

    public void setFinally(Pipeline finallyPipeline) {
        this.finallyPipeline = finallyPipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        block8: {
            try {
                if (this.tryPipeline != null) {
                    this.tryPipeline.newInvocation(pipelineContext).invoke();
                }
            }
            catch (Exception e) {
                if (this.catchPipeline != null) {
                    PipelineInvocationHandle handle = this.catchPipeline.newInvocation(pipelineContext);
                    handle.setAttribute(this.getExceptionName(), e);
                    handle.invoke();
                    break block8;
                }
                throw e;
            }
            finally {
                if (this.finallyPipeline != null) {
                    this.finallyPipeline.newInvocation(pipelineContext).invoke();
                }
            }
        }
        pipelineContext.invokeNext();
    }

    @Override
    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        if (this.tryPipeline != null) {
            mb.append("try", this.tryPipeline);
        }
        if (this.catchPipeline != null) {
            mb.append("catch", this.catchPipeline);
        }
        if (this.finallyPipeline != null) {
            mb.append("finally", this.finallyPipeline);
        }
        if (this.exceptionName != null) {
            mb.append("exceptionName", this.exceptionName);
        }
        return new ToStringBuilder().append("TryCatchFinally").append(mb).toString();
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<TryCatchFinallyValve> {
        protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            DomUtil.ElementSelector trySelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("try"));
            DomUtil.ElementSelector catchSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("catch"));
            DomUtil.ElementSelector finallySelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("finally"));
            for (Element subElement : DomUtil.subElements(element)) {
                if (trySelector.accept(subElement)) {
                    builder.addPropertyValue("try", this.parsePipeline(subElement, element, parserContext));
                    continue;
                }
                if (catchSelector.accept(subElement)) {
                    builder.addPropertyValue("catch", this.parsePipeline(subElement, element, parserContext));
                    SpringExtUtil.attributesToProperties(subElement, builder, "exceptionName");
                    continue;
                }
                if (!finallySelector.accept(subElement)) continue;
                builder.addPropertyValue("finally", this.parsePipeline(subElement, element, parserContext));
            }
        }
    }
}

