/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.factory;

import com.alibaba.citrus.service.moduleloader.impl.factory.AbstractModuleFactoryDefinitionParser;
import com.alibaba.citrus.service.moduleloader.impl.factory.ClassModuleFactory;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.ClassNameWildcardCompiler;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.w3c.dom.Element;

public class ClassModuleFactoryDefinitionParser
extends AbstractModuleFactoryDefinitionParser<ClassModuleFactory> {
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Map<String, AbstractModuleFactoryDefinitionParser.ParsingModuleInfo> classes = this.parseSpecificBeans(element, parserContext, builder.getRawBeanDefinition(), DomUtil.and(DomUtil.beansNs(), DomUtil.name("bean")));
        DomUtil.ElementSelector searchPackages = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("search-packages"));
        DomUtil.ElementSelector searchClasses = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("search-classes"));
        ModuleDefinitionScanner scanner = this.getScanner(parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            Pattern classNamePattern = null;
            String typeName = null;
            String moduleName = null;
            String classResourceName = null;
            if (searchPackages.accept(subElement)) {
                String packageName = Assert.assertNotNull(ClassNameWildcardCompiler.normalizeClassName(subElement.getAttribute("packages")), "no package name provided for search-packages", new Object[0]);
                classNamePattern = ClassNameWildcardCompiler.compileClassName(packageName, 4096);
                typeName = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("type")), "no type name provided", new Object[0]);
                classResourceName = ClassNameWildcardCompiler.classNameToPathName(packageName) + "/**/*.class";
                this.log.trace("Searching in packages: {}, moduleType={}", (Object)packageName, (Object)typeName);
            } else if (searchClasses.accept(subElement)) {
                String className = Assert.assertNotNull(ClassNameWildcardCompiler.normalizeClassName(subElement.getAttribute("classes")), "no class name provided for search-classes", new Object[0]);
                classNamePattern = ClassNameWildcardCompiler.compileClassName(className, 4096);
                typeName = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("type")), "no type name provided", new Object[0]);
                moduleName = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("name")), "no module name provided", new Object[0]);
                classResourceName = ClassNameWildcardCompiler.classNameToPathName(className);
                classResourceName = classResourceName.endsWith("**") ? classResourceName + "/*.class" : classResourceName + ".class";
                this.log.trace("Searching for classes: {}, moduleType={}, moduleName={}", new Object[]{className, typeName, moduleName});
            }
            boolean includeAbstractClasses = "true".equalsIgnoreCase(StringUtil.trimToNull(subElement.getAttribute("includeAbstractClasses")));
            if (classResourceName == null) continue;
            ClassLoader classLoader = scanner.getResourceLoader().getClassLoader();
            LinkedList<TypeFilter> includes = CollectionUtil.createLinkedList();
            LinkedList<TypeFilter> excludes = CollectionUtil.createLinkedList();
            this.parseTypeFilters(subElement, classLoader, includes, excludes);
            ModuleTypeFilter filter = new ModuleTypeFilter(classes, classNamePattern, typeName, moduleName, includes);
            scanner.addIncludeFilter(filter);
            for (TypeFilter exclude : excludes) {
                scanner.addExcludeFilter(exclude);
            }
            scanner.setBeanNameGenerator(filter);
            scanner.setResourcePattern(classResourceName.replace('?', '*'));
            scanner.setIncludeAbstractClasses(includeAbstractClasses);
            scanner.setBeanDefinitionDefaults(this.getBeanDefinitionDefaults(subElement, parserContext));
            int found = scanner.scan(new String[]{""});
            this.log.debug("Found {} module classes with pattern: {}", (Object)found, (Object)classResourceName);
        }
        this.postProcessItems(element, parserContext, builder, classes, "search-packages or search-classes");
    }

    private ModuleDefinitionScanner getScanner(ParserContext parserContext) {
        ModuleDefinitionScanner scanner = new ModuleDefinitionScanner(parserContext.getRegistry());
        scanner.setResourceLoader(parserContext.getReaderContext().getResourceLoader());
        return scanner;
    }

    @Override
    protected String parseItemName(ParserContext parserContext, Element element, BeanDefinition bd) {
        return Assert.assertNotNull(bd.getBeanClassName(), "no className provided for bean definition: %s", bd);
    }

    @Override
    protected String getDefaultName() {
        return "classModuleFactory";
    }

    private void parseTypeFilters(Element element, ClassLoader classLoader, List<TypeFilter> includes, List<TypeFilter> excludes) {
        DomUtil.ElementSelector includeSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("include-filter"));
        DomUtil.ElementSelector excludeSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("exclude-filter"));
        for (Element subElement : DomUtil.subElements(element)) {
            TypeFilter filter;
            if (includeSelector.accept(subElement)) {
                filter = this.createTypeFilter(subElement, classLoader);
                if (filter == null) continue;
                includes.add(filter);
                continue;
            }
            if (!excludeSelector.accept(subElement) || (filter = this.createTypeFilter(subElement, classLoader)) == null) continue;
            excludes.add(filter);
        }
    }

    private TypeFilter createTypeFilter(Element element, ClassLoader classLoader) {
        String filterType = ObjectUtil.defaultIfNull(StringUtil.trimToNull(element.getAttribute("type")), "wildcard");
        String expression = Assert.assertNotNull(StringUtil.trimToNull(element.getAttribute("expression")), "expression for %s" + filterType, new Object[0]);
        try {
            if ("assignable".equals(filterType)) {
                return new AssignableTypeFilter(classLoader.loadClass(expression));
            }
            if ("aspectj".equals(filterType)) {
                return new AspectJTypeFilter(expression, classLoader);
            }
            if ("wildcard".equals(filterType)) {
                return new RegexPatternTypeFilter(ClassNameWildcardCompiler.compileClassName(expression, 4096));
            }
            if ("custom".equals(filterType)) {
                Class<?> filterClass = classLoader.loadClass(expression);
                Assert.assertTrue(TypeFilter.class.isAssignableFrom(filterClass), "Class is not assignable to TypeFilter: %s", expression);
                return (TypeFilter)BeanUtils.instantiateClass(filterClass);
            }
            Assert.unreachableCode("Unsupported filter type: %s", filterType);
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new FatalBeanException("Failed to create TypeFilter of type " + filterType + ": " + expression, (Throwable)e);
        }
    }

    public static class NonInstantiatableClassFactoryBean
    implements FactoryBean {
        private final Class<?> clazz;

        public NonInstantiatableClassFactoryBean(Class<?> clazz) {
            this.clazz = Assert.assertNotNull(clazz, "class", new Object[0]);
        }

        public Object getObject() throws Exception {
            return this.clazz;
        }

        public Class<?> getObjectType() {
            return Class.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    private static class ModuleTypeFilter
    extends AbstractModuleFactoryDefinitionParser.ParsingModuleMatcher
    implements TypeFilter,
    BeanNameGenerator {
        public ModuleTypeFilter(Map<String, AbstractModuleFactoryDefinitionParser.ParsingModuleInfo> classes, Pattern classNamePattern, String typeName, String moduleName, List<TypeFilter> includeFilters) {
            super(classes, classNamePattern, typeName, moduleName, includeFilters);
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return this.doMatch(metadataReader, metadataReaderFactory);
        }

        public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
            String className = definition instanceof AnnotatedBeanDefinition ? ((AnnotatedBeanDefinition)definition).getMetadata().getClassName() : definition.getBeanClassName();
            return this.generateBeanName(className, registry);
        }
    }

    private static class ModuleDefinitionScanner
    extends ClassPathBeanDefinitionScanner {
        private boolean includeAbstractClasses;

        public ModuleDefinitionScanner(BeanDefinitionRegistry registry) {
            super(registry, false);
        }

        public void setIncludeAbstractClasses(boolean includeAbstractClasses) {
            this.includeAbstractClasses = includeAbstractClasses;
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            if (beanDefinition.getMetadata().getClassName().contains("$")) {
                return false;
            }
            if (super.isCandidateComponent(beanDefinition)) {
                return true;
            }
            if (!this.includeAbstractClasses) {
                return false;
            }
            beanDefinition.setBeanClassName(NonInstantiatableClassFactoryBean.class.getName());
            beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)beanDefinition.getMetadata().getClassName(), Class.class.getName());
            return true;
        }
    }
}

