/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mappingrule.impl.rule;

import com.alibaba.citrus.service.mappingrule.MappingRuleException;
import com.alibaba.citrus.service.mappingrule.impl.rule.FallbackIterator;
import com.alibaba.citrus.service.mappingrule.support.AbstractModuleMappingRule;
import com.alibaba.citrus.service.mappingrule.support.AbstractModuleMappingRuleDefinitionParser;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderException;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class FallbackModuleMappingRule
extends AbstractModuleMappingRule {
    public static final String DEFAULT_NAME = "Default";
    public static final boolean DEFAULT_MATCH_LAST_NAME = false;
    private String defaultName;
    private boolean matchLastName;

    public void setDefaultName(String defaultName) {
        this.defaultName = StringUtil.trimToNull(defaultName);
    }

    public void setMatchLastName(boolean matchLastName) {
        this.matchLastName = matchLastName;
    }

    @Override
    protected void initMappingRule() {
        Assert.assertNotNull(this.getModuleLoaderService(), "moduleLoaderService", new Object[0]);
        Assert.assertNotNull(this.getModuleType(), "moduleType", new Object[0]);
    }

    @Override
    public String doMapping(String name) {
        FallbackModuleIterator iter = new FallbackModuleIterator(name, this.defaultName, this.matchLastName);
        String moduleName = null;
        String firstModuleName = iter.getNext();
        while (iter.hasNext()) {
            moduleName = iter.next();
            this.log.debug("Looking for module: " + moduleName);
            try {
                if (this.getModuleLoaderService().getModuleQuiet(this.getModuleType(), moduleName) == null) continue;
                return moduleName;
            }
            catch (ModuleLoaderException e) {
                throw new MappingRuleException(e);
            }
        }
        return firstModuleName;
    }

    public static class DefinitionParser
    extends AbstractModuleMappingRuleDefinitionParser<FallbackModuleMappingRule> {
        @Override
        protected void doParseModuleMappingRule(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "defaultName", "matchLastName");
        }
    }

    static class FallbackModuleIterator
    extends FallbackIterator {
        public FallbackModuleIterator(String name, String finalName, boolean matchLastName) {
            super(name, FallbackModuleMappingRule.DEFAULT_NAME, finalName, matchLastName);
        }

        @Override
        protected void invalidName(String name) {
            FallbackModuleMappingRule.throwInvalidNameException(name);
        }

        @Override
        protected String normalizeLastName(String lastName) {
            return FallbackModuleMappingRule.normalizeClassName(lastName);
        }

        @Override
        protected String generateFullName(List<String> names) {
            return StringUtil.join(names, ".");
        }
    }
}

