/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.util;

import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.ByteArray;
import com.alibaba.citrus.util.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MailUtil {
    public static String getJavaCharset(String javaCharset) {
        javaCharset = StringUtil.trimToNull(javaCharset);
        return ObjectUtil.defaultIfNull(javaCharset, "UTF-8");
    }

    public static String toString(Message message) throws MessagingException {
        try {
            return MailUtil.toString(message, null);
        }
        catch (UnsupportedEncodingException e) {
            Assert.unexpectedException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Message message, String javaCharset) throws MessagingException, UnsupportedEncodingException {
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)ostream);
        }
        catch (IOException e) {
            Assert.unexpectedException(e);
        }
        finally {
            ostream.close();
        }
        ByteArray bytes = ostream.toByteArray();
        javaCharset = MailUtil.getJavaCharset(javaCharset);
        return new String(bytes.getRawBytes(), bytes.getOffset(), bytes.getLength(), javaCharset);
    }

    public static String encodeHeader(String header, String javaCharset) throws UnsupportedEncodingException {
        return MailUtil.encodeHeader(header, javaCharset, null);
    }

    public static String encodeHeader(String header, String javaCharset, String encoding) throws UnsupportedEncodingException {
        header = ObjectUtil.defaultIfNull(header, "");
        String mimeCharset = MimeUtility.mimeCharset((String)MailUtil.getJavaCharset(javaCharset));
        return MimeUtility.encodeText((String)header, (String)mimeCharset, (String)encoding);
    }

    public static InternetAddress[] parse(String addrList, String javaCharset) throws AddressException, UnsupportedEncodingException {
        return MailUtil.parse(addrList, javaCharset, false);
    }

    public static InternetAddress[] parse(String addrList, String javaCharset, boolean strict) throws AddressException, UnsupportedEncodingException {
        InternetAddress[] addrs = InternetAddress.parse((String)ObjectUtil.defaultIfNull(addrList, ""), (boolean)strict);
        if (!ArrayUtil.isEmptyArray(addrs)) {
            String mimeCharset = MimeUtility.mimeCharset((String)MailUtil.getJavaCharset(javaCharset));
            for (InternetAddress addr : addrs) {
                if (StringUtil.isEmpty(addr.getAddress())) {
                    throw new AddressException("Empty address");
                }
                addr.setPersonal(StringUtil.trimToNull(addr.getPersonal()), mimeCharset);
            }
        }
        return addrs;
    }

    public static ContentType getContentType(String contentType, String javaCharset) throws ParseException {
        Assert.assertNotNull(contentType, "contentType", new Object[0]);
        ContentType contentTypeObject = new ContentType(contentType);
        javaCharset = StringUtil.trimToNull(javaCharset);
        if (javaCharset != null) {
            contentTypeObject.setParameter("charset", MimeUtility.mimeCharset((String)javaCharset));
        }
        return contentTypeObject;
    }
}

