/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.builder.content;

import com.alibaba.citrus.service.mail.builder.MailBuilder;
import com.alibaba.citrus.service.mail.builder.MailBuilderException;
import com.alibaba.citrus.service.mail.builder.content.AbstractContent;
import com.alibaba.citrus.service.pull.PullContext;
import com.alibaba.citrus.service.pull.PullService;
import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.service.template.TemplateException;
import com.alibaba.citrus.service.template.TemplateService;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class TemplateContent
extends AbstractContent {
    private TemplateService templateService;
    private PullService pullService;
    private String templateName;
    private String contentType;
    private transient TemplateContext templateContext;

    public TemplateService getTemplateService() {
        return Assert.assertNotNull(this.getService(TemplateService.class, "templateService", this.templateService), "templateService", new Object[0]);
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public PullService getPullService() {
        return this.getService(PullService.class, "pullService", this.pullService);
    }

    public void setPullService(PullService pullService) {
        this.pullService = pullService;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplate(String templateName) {
        this.templateName = StringUtil.trimToNull(templateName);
    }

    public String getContentType() {
        return ObjectUtil.defaultIfNull(this.contentType, this.getDefaultContentType());
    }

    protected String getDefaultContentType() {
        return "text/plain";
    }

    public void setContentType(String contentType) {
        this.contentType = StringUtil.trimToNull(contentType);
    }

    protected final String renderTemplate() throws MailBuilderException {
        try {
            return this.getTemplateService().getText(this.templateName, this.getTemplateContext());
        }
        catch (TemplateException e) {
            throw new MailBuilderException("Failed to render template: " + this.templateName, e);
        }
        catch (IOException e) {
            throw new MailBuilderException("Failed to render template: " + this.templateName, e);
        }
    }

    private TemplateContext getTemplateContext() {
        if (this.templateContext == null) {
            PullService pullService = this.getPullService();
            PullContext pullContext = null;
            if (pullService != null) {
                pullContext = pullService.getContext();
            }
            this.templateContext = new TemplateContextAdapter(this.getMailBuilder(), pullContext);
            this.populateTemplateContext(this.templateContext);
        }
        return this.templateContext;
    }

    protected void populateTemplateContext(TemplateContext templateContext) {
    }

    @Override
    protected void copyTo(AbstractContent copy) {
        TemplateContent copyContent = (TemplateContent)copy;
        copyContent.templateService = this.templateService;
        copyContent.pullService = this.pullService;
        copyContent.templateName = this.templateName;
        copyContent.contentType = this.contentType;
    }

    @Override
    protected void toString(ToStringBuilder.MapBuilder mb) {
        mb.append("contentType", this.getContentType());
        mb.append("templateName", this.templateName);
    }

    private static class TemplateContextAdapter
    implements TemplateContext {
        private final MailBuilder builder;
        private final PullContext pullContext;

        public TemplateContextAdapter(MailBuilder builder, PullContext pullContext) {
            this.builder = Assert.assertNotNull(builder, "mailBuilder", new Object[0]);
            this.pullContext = pullContext;
        }

        @Override
        public boolean containsKey(String key) {
            return this.builder.getAttribute(key) != null || this.pull(key) != null;
        }

        @Override
        public Object get(String key) {
            Object object = this.builder.getAttribute(key);
            if (object == null) {
                return this.pull(key);
            }
            return object;
        }

        @Override
        public Set<String> keySet() {
            if (this.pullContext == null) {
                return this.builder.getAttributeKeys();
            }
            HashSet<String> keys = CollectionUtil.createHashSet(this.builder.getAttributeKeys());
            keys.addAll(this.pullContext.getToolNames());
            return keys;
        }

        @Override
        public void put(String key, Object value) {
            this.builder.setAttribute(key, value);
        }

        @Override
        public void remove(String key) {
            this.builder.setAttribute(key, null);
        }

        private Object pull(String key) {
            if (this.pullContext != null) {
                return this.pullContext.pull(key);
            }
            return null;
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setSortKeys(true).setPrintCount(true);
            for (String key : this.builder.getAttributeKeys()) {
                mb.append(key, this.builder.getAttribute(key));
            }
            return mb.toString();
        }
    }
}

