/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation;

import com.alibaba.citrus.service.form.impl.validation.StringLengthValidator;
import com.alibaba.citrus.service.form.support.AbstractValidatorDefinitionParser;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.i18n.LocaleUtil;
import java.io.UnsupportedEncodingException;

public class StringByteLengthValidator
extends StringLengthValidator {
    private String charset;

    public String getCharset() {
        if (this.charset == null) {
            return LocaleUtil.getContext().getCharset().name();
        }
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = StringUtil.trimToNull(charset);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        Assert.assertTrue(LocaleUtil.isCharsetSupported(this.getCharset()), "Invalid charset: " + this.getCharset(), new Object[0]);
    }

    @Override
    protected int getLength(String value) {
        try {
            return value.getBytes(this.getCharset()).length;
        }
        catch (UnsupportedEncodingException e) {
            return -1;
        }
    }

    public static class DefinitionParser
    extends AbstractValidatorDefinitionParser<StringByteLengthValidator> {
    }
}

