/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.generictype.WildcardTypeInfo;
import com.alibaba.citrus.generictype.impl.AbstractBoundedTypeInfo;
import com.alibaba.citrus.util.CollectionUtil;
import java.util.Collections;
import java.util.List;

class WildcardTypeImpl
extends AbstractBoundedTypeInfo
implements WildcardTypeInfo {
    private final List<TypeInfo> lowerBounds;
    private final boolean unknown;

    WildcardTypeImpl(TypeInfo[] upperBounds, TypeInfo[] lowerBounds) {
        super(upperBounds);
        this.lowerBounds = Collections.unmodifiableList(CollectionUtil.asList(lowerBounds));
        this.unknown = upperBounds.length == 1 && upperBounds[0].equals(TypeInfo.OBJECT);
    }

    @Override
    public String getName() {
        return "?";
    }

    @Override
    public String getSimpleName() {
        return "?";
    }

    @Override
    public List<TypeInfo> getLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public boolean isUnknown() {
        return this.unknown;
    }

    @Override
    public TypeInfo resolve(GenericDeclarationInfo context) {
        return this.resolve(context, true);
    }

    @Override
    public TypeInfo resolve(GenericDeclarationInfo context, boolean includeBaseType) {
        if (this.unknown) {
            return this;
        }
        return this.getUpperBounds().get(0).resolve(context, includeBaseType);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("?");
        List<TypeInfo> lowerBounds = this.getLowerBounds();
        if (!this.unknown) {
            buf.append(" extends ");
            CollectionUtil.join(buf, this.getUpperBounds(), " & ");
            if (!lowerBounds.isEmpty()) {
                buf.append(", ");
            }
        }
        if (!lowerBounds.isEmpty()) {
            buf.append(" super ");
            CollectionUtil.join(buf, lowerBounds, " & ");
        }
        return buf.toString();
    }
}

