/*
 * Decompiled with CFR 0.152.
 */
package com.wing321.test.spring.listener;

import com.wing321.annotations.devtime.CreateTable;
import com.wing321.annotations.devtime.StoreData;
import com.wing321.lang.FastDate;
import com.wing321.test.persistence.metadata.ColumnMetadata;
import com.wing321.test.persistence.metadata.TableMetadata;
import com.wing321.test.persistence.utils.EntityUtils;
import com.wing321.test.persistence.utils.PersistenceUtils;
import com.wing321.utils.CsvWriter;
import com.wing321.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class PersistenceTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(PersistenceTestExecutionListener.class);
    Class[] entities = null;

    public void beforeTestMethod(TestContext ctx) throws Exception {
        Method testMethod = ctx.getTestMethod();
        Class testClass = ctx.getTestClass();
        CreateTable createTable = testMethod.getAnnotation(CreateTable.class);
        if (createTable != null) {
            Class[] clazzs = createTable.value();
            this.entities = clazzs;
            boolean test = createTable.test();
            boolean drop = createTable.drop();
            String db = createTable.db();
            for (Class clazz : clazzs) {
                JdbcTemplate jdbcTemplate = (JdbcTemplate)ctx.getApplicationContext().getBean("jdbcTemplate");
                if (drop) {
                    String dropSql = PersistenceUtils.dropTable(clazz, test);
                    logger.info((Object)("this is a auto drop table sql:\n" + dropSql));
                    jdbcTemplate.execute(dropSql);
                }
                String createSql = PersistenceUtils.createTable(clazz, test, db);
                logger.info((Object)("this is a auto create table sql:\n" + createSql));
                jdbcTemplate.execute(createSql);
            }
        }
        super.beforeTestMethod(ctx);
    }

    public void afterTestMethod(TestContext ctx) throws Exception {
        Method testMethod = ctx.getTestMethod();
        Class testClass = ctx.getTestClass();
        StoreData storeData = testMethod.getAnnotation(StoreData.class);
        if (storeData == null || !storeData.enable()) {
            return;
        }
        String[] header = null;
        for (Class clazz : this.entities) {
            TableMetadata tableMetadata = EntityUtils.extractTable(clazz);
            final Map<String, ColumnMetadata> columns = EntityUtils.extractFields(clazz);
            StringBuilder sql = new StringBuilder("SELECT ");
            int i = 0;
            final int size = columns.size();
            header = new String[size];
            for (String col : columns.keySet()) {
                sql.append(col).append(",");
                header[i] = col;
                ++i;
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(" FROM ").append(tableMetadata.getName());
            JdbcTemplate jdbcTemplate = (JdbcTemplate)ctx.getApplicationContext().getBean("jdbcTemplate");
            List list = jdbcTemplate.query(sql.toString(), (RowMapper)new RowMapper<String[]>(){

                public String[] mapRow(ResultSet resultSet, int i) throws SQLException {
                    String[] datas = new String[size];
                    for (int k = 0; k < columns.size(); ++k) {
                        datas[k] = resultSet.getString(k + 1);
                    }
                    return datas;
                }
            });
            if (list.isEmpty()) {
                logger.warn((Object)"\u6570\u636e\u5e93\u8868\u672a\u53d1\u751f\u6301\u4e45\uff0c\u653e\u5f03\u5b58\u50a8");
                return;
            }
            File dir = new File("data/" + StringUtils.dotToSlash((String)testClass.getName()));
            logger.warn((Object)("\u4fdd\u5b58\u6570\u636e\u5e93\u6570\u636e\u5230\u6587\u4ef6:" + dir.getCanonicalPath()));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            CsvWriter writer = new CsvWriter(new File(dir, testMethod.getName() + new FastDate().toString() + ".csv").getCanonicalPath());
            writer.writeRecord(header);
            for (String[] datas : list) {
                writer.writeRecord(datas);
            }
            writer.close();
        }
        super.afterTestMethod(ctx);
    }
}

