/*
 * Decompiled with CFR 0.152.
 */
package com.wing321.test.persistence.utils;

import com.wing321.annotations.runtime.persistence.Comment;
import com.wing321.test.persistence.metadata.ColumnMetadata;
import com.wing321.test.persistence.metadata.TableMetadata;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

public abstract class EntityUtils {
    public static TableMetadata extractTable(Class entityClass) {
        Table table = entityClass.getAnnotation(Table.class);
        Comment comment = entityClass.getAnnotation(Comment.class);
        if (table != null && table.name() != null && table.name().trim().length() > 0) {
            String commentStr = comment == null ? "" : comment.value();
            TableMetadata tableVO = new TableMetadata(table.name(), commentStr);
            return tableVO;
        }
        throw new IllegalArgumentException();
    }

    public static Map<String, ColumnMetadata> extractFields(Class entityClass) {
        Field[] fields = entityClass.getDeclaredFields();
        LinkedHashMap<String, ColumnMetadata> fieldsMap = new LinkedHashMap<String, ColumnMetadata>();
        for (Field field : fields) {
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            ColumnMetadata columnVO = EntityUtils.extractField(field);
            fieldsMap.put(columnVO.getJdbcName(), columnVO);
        }
        return fieldsMap;
    }

    public static List<String> extractPrimaryKey(Class entityClass) {
        Field[] fields = entityClass.getDeclaredFields();
        ArrayList<String> pks = new ArrayList<String>();
        for (Field field : fields) {
            Id id = field.getAnnotation(Id.class);
            Column column = field.getAnnotation(Column.class);
            if (id == null || column == null) continue;
            pks.add(column.name());
        }
        return pks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ColumnMetadata extractField(Field field) {
        Column column = field.getAnnotation(Column.class);
        Comment comment = field.getAnnotation(Comment.class);
        GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
        String jdbcName = column.name();
        String commentStr = comment == null ? "" : comment.value();
        int precision = column.precision();
        int scale = column.scale();
        boolean nullable = column.nullable();
        boolean autoKey = generatedValue == null ? false : generatedValue.strategy() == GenerationType.AUTO || generatedValue.strategy() == GenerationType.IDENTITY;
        String dataType = null;
        String jdbcType = null;
        Class<?> fieldClass = field.getType();
        if (fieldClass == BigDecimal.class) {
            dataType = scale > 0 && precision > 0 ? "DECIMAL(" + scale + "," + precision + ")" : (scale > 0 && precision == 0 ? "DECIMAL(" + scale + ")" : (scale == 0 && precision > 0 ? "DECIMAL(18," + scale + ")" : "DECIMAL(18,2)"));
            jdbcType = "DECIMAL";
            return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
        } else if (fieldClass == Integer.class || fieldClass == Integer.TYPE) {
            dataType = "NUMERIC";
            jdbcType = "NUMERIC";
            return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
        } else if (fieldClass == String.class) {
            if (scale <= 0) throw new IllegalArgumentException("\u5b57\u6bb5[" + jdbcName + "]\u4e3aVARCHAR\u7c7b\u578b\uff0c\u4f46\u662f\u6ca1\u6709\u6307\u5b9ascale");
            dataType = "VARCHAR(" + scale + ")";
            jdbcType = "VARCHAR";
            return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
        } else if (fieldClass == Date.class) {
            Temporal temporal = field.getAnnotation(Temporal.class);
            if (temporal == null) {
                dataType = "DATETIME";
                jdbcType = "DATE";
                return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
            } else if (TemporalType.TIMESTAMP == temporal.value()) {
                dataType = "TIMESTAMP";
                jdbcType = "TIMESTAMP";
                return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
            } else if (TemporalType.TIME == temporal.value()) {
                dataType = "TIME";
                jdbcType = "TIME";
                return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
            } else {
                dataType = "DATETIME";
                jdbcType = "DATE";
            }
            return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
        } else {
            if (fieldClass != Timestamp.class) return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
            dataType = "TIMESTAMP";
            jdbcType = "TIMESTAMP";
        }
        return new ColumnMetadata(field.getName(), jdbcName, dataType, jdbcType, nullable, commentStr, autoKey);
    }
}

