/*
 * Decompiled with CFR 0.152.
 */
package com.wing321.test.junit4;

import com.wing321.annotations.devtime.TestOrder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

public class OrderedSpringJUnit4ClassRunner
extends SpringJUnit4ClassRunner {
    private static final Log logger = LogFactory.getLog((String)OrderedSpringJUnit4ClassRunner.class.getSimpleName());
    private static List<FrameworkMethod> testMethodList;

    public OrderedSpringJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (testMethodList == null) {
            testMethodList = super.computeTestMethods();
            this.sort(testMethodList);
        }
        return testMethodList;
    }

    void sort(List<FrameworkMethod> testMethodList) {
        Collections.sort(testMethodList, new Comparator<FrameworkMethod>(){

            @Override
            public int compare(FrameworkMethod m1, FrameworkMethod m2) {
                TestOrder o1 = (TestOrder)m1.getAnnotation(TestOrder.class);
                TestOrder o2 = (TestOrder)m2.getAnnotation(TestOrder.class);
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.value() - o2.value();
            }
        });
        int sortPos = 0;
        for (FrameworkMethod method : testMethodList) {
            logger.info((Object)("[" + ++sortPos + "]-" + method.getName()));
        }
    }
}

