/*
 * Decompiled with CFR 0.152.
 */
package com.wing321.test;

import com.wing321.test.BaseTest;
import com.wing321.test.spring.listener.PersistenceTestExecutionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.jdbc.SqlScriptsTestExecutionListener;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@TestExecutionListeners(value={PersistenceTestExecutionListener.class, TransactionalTestExecutionListener.class, SqlScriptsTestExecutionListener.class})
public abstract class PersistenceBaseTest
extends BaseTest {
    protected JdbcTemplate jdbcTemplate;
    private String sqlScriptEncoding = "UTF-8";

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected int countRowsInTable(String tableName) {
        return JdbcTestUtils.countRowsInTable((JdbcTemplate)this.jdbcTemplate, (String)tableName);
    }

    protected int countRowsInTableWhere(String tableName, String whereClause) {
        return JdbcTestUtils.countRowsInTableWhere((JdbcTemplate)this.jdbcTemplate, (String)tableName, (String)whereClause);
    }

    protected int deleteFromTables(String ... names) {
        return JdbcTestUtils.deleteFromTables((JdbcTemplate)this.jdbcTemplate, (String[])names);
    }

    protected int deleteFromTableWhere(String tableName, String whereClause, Object ... args) {
        return JdbcTestUtils.deleteFromTableWhere((JdbcTemplate)this.jdbcTemplate, (String)tableName, (String)whereClause, (Object[])args);
    }

    protected void dropTables(String ... names) {
        JdbcTestUtils.dropTables((JdbcTemplate)this.jdbcTemplate, (String[])names);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    protected void executeSqlScript(String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(sqlResourcePath);
        try {
            System.out.println(new File(url.toURI().getRawPath()).getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        Resource resource = this.applicationContext.getResource(sqlResourcePath);
        new ResourceDatabasePopulator(continueOnError, false, this.sqlScriptEncoding, new Resource[]{resource}).execute(this.jdbcTemplate.getDataSource());
    }
}

