/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.notification.PlatformNotification;
import cn.jpush.api.utils.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class WinphoneNotification
extends PlatformNotification {
    private static final String NOTIFICATION_WINPHONE = "winphone";
    private static final String TITLE = "title";
    private static final String _OPEN_PAGE = "_open_page";
    private final String title;
    private final String openPage;

    private WinphoneNotification(String alert, String title, String openPage, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        super(alert, extras, numberExtras, booleanExtras, jsonExtras);
        this.title = title;
        this.openPage = openPage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static WinphoneNotification alert(String alert) {
        return WinphoneNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_WINPHONE;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        if (null != this.openPage) {
            json.add(_OPEN_PAGE, (JsonElement)new JsonPrimitive(this.openPage));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<WinphoneNotification> {
        private String title;
        private String openPage;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setOpenPage(String openPage) {
            this.openPage = openPage;
            return this;
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            if (null == extras) {
                PlatformNotification.LOG.warn("Null extras param. Throw away it.");
                return this;
            }
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, JsonObject value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.jsonExtrasBuilder) {
                this.jsonExtrasBuilder = new HashMap();
            }
            this.jsonExtrasBuilder.put(key, value);
            return this;
        }

        @Override
        public WinphoneNotification build() {
            return new WinphoneNotification(this.alert, this.title, this.openPage, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder);
        }
    }
}

