/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.push.model.notification.PlatformNotification;
import cn.jpush.api.utils.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class IosNotification
extends PlatformNotification {
    public static final String NOTIFICATION_IOS = "ios";
    private static final String DEFAULT_SOUND = "";
    private static final String DEFAULT_BADGE = "+1";
    private static final String BADGE = "badge";
    private static final String SOUND = "sound";
    private static final String CONTENT_AVAILABLE = "content-available";
    private static final String CATEGORY = "category";
    private static final String ALERT_VALID_BADGE = "Badge number should be 0~99999, and can be prefixed with + to add, - to minus";
    private final boolean soundDisabled;
    private final boolean badgeDisabled;
    private final String sound;
    private final String badge;
    private final boolean contentAvailable;
    private final String category;

    private IosNotification(String alert, String sound, String badge, boolean contentAvailable, boolean soundDisabled, boolean badgeDisabled, String category, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        super(alert, extras, numberExtras, booleanExtras, jsonExtras);
        this.sound = sound;
        this.badge = badge;
        this.contentAvailable = contentAvailable;
        this.soundDisabled = soundDisabled;
        this.badgeDisabled = badgeDisabled;
        this.category = category;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static IosNotification alert(String alert) {
        return IosNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_IOS;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (!this.badgeDisabled) {
            if (null != this.badge) {
                json.add(BADGE, (JsonElement)new JsonPrimitive(this.badge));
            } else {
                json.add(BADGE, (JsonElement)new JsonPrimitive(DEFAULT_BADGE));
            }
        }
        if (!this.soundDisabled) {
            if (null != this.sound) {
                json.add(SOUND, (JsonElement)new JsonPrimitive(this.sound));
            } else {
                json.add(SOUND, (JsonElement)new JsonPrimitive(DEFAULT_SOUND));
            }
        }
        if (this.contentAvailable) {
            json.add(CONTENT_AVAILABLE, (JsonElement)new JsonPrimitive((Number)1));
        }
        if (null != this.category) {
            json.add(CATEGORY, (JsonElement)new JsonPrimitive(this.category));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<IosNotification> {
        private String sound;
        private String badge;
        private boolean contentAvailable = false;
        private boolean soundDisabled = false;
        private boolean badgeDisabled = false;
        private String category;

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder disableSound() {
            this.soundDisabled = true;
            return this;
        }

        public Builder incrBadge(int badge) {
            if (!ServiceHelper.isValidIntBadge(Math.abs(badge))) {
                PlatformNotification.LOG.warn(IosNotification.ALERT_VALID_BADGE);
                return this;
            }
            this.badge = badge >= 0 ? "+" + badge : IosNotification.DEFAULT_SOUND + badge;
            return this;
        }

        public Builder setBadge(int badge) {
            if (!ServiceHelper.isValidIntBadge(badge)) {
                PlatformNotification.LOG.warn(IosNotification.ALERT_VALID_BADGE);
                return this;
            }
            this.badge = IosNotification.DEFAULT_SOUND + badge;
            return this;
        }

        public Builder autoBadge() {
            return this.incrBadge(1);
        }

        public Builder disableBadge() {
            this.badgeDisabled = true;
            return this;
        }

        public Builder setContentAvailable(boolean contentAvailable) {
            this.contentAvailable = contentAvailable;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            if (null == extras) {
                PlatformNotification.LOG.warn("Null extras param. Throw away it.");
                return this;
            }
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, JsonObject value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.jsonExtrasBuilder) {
                this.jsonExtrasBuilder = new HashMap();
            }
            this.jsonExtrasBuilder.put(key, value);
            return this;
        }

        @Override
        public IosNotification build() {
            return new IosNotification(this.alert, this.sound, this.badge, this.contentAvailable, this.soundDisabled, this.badgeDisabled, this.category, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder);
        }
    }
}

