/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.message;

import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.chatroom.ChatRoomHistoryResult;
import cn.jmessage.api.common.BaseClient;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.common.model.message.MessagePayload;
import cn.jmessage.api.message.MessageListResult;
import cn.jmessage.api.message.SendMessageResult;
import cn.jmessage.api.utils.StringUtils;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MessageClient
extends BaseClient {
    private String messagePath;
    private String v2_messagePath;
    private String reportBaseUrl;
    private String v2_userPath;
    private String v2_chatroomPath;

    public MessageClient(String appKey, String masterSecret) {
        this(appKey, masterSecret, null, JMessageConfig.getInstance());
    }

    public MessageClient(String appKey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        super(appKey, masterSecret, proxy, config);
        this.messagePath = (String)config.get("im.message.path");
        this.reportBaseUrl = (String)config.get("im.api.report.host.name");
        this.v2_userPath = (String)config.get("im.v2.user.path");
        this.v2_messagePath = (String)config.get("im.v2.message.path");
        this.v2_chatroomPath = (String)config.get("im.v2.chatroom.path");
    }

    public SendMessageResult sendMessage(MessagePayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Message payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this.messagePath, payload.toString());
        return (SendMessageResult)SendMessageResult.fromResponse((ResponseWrapper)response, SendMessageResult.class);
    }

    @Deprecated
    public MessageListResult getMessageList(int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        if (count <= 0 || count > 1000) {
            throw new IllegalArgumentException("count must more than 0 and less than 1001");
        }
        String requestUrl = this.reportBaseUrl + this.v2_messagePath + "?count=" + count;
        String beginEncoded = null;
        String endEncoded = null;
        if (null != begin_time && StringUtils.isNotEmpty(begin_time) && null != end_time && StringUtils.isNotEmpty(end_time)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date beginDate = format.parse(begin_time);
                Date endDate = format.parse(end_time);
                if (endDate.getTime() - beginDate.getTime() < 0L) {
                    throw new IllegalArgumentException("end time must lager than begin time");
                }
                if (endDate.getTime() - beginDate.getTime() > 604800000L) {
                    throw new IllegalArgumentException("end time lager than begin time over 7 days");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                beginEncoded = URLEncoder.encode(begin_time, "utf-8");
                endEncoded = URLEncoder.encode(end_time, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("begin time or end time is null or empty");
        }
        requestUrl = requestUrl + "&begin_time=" + beginEncoded + "&end_time=" + endEncoded;
        ResponseWrapper response = this._httpClient.sendGet(requestUrl);
        return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
    }

    @Deprecated
    public MessageListResult getMessageListByCursor(String cursor) throws APIConnectionException, APIRequestException {
        if (null != cursor) {
            String requestUrl = this.reportBaseUrl + this.v2_messagePath + "?cursor=" + cursor;
            ResponseWrapper response = this._httpClient.sendGet(requestUrl);
            return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
        }
        throw new IllegalArgumentException("the cursor parameter should not be null");
    }

    @Deprecated
    public MessageListResult getUserMessages(String username, int count, String begin_time, String end_time) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        if (count <= 0 || count > 1000) {
            throw new IllegalArgumentException("count must more than 0 and less than 1001");
        }
        String requestUrl = this.reportBaseUrl + this.v2_userPath + "/" + username + "/messages?count=" + count;
        String beginEncoded = null;
        String endEncoded = null;
        if (null != begin_time && StringUtils.isNotEmpty(begin_time) && null != end_time && StringUtils.isNotEmpty(end_time)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date beginDate = format.parse(begin_time);
                Date endDate = format.parse(end_time);
                if (endDate.getTime() - beginDate.getTime() < 0L) {
                    throw new IllegalArgumentException("end time must lager than begin time");
                }
                if (endDate.getTime() - beginDate.getTime() > 604800000L) {
                    throw new IllegalArgumentException("end time lager than begin time over 7 days");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                beginEncoded = URLEncoder.encode(begin_time, "utf-8");
                endEncoded = URLEncoder.encode(end_time, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("begin time or end time is null or empty");
        }
        requestUrl = requestUrl + "&begin_time=" + beginEncoded + "&end_time=" + endEncoded;
        ResponseWrapper response = this._httpClient.sendGet(requestUrl);
        return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
    }

    @Deprecated
    public MessageListResult getUserMessagesByCursor(String username, String cursor) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        if (null != cursor) {
            String requestUrl = this.reportBaseUrl + this.v2_userPath + "/" + username + "/messages?cursor=" + cursor;
            ResponseWrapper response = this._httpClient.sendGet(requestUrl);
            return (MessageListResult)MessageListResult.fromResponse((ResponseWrapper)response, MessageListResult.class);
        }
        throw new IllegalArgumentException("the cursor parameter should not be null");
    }

    public ResponseWrapper retractMessage(String username, long messageId) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        return this._httpClient.sendPost(this._baseUrl + this.messagePath + "/" + username + "/" + messageId + "/retract", null);
    }

    public ChatRoomHistoryResult getChatRoomHistory(Long chatroomid, int count, String beginTime, String endTime) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((count > 0 && count <= 1000 ? 1 : 0) != 0, (Object)"count is invalid");
        String beginEncoded = null;
        String endEncoded = null;
        if (null != beginTime && StringUtils.isNotEmpty(beginTime) && null != endTime && StringUtils.isNotEmpty(endTime)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date beginDate = format.parse(beginTime);
                Date endDate = format.parse(endTime);
                if (endDate.getTime() - beginDate.getTime() < 0L) {
                    throw new IllegalArgumentException("end time must lager than begin time");
                }
                if (endDate.getTime() - beginDate.getTime() > 604800000L) {
                    throw new IllegalArgumentException("end time lager than begin time over 7 days");
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("parse time exception");
            }
            try {
                beginEncoded = URLEncoder.encode(beginTime, "utf-8");
                endEncoded = URLEncoder.encode(endTime, "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("begin time or end time is null or empty");
        }
        String requestUrl = this.reportBaseUrl + this.v2_chatroomPath + "/" + chatroomid + "/messages?count=" + count + "&begin_time=" + beginEncoded + "&end_time=" + endEncoded;
        ResponseWrapper response = this._httpClient.sendGet(requestUrl);
        return (ChatRoomHistoryResult)ChatRoomHistoryResult.fromResponse((ResponseWrapper)response, ChatRoomHistoryResult.class);
    }

    public ChatRoomHistoryResult getChatRoomHistory(Long chatroomid, String cursor) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((cursor != null && cursor.length() > 0 ? 1 : 0) != 0, (Object)"count is invalid");
        String requestUrl = this.reportBaseUrl + this.v2_chatroomPath + "/" + chatroomid + "/messages?cursor=" + cursor;
        ResponseWrapper response = this._httpClient.sendGet(requestUrl);
        return (ChatRoomHistoryResult)ChatRoomHistoryResult.fromResponse((ResponseWrapper)response, ChatRoomHistoryResult.class);
    }
}

