/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.message;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class MessageBody
implements IModel {
    private static final String MSG_BODY_TEXT = "text";
    private static final String MSG_BODY_EXTRAS = "extras";
    private static final String MEDIA_ID = "media_id";
    private static final String MEDIA_CRC32 = "media_crc32";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String FORMAT = "format";
    private static final String FSIZE = "fsize";
    private static final String DURATION = "duration";
    private static final String HASH = "hash";
    private static Gson gson = new Gson();
    private Map<String, String> extras;
    private Map<String, Number> numberExtras;
    private Map<String, Boolean> booleanExtras;
    private String media_id;
    private Long media_crc32;
    private Integer width;
    private Integer height;
    private String format;
    private Integer fsize;
    private Integer duration = -1;
    private String hash;
    private String text;

    private MessageBody(String text, Map<String, String> extra, Map<String, Number> numberExtra, Map<String, Boolean> booleanExtra) {
        this.text = text;
        this.extras = extra;
        this.numberExtras = numberExtra;
        this.booleanExtras = booleanExtra;
    }

    private MessageBody(String mediaId, Long crc32, Integer width, Integer height, String format, Integer fsize, Integer duration, String hash) {
        this.media_id = mediaId;
        this.media_crc32 = crc32;
        this.width = width;
        this.height = height;
        this.format = format;
        this.fsize = fsize;
        this.duration = duration;
        this.hash = hash;
    }

    private MessageBody(String mediaId, Long crc32, Integer width, Integer height, String format, Integer fsize, Integer duration, String hash, Map<String, String> extra, Map<String, Number> numberExtra, Map<String, Boolean> booleanExtra) {
        this.media_id = mediaId;
        this.media_crc32 = crc32;
        this.width = width;
        this.height = height;
        this.format = format;
        this.fsize = fsize;
        this.duration = duration;
        this.hash = hash;
        this.extras = extra;
        this.numberExtras = numberExtra;
        this.booleanExtras = booleanExtra;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static MessageBody text(String text) {
        return new Builder().setText(text).build();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.text) {
            json.addProperty(MSG_BODY_TEXT, this.text);
        }
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            for (String key : this.extras.keySet()) {
                if (this.extras.get(key) != null) {
                    extrasObject.add(key, (JsonElement)new JsonPrimitive(this.extras.get(key)));
                    continue;
                }
                extrasObject.add(key, (JsonElement)JsonNull.INSTANCE);
            }
        }
        if (null != this.numberExtras) {
            for (String key : this.numberExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive(this.numberExtras.get(key)));
            }
        }
        if (null != this.booleanExtras) {
            for (String key : this.booleanExtras.keySet()) {
                extrasObject.add(key, (JsonElement)new JsonPrimitive(this.booleanExtras.get(key)));
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras) {
            json.add(MSG_BODY_EXTRAS, (JsonElement)extrasObject);
        }
        if (null != this.media_id) {
            json.addProperty(MEDIA_ID, this.media_id);
        }
        if (null != this.media_crc32) {
            json.addProperty(MEDIA_CRC32, (Number)this.media_crc32);
        }
        if (null != this.width) {
            json.addProperty(WIDTH, (Number)this.width);
        }
        if (null != this.height) {
            json.addProperty(HEIGHT, (Number)this.height);
        }
        if (null != this.format) {
            json.addProperty(FORMAT, this.format);
        }
        if (null != this.fsize) {
            json.addProperty(FSIZE, (Number)this.fsize);
        }
        if (-1 != this.duration) {
            json.addProperty(DURATION, (Number)this.duration);
        }
        if (null != this.hash) {
            json.addProperty(HASH, this.hash);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String text;
        private Map<String, String> extrasBuilder;
        private Map<String, Number> numberExtrasBuilder;
        private Map<String, Boolean> booleanExtrasBuilder;
        private String media_id;
        private Long media_crc32;
        private Integer width;
        private Integer height;
        private String format;
        private Integer fsize;
        private Integer duration = -1;
        private String hash;

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap<String, Number>();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap<String, Boolean>();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder setMediaId(String mediaId) {
            this.media_id = mediaId;
            return this;
        }

        public Builder setMediaCrc32(Long crc32) {
            this.media_crc32 = crc32;
            return this;
        }

        public Builder setWidth(Integer width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(Integer height) {
            this.height = height;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder setFsize(Integer fsize) {
            this.fsize = fsize;
            return this;
        }

        public Builder setDuration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public Builder setHash(String hash) {
            this.hash = hash;
            return this;
        }

        public MessageBody build() {
            if (null != this.media_id) {
                return new MessageBody(this.media_id, this.media_crc32, this.width, this.height, this.format, this.fsize, this.duration, this.hash, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder);
            }
            return new MessageBody(this.text, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder);
        }
    }
}

