/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.chatroom;

import cn.jmessage.api.common.model.IModel;
import cn.jmessage.api.common.model.Members;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ChatRoomPayload
implements IModel {
    public static final String OWNER = "owner_username";
    public static final String NAME = "name";
    public static final String MEMBERS = "members_username";
    public static final String DESC = "description";
    public static final String FLAG = "flag";
    private static Gson gson = new Gson();
    private String owner;
    private String name;
    private Members members;
    private String desc;
    private int flag = -1;

    public ChatRoomPayload(String name, String ownerName, Members members, String desc, int flag) {
        this.name = name;
        this.owner = ownerName;
        this.members = members;
        this.desc = desc;
        this.flag = flag;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject jsonObject = new JsonObject();
        if (null != this.name) {
            jsonObject.addProperty(NAME, this.name);
        }
        if (null != this.owner) {
            jsonObject.addProperty(OWNER, this.owner);
        }
        if (null != this.members) {
            jsonObject.add(MEMBERS, this.members.toJSON());
        }
        if (null != this.desc) {
            jsonObject.addProperty(DESC, this.desc);
        }
        if (this.flag != -1) {
            jsonObject.addProperty(FLAG, (Number)this.flag);
        }
        return jsonObject;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String owner;
        private String name;
        private Members members;
        private String desc;
        private int flag = -1;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setOwnerUsername(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setMembers(Members members) {
            this.members = members;
            return this;
        }

        public Builder setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder setFlag(int flag) {
            this.flag = flag;
            return this;
        }

        public ChatRoomPayload build() {
            return new ChatRoomPayload(this.name, this.owner, this.members, this.desc, this.flag);
        }
    }
}

