/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.qrcode;

import cn.hutool.core.util.CharsetUtil;
import com.google.zxing.EncodeHintType;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.nio.charset.Charset;
import java.util.HashMap;

public class QrConfig {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private int width;
    private int height;
    private int foreColor = -16777216;
    private int backColor = -1;
    private Integer margin = 2;
    private ErrorCorrectionLevel errorCorrection;
    private Charset charset = CharsetUtil.CHARSET_UTF_8;

    public QrConfig() {
        this(300, 300);
    }

    public QrConfig(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(int foreColor) {
        this.foreColor = foreColor;
    }

    public int getBackColor() {
        return this.backColor;
    }

    public void setBackColor(int backColor) {
        this.backColor = backColor;
    }

    public Integer getMargin() {
        return this.margin;
    }

    public void setMargin(Integer margin) {
        this.margin = margin;
    }

    public ErrorCorrectionLevel getErrorCorrection() {
        return this.errorCorrection;
    }

    public void setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
        this.errorCorrection = errorCorrection;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public HashMap<EncodeHintType, Object> toHints() {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        if (null != this.charset) {
            hints.put(EncodeHintType.CHARACTER_SET, this.charset.toString());
        }
        if (null != this.errorCorrection) {
            hints.put(EncodeHintType.ERROR_CORRECTION, this.errorCorrection);
        }
        if (null != this.margin) {
            hints.put(EncodeHintType.MARGIN, this.margin);
        }
        return hints;
    }
}

