/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock.commands;

import ai.grakn.redismock.RedisBase;
import ai.grakn.redismock.Slice;
import ai.grakn.redismock.Utils;
import ai.grakn.redismock.commands.RedisOperation;
import java.util.List;

abstract class AbstractRedisOperation
implements RedisOperation {
    private final RedisBase base;
    private final List<Slice> params;

    AbstractRedisOperation(RedisBase base, List<Slice> params, Integer expectedParams, Integer minParams, Integer factorParams) {
        this.base = base;
        this.params = params;
        this.precheck(expectedParams, minParams, factorParams);
    }

    void doOptionalWork() {
    }

    abstract Slice response();

    RedisBase base() {
        return this.base;
    }

    List<Slice> params() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slice execute() {
        this.doOptionalWork();
        RedisBase redisBase = this.base;
        synchronized (redisBase) {
            return this.response();
        }
    }

    private void precheck(Integer expectedParams, Integer minParams, Integer factorParams) {
        if (expectedParams != null) {
            Utils.checkArgumentsNumberEquals(this.params, expectedParams);
        }
        if (minParams != null) {
            Utils.checkArgumentsNumberGreater(this.params, minParams);
        }
        if (factorParams != null) {
            Utils.checkArgumentsNumberFactor(this.params, factorParams);
        }
    }
}

