/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock;

import ai.grakn.redismock.RedisBase;
import ai.grakn.redismock.RedisService;
import ai.grakn.redismock.ServiceOptions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ServerSocket;

public class RedisServer {
    private final int bindPort;
    private ServiceOptions options = new ServiceOptions();
    private ServerSocket server = null;
    private Thread service = null;
    private final RedisBase base = new RedisBase();

    public RedisServer() throws IOException {
        this(0);
    }

    public RedisServer(int port) throws IOException {
        this.bindPort = port;
    }

    public static RedisServer newRedisServer() throws IOException {
        return new RedisServer();
    }

    public static RedisServer newRedisServer(int port) throws IOException {
        return new RedisServer(port);
    }

    public void setOptions(ServiceOptions options) {
        Preconditions.checkNotNull((Object)options);
        this.options = options;
    }

    public void start() throws IOException {
        Preconditions.checkState((this.server == null ? 1 : 0) != 0);
        Preconditions.checkState((this.service == null ? 1 : 0) != 0);
        this.server = new ServerSocket(this.bindPort);
        this.service = new Thread(new RedisService(this.server, this.base, this.options));
        this.service.start();
    }

    public void stop() {
        Preconditions.checkNotNull((Object)this.service);
        Preconditions.checkState((boolean)this.service.isAlive());
        try {
            this.server.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.service.join(100L);
            if (this.service.isAlive()) {
                this.service.stop();
            }
        }
        catch (InterruptedException e) {
            this.service.stop();
        }
        this.server = null;
        this.service = null;
    }

    public String getHost() {
        Preconditions.checkNotNull((Object)this.server);
        return this.server.getInetAddress().getHostAddress();
    }

    public int getBindPort() {
        Preconditions.checkNotNull((Object)this.server);
        return this.server.getLocalPort();
    }

    public RedisBase getBase() {
        return this.base;
    }

    public void setSlave(RedisServer slave) {
        Preconditions.checkState((this.server == null ? 1 : 0) != 0);
        Preconditions.checkState((this.service == null ? 1 : 0) != 0);
        this.base.addSyncBase(slave.getBase());
    }
}

