/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock;

import ai.grakn.redismock.RedisCommand;
import ai.grakn.redismock.SliceParser;
import ai.grakn.redismock.exception.EOFException;
import ai.grakn.redismock.exception.ParseErrorException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RedisCommandParser {
    @VisibleForTesting
    static RedisCommand parse(String stringInput) throws ParseErrorException, EOFException {
        Preconditions.checkNotNull((Object)stringInput);
        return RedisCommandParser.parse(new ByteArrayInputStream(stringInput.getBytes()));
    }

    static RedisCommand parse(InputStream messageInput) throws ParseErrorException, EOFException {
        Preconditions.checkNotNull((Object)messageInput);
        long count = SliceParser.consumeCount(messageInput);
        if (count == 0L) {
            throw new ParseErrorException();
        }
        RedisCommand command = new RedisCommand();
        for (long i = 0L; i < count; ++i) {
            command.addParameter(SliceParser.consumeParameter(messageInput));
        }
        return command;
    }
}

