/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils.dbenrypt;

import com.allcam.common.annotation.DecryptField;
import com.allcam.common.annotation.EncryptField;
import com.allcam.common.utils.AESEncryptUtils;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ClassUtils;

class EncryptDecryptUtils {
    EncryptDecryptUtils() {
    }

    static <T> T encrypt(T parameterObject) throws IllegalAccessException {
        if (parameterObject instanceof String) {
            return (T)EncryptDecryptUtils.encryptString((String)parameterObject);
        }
        Field[] declaredFields = parameterObject.getClass().getDeclaredFields();
        EncryptDecryptUtils.encrypt(declaredFields, parameterObject);
        return parameterObject;
    }

    static void encrypt(Field[] fields, Object result) throws IllegalAccessException {
        for (Field field : fields) {
            EncryptDecryptUtils.encrypt(field, result);
        }
    }

    static <T> T encrypt(Field field, T parameterObject) throws IllegalAccessException {
        if (field.isAnnotationPresent(EncryptField.class)) {
            field.setAccessible(true);
            field.set(parameterObject, EncryptDecryptUtils.encryptObject(field.get(parameterObject)));
        }
        return parameterObject;
    }

    static Map encrypt(String[] fields, Map parameterObject) {
        for (String field : fields) {
            parameterObject.put(field, EncryptDecryptUtils.encryptObject(parameterObject.get(field)));
        }
        return parameterObject;
    }

    static Object encryptObject(Object value) {
        String string;
        if (value != null && (ClassUtils.isPrimitiveOrWrapper(value.getClass()) || String.class.isAssignableFrom(value.getClass()) || Number.class.isAssignableFrom(value.getClass())) && StringUtils.isNotBlank((CharSequence)(string = String.valueOf(value)))) {
            return EncryptDecryptUtils.encryptString(string);
        }
        return value;
    }

    static String encryptString(String parameterObject) {
        if (StringUtils.isNotBlank((CharSequence)parameterObject)) {
            return AESEncryptUtils.encrypt((String)parameterObject);
        }
        return parameterObject;
    }

    static <T> T decrypt(T result) throws IllegalAccessException {
        if (result instanceof String) {
            return (T)EncryptDecryptUtils.decryptString((String)result);
        }
        Field[] declaredFields = result.getClass().getDeclaredFields();
        EncryptDecryptUtils.decrypt(declaredFields, result);
        return result;
    }

    static void decrypt(Field[] fields, Object result) throws IllegalAccessException {
        for (Field field : fields) {
            EncryptDecryptUtils.decrypt(field, result);
        }
    }

    static void decrypt(Field field, Object result) throws IllegalAccessException {
        if (field.isAnnotationPresent(DecryptField.class)) {
            field.setAccessible(true);
            Object value = field.get(result);
            if (value instanceof String) {
                field.set(result, EncryptDecryptUtils.decryptString((String)value));
            }
        }
    }

    static String decryptString(String result) {
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return AESEncryptUtils.decrypt((String)result);
        }
        return result;
    }
}

