/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import com.allcam.common.constant.AlarmConst;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public final class AlarmUtil
implements AlarmConst {
    private static final Map<String, String> alarmNameMap = new HashMap<String, String>();

    public static String getAlarmName(String alarmType) {
        Assert.hasText((String)alarmType, (String)"alarm type must not empty.");
        String name = alarmNameMap.get(alarmType);
        if (null == name) {
            name = "\u672a\u77e5\u544a\u8b66";
        }
        return name;
    }

    static {
        alarmNameMap.put("ALARM_TYPE_DI", "\u544a\u8b66\u8f93\u5165\u8bbe\u5907\u544a\u8b66");
        alarmNameMap.put("ALARM_DISK_FAULT", "\u786c\u76d8\u6545\u969c");
        alarmNameMap.put("ALARM_DISK_FULL", "\u78c1\u76d8\u6ee1\u544a\u8b66");
        alarmNameMap.put("ALARM_NO_SIGNAL", "\u89c6\u9891\u4e22\u5931");
        alarmNameMap.put("ALARM_TYPE_MOVE_DECTION", "\u79fb\u52a8\u4fa6\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_SHIELD", "\u906e\u6321\u544a\u8b66");
        alarmNameMap.put("ALARM_SD_CARD_FAULT", "SD\u5361\u6545\u969c");
        alarmNameMap.put("ALARM_CAMERA_ONLINE", "\u955c\u5934\u4e0a\u7ebf");
        alarmNameMap.put("ALARM_CAMERA_OFFLINE", "\u955c\u5934\u4e0b\u7ebf");
        alarmNameMap.put("ALARM_PU_ONLINE", "\u524d\u7aef\u4e0a\u7ebf");
        alarmNameMap.put("ALARM_PU_OFFLINE", "\u524d\u7aef\u4e0b\u7ebf");
        alarmNameMap.put("ALARM_NETWORK_INTERRUPT", "\u7f51\u7edc\u4e2d\u65ad");
        alarmNameMap.put("ALARM_IP_ADDRESS_CONFLICT", "IP\u51b2\u7a81");
        alarmNameMap.put("ALARM_OBJECT_ABANDONED", "\u9057\u7559\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_OBJECT_REMOVAL", "\u79fb\u8d70\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_INTRUSION", "\u5165\u4fb5\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_TRIP_LINE", "\u7eca\u7ebf\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_MOTION", "\u7269\u4f53\u79fb\u52a8\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_DIRECTIONAL_MOTION", "\u5b9a\u5411\u79fb\u52a8\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_OBJECT_STARTED", "\u7269\u4f53\u8d77\u52a8\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_SPEED", "\u901f\u5ea6\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_LOITERING", "\u5f98\u5f8a\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_MOTION_ACTIVITY", "\u6d3b\u52a8\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_PEOPLE_GATHERING", "\u4eba\u7fa4\u5bc6\u5ea6\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_PRESENCE", "\u7a81\u7136\u51fa\u73b0\u62a5\u8b66");
        alarmNameMap.put("ALARM_PATH", "\u8def\u5f84\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_MISSING_MSF_FILE", "MSF\u6587\u4ef6\u4e22\u5931");
        alarmNameMap.put("ALARM_MSF_SIZE_ERROR", "\u89c6\u9891\u6e90\u5206\u8fa8\u7387\u6539\u53d8");
        alarmNameMap.put("ALARM_NO_REFERENCE", "\u573a\u666f\u4e22\u5931");
        alarmNameMap.put("ALARM_MOTION_HUMAN", "\u4eba\u5458\u79fb\u52a8\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_MOTION_VEHICLE", "\u8f66\u8f86\u79fb\u52a8\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_MOTION_ANIMAL", "\u52a8\u7269\u79fb\u52a8\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_MOTION_OTHER", "\u5176\u5b83\u5bf9\u8c61\u79fb\u52a8\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_STATIC_OBJECT", "\u7269\u4f53\u6ede\u7559\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_STATIC_OBJECT_HUMAN", "\u4eba\u5458\u6ede\u7559\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_STATIC_OBJECT_VEHICLE", "\u8f66\u8f86\u6ede\u7559\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_STATIC_OBJECT_OTHER", "\u5176\u5b83\u5bf9\u8c61\u6ede\u7559\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_PATH_HUMAN", "\u4eba\u5458\u8def\u5f84\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_PATH_VEHICLE", "\u8f66\u8f86\u8def\u5f84\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_PATH_OTHER", "\u5176\u5b83\u5bf9\u8c61\u8def\u5f84\u68c0\u6d4b\u62a5\u8b66");
        alarmNameMap.put("ALARM_TV_SHOW", "\u624b\u673a\u7529\u5c4f\u4e0a\u5899\u62a5\u8b66");
        alarmNameMap.put("ALARM_AI_STRAW_BURNING", "\u79f8\u79c6\u711a\u70e7\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_ILLEGAL_BUILDING", "\u8fdd\u7ae0\u5efa\u7b51\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_SEWAGE", "\u6c61\u6c34\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_SMOKE_DETECTION", "\u5de5\u4e1a\u70df\u96fe\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_CROWD_MASS", "\u4eba\u7fa4\u805a\u96c6\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_HELMET_NOT_WEAR", "\u672a\u4f69\u6234\u5b89\u5168\u5e3d\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_RAISE_DUST", "\u626c\u5c18\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_SOLID_WASTE", "\u56fa\u4f53\u5783\u573e\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_MASK_NOT_WEAR", "\u672a\u6234\u53e3\u7f69\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_CHEFHAT_NOT_WEAR", "\u672a\u6234\u53a8\u5e08\u5e3d\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_CLOTHES_DISARRAY", "\u7740\u88c5\u4e0d\u89c4\u8303\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_FOREIGN_BODY_DETECTION", "\u540e\u53a8\u5f02\u7269\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_ILLEGAL_PERSONS_DETECTION", "\u5f02\u5e38\u4eba\u5458\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_NO_WORK_LICENSE_DETECTION", "\u975e\u6301\u8bc1\u4e0a\u5c97\u4eba\u5458\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_VIP_UNRECOGNIZABLE", "VIP\u5ba2\u6237\u8bc6\u522b\u63d0\u9192\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_CONSTRUCTION_VEHICLE_DETECTION", "\u5de5\u7a0b\u8f66\u8f86\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_FLOTSAM_DETECTION", "\u6f02\u6d6e\u7269\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_WATER_LEVEL_DETECTION", "\u6c34\u4f4d\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_STATIC_OBJECT_DETECTION", "\u6ede\u7559\u7269\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_INTRUSION_DETECTION", "\u5468\u754c\u5165\u4fb5\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_HIGHRISK_AREA_DETECTION", "\u9ad8\u5371\u533a\u57df\u95ef\u5165\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_PERSONS_FALL_DETECTION", "\u4eba\u5458\u8dcc\u5012\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_RISK_AREA_LOITERING_DETECTION", "\u5371\u9669\u533a\u57df\u5f98\u5f8a\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_SLEEP_LEAVE_ATWORK_DETECTION", "\u7761\u5c97\u79bb\u5c97\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_CLIMB_DETECTION", "\u722c\u9ad8\u68c0\u6d4b\u544a\u8b66");
        alarmNameMap.put("ALARM_AI_FIRE_DETECTION", "\u70df\u706b\u68c0\u6d4b\u544a\u8b66");
    }
}

