/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.service.device.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.entity.DevInfo;
import com.allcam.common.entity.device.DeviceConfigInfo;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class DeviceAddRequest
extends BaseRequest {
    private static final long serialVersionUID = -6110324825098444895L;
    @Verification(type=VerifyType.HAS_TEXT)
    private String devName;
    @Verification(type=VerifyType.HAS_TEXT)
    private String zoneId;
    private String areaCode;
    @Verification(type=VerifyType.HAS_TEXT)
    private String clientId;
    @Verification(type=VerifyType.HAS_TEXT)
    private String platId;
    @Verification(type=VerifyType.HAS_TEXT)
    private String applicationType = "00";
    private String thirdDeviceId;
    private String domainCode;
    private String clusterCode;
    private int devType;
    private int cameraType;
    @Verification(type=VerifyType.NOT_ZERO)
    private int maxChannelNum = 1;
    private String recordPolicy;
    private int recordRemainDays;
    private String puAccount;
    private String puPasswd;
    @Verification(type=VerifyType.REGULAR, param="^(?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))$")
    private String puIp = "1.1.1.1";
    @Verification(type=VerifyType.NOT_ZERO)
    private int puPort = 8000;
    private String puAccessPasswd;
    private String devDrive;
    private String devManufacturer;
    private String devModel;
    private String devAccessMode;
    private String belongOrganize;
    private String hvsChannelId;
    private String longitude;
    private String latitude;
    private String tasIp;
    private String tasCode;
    private String remark;
    private int originType;
    private String e55Code;
    private String installLocate;
    private DeviceConfigInfo deviceConfigInfo = new DeviceConfigInfo();

    @JsonIgnore
    public DevInfo buildMainDevInfo() {
        DevInfo devInfo = new DevInfo();
        devInfo.setDevName(this.getDevName());
        devInfo.setZoneId(this.getZoneId());
        devInfo.setClientId(this.getClientId());
        devInfo.setPlatId(this.getPlatId());
        devInfo.setThirdDevId(this.getThirdDeviceId());
        devInfo.setApplicationType(this.getApplicationType());
        devInfo.setDevType(String.valueOf(this.getDevType()));
        devInfo.setLoginName(this.getPuAccount());
        devInfo.setPasswd(this.getPuPasswd());
        devInfo.setDeviceRegPassword(this.getPuAccessPasswd());
        devInfo.setDeviceIP(this.getPuIp());
        devInfo.setDevicePort(String.valueOf(this.getPuPort()));
        devInfo.setProtocolType(this.getDevDrive());
        devInfo.setVendorType(this.getDevManufacturer());
        devInfo.setDeviceModel(this.getDevModel());
        devInfo.setHvsChannelId(this.getHvsChannelId());
        devInfo.setMaxAlarmInNum(1);
        devInfo.setMaxAlarmOutNum(1);
        devInfo.setMaxAudioInNum(1);
        devInfo.setMaxAudioOutNum(1);
        devInfo.setMaxSerialNum(1);
        devInfo.setMaxVideoNum(this.getMaxChannelNum());
        devInfo.setMaxDirectConnectNum(1);
        devInfo.setStatus(1);
        devInfo.setVideoFormat(1);
        devInfo.setLoginType(0);
        devInfo.setDevAccessMode(this.getDevAccessMode());
        devInfo.setEnableSchedule(1);
        devInfo.setEnableAlarm(0);
        devInfo.setDirectConnectFirst(0);
        devInfo.setTasIp(this.getTasIp());
        devInfo.setTasCode(this.getTasCode());
        devInfo.setRemark(this.getRemark());
        devInfo.setE55Code(this.getE55Code());
        devInfo.setInstallLocate(this.getInstallLocate());
        return devInfo;
    }

    public String getDevName() {
        return this.devName;
    }

    public void setDevName(String devName) {
        this.devName = devName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPlatId() {
        return this.platId;
    }

    public void setPlatId(String platId) {
        this.platId = platId;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getThirdDeviceId() {
        return this.thirdDeviceId;
    }

    public void setThirdDeviceId(String thirdDeviceId) {
        this.thirdDeviceId = thirdDeviceId;
    }

    public String getDomainCode() {
        return this.domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public String getClusterCode() {
        return this.clusterCode;
    }

    public void setClusterCode(String clusterCode) {
        this.clusterCode = clusterCode;
    }

    public int getDevType() {
        return this.devType;
    }

    public void setDevType(int devType) {
        this.devType = devType;
    }

    public int getCameraType() {
        return this.cameraType;
    }

    public void setCameraType(int cameraType) {
        this.cameraType = cameraType;
    }

    public int getMaxChannelNum() {
        return this.maxChannelNum;
    }

    public void setMaxChannelNum(int maxChannelNum) {
        this.maxChannelNum = maxChannelNum;
    }

    public String getRecordPolicy() {
        return this.recordPolicy;
    }

    public void setRecordPolicy(String recordPolicy) {
        this.recordPolicy = recordPolicy;
    }

    public int getRecordRemainDays() {
        return this.recordRemainDays;
    }

    public void setRecordRemainDays(int recordRemainDays) {
        this.recordRemainDays = recordRemainDays;
    }

    public String getPuAccount() {
        return this.puAccount;
    }

    public void setPuAccount(String puAccount) {
        this.puAccount = puAccount;
    }

    public String getPuPasswd() {
        return this.puPasswd;
    }

    public void setPuPasswd(String puPasswd) {
        this.puPasswd = puPasswd;
    }

    public String getPuIp() {
        return this.puIp;
    }

    public void setPuIp(String puIp) {
        this.puIp = puIp;
    }

    public int getPuPort() {
        return this.puPort;
    }

    public void setPuPort(int puPort) {
        this.puPort = puPort;
    }

    public String getPuAccessPasswd() {
        return this.puAccessPasswd;
    }

    public void setPuAccessPasswd(String puAccessPasswd) {
        this.puAccessPasswd = puAccessPasswd;
    }

    public String getDevDrive() {
        return this.devDrive;
    }

    public void setDevDrive(String devDrive) {
        this.devDrive = devDrive;
    }

    public String getDevManufacturer() {
        return this.devManufacturer;
    }

    public void setDevManufacturer(String devManufacturer) {
        this.devManufacturer = devManufacturer;
    }

    public String getDevAccessMode() {
        return this.devAccessMode;
    }

    public void setDevAccessMode(String devAccessMode) {
        this.devAccessMode = devAccessMode;
    }

    public String getDevModel() {
        return this.devModel;
    }

    public void setDevModel(String devModel) {
        this.devModel = devModel;
    }

    public String getBelongOrganize() {
        return this.belongOrganize;
    }

    public void setBelongOrganize(String belongOrganize) {
        this.belongOrganize = belongOrganize;
    }

    public String getHvsChannelId() {
        return this.hvsChannelId;
    }

    public void setHvsChannelId(String hvsChannelId) {
        this.hvsChannelId = hvsChannelId;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getTasIp() {
        return this.tasIp;
    }

    public void setTasIp(String tasIp) {
        this.tasIp = tasIp;
    }

    public String getTasCode() {
        return this.tasCode;
    }

    public void setTasCode(String tasCode) {
        this.tasCode = tasCode;
    }

    public int getOriginType() {
        return this.originType;
    }

    public void setOriginType(int originType) {
        this.originType = originType;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public DeviceConfigInfo getDeviceConfigInfo() {
        return this.deviceConfigInfo;
    }

    public void setDeviceConfigInfo(DeviceConfigInfo deviceConfigInfo) {
        this.deviceConfigInfo = deviceConfigInfo;
    }

    public String getE55Code() {
        return this.e55Code;
    }

    public void setE55Code(String e55Code) {
        this.e55Code = e55Code;
    }

    public String getInstallLocate() {
        return this.installLocate;
    }

    public void setInstallLocate(String installLocate) {
        this.installLocate = installLocate;
    }
}

