/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.model.right;

import com.allcam.common.base.AcBaseBean;
import com.allcam.common.model.right.RightInfo;
import com.allcam.common.model.right.RightValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class DevRightInfo
extends AcBaseBean {
    private static final long serialVersionUID = -4932126225341429901L;
    @RightValue(code=101)
    private int livePlay;
    @RightValue(code=104)
    private int liveTalk;
    @RightValue(code=102, maxRight=9)
    private int ptzControl;
    @RightValue(code=103)
    private int ptzControlEx;
    @RightValue(code=201)
    private int localRecord;
    @RightValue(code=202)
    private int puRecord;
    @RightValue(code=203)
    private int cloudRecord;
    @RightValue(code=204)
    private int recordPlayback;
    @RightValue(code=205)
    private int recordDownload;
    @RightValue(code=301)
    private int localSnap;
    @RightValue(code=302)
    private int puSnap;
    @RightValue(code=303)
    private int cloudSnap;
    @RightValue(code=501)
    private int puDevBaseConfig;
    @RightValue(code=502)
    private int puNetworkConfig;
    @RightValue(code=503)
    private int puCamBaseConfig;
    @RightValue(code=504)
    private int puVideoCodeConfig;
    @RightValue(code=505)
    private int puPicParamConfig;
    @RightValue(code=506)
    private int puOSDConfig;
    @RightValue(code=507)
    private int puMoveDetectSet;
    @RightValue(code=508)
    private int puVideoBlockAlarm;
    @RightValue(code=509)
    private int puOverStepAlarm;
    @RightValue(code=510)
    private int puTripLineAlarm;
    @RightValue(code=511)
    private int puObjMoveAlarm;
    @RightValue(code=512)
    private int puPrivateAreaSet;
    @RightValue(code=513)
    private int puAudioParamConfig;
    @RightValue(code=514)
    private int puSIParamConfig;
    @RightValue(code=515)
    private int puPtzParamConfig;
    @RightValue(code=517)
    private int puSnapConfig;
    @RightValue(code=401)
    private int puDevBaseShow;
    @RightValue(code=402)
    private int puNetworkShow;
    @RightValue(code=403)
    private int puCamBaseShow;
    @RightValue(code=404)
    private int puVideoCodeShow;
    @RightValue(code=405)
    private int puPicParamShow;
    @RightValue(code=406)
    private int puOSDShow;
    @RightValue(code=407)
    private int puMoveDetectShow;
    @RightValue(code=408)
    private int puVideoBlockAlarmShow;
    @RightValue(code=409)
    private int puOverStepAlarmShow;
    @RightValue(code=410)
    private int puTripLineAlarmShow;
    @RightValue(code=411)
    private int puObjMoveAlarmShow;
    @RightValue(code=412)
    private int puPrivateAreaSetShow;
    @RightValue(code=413)
    private int puAudioParamShow;
    @RightValue(code=414)
    private int puSIParamShow;
    @RightValue(code=415)
    private int puPtzParamShow;
    @RightValue(code=417)
    private int puSnapShow;
    @RightValue(code=516)
    private int puReboot;

    @JsonIgnore
    private static List<Field> rightFields() {
        ArrayList<Field> rightFields = new ArrayList<Field>();
        ReflectionUtils.doWithFields(DevRightInfo.class, f -> {
            if (f.isAnnotationPresent(RightValue.class)) {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                rightFields.add(f);
            }
        });
        return rightFields;
    }

    @JsonIgnore
    public void forAdmin() {
        DevRightInfo.rightFields().forEach(f -> {
            RightValue rightValue = f.getAnnotation(RightValue.class);
            ReflectionUtils.setField((Field)f, (Object)((Object)this), (Object)rightValue.maxRight());
        });
    }

    @JsonIgnore
    public boolean effective() {
        return DevRightInfo.rightFields().stream().anyMatch(f -> {
            RightValue rightValue = f.getAnnotation(RightValue.class);
            return ((Integer)ReflectionUtils.getField((Field)f, (Object)((Object)this))).intValue() != rightValue.noRight();
        });
    }

    @JsonIgnore
    public int getRightValue(int rightCode) {
        for (Field f : DevRightInfo.rightFields()) {
            RightValue rightValue = f.getAnnotation(RightValue.class);
            if (rightValue.code() != rightCode) continue;
            return (Integer)ReflectionUtils.getField((Field)f, (Object)((Object)this));
        }
        return 0;
    }

    @JsonIgnore
    public boolean hasRight(int rightCode) {
        for (Field f : DevRightInfo.rightFields()) {
            RightValue rightValue = f.getAnnotation(RightValue.class);
            if (rightValue.code() != rightCode) continue;
            return ((Integer)ReflectionUtils.getField((Field)f, (Object)((Object)this))).intValue() != rightValue.noRight();
        }
        return false;
    }

    @JsonIgnore
    public void parse(List<RightInfo> rights) {
        if (CollectionUtils.isEmpty(rights)) {
            return;
        }
        Map rfMap = rights.stream().collect(Collectors.toMap(RightInfo::getCode, Function.identity()));
        DevRightInfo.rightFields().forEach(f -> {
            RightValue rightValue = f.getAnnotation(RightValue.class);
            RightInfo right = (RightInfo)((Object)((Object)rfMap.get(rightValue.code())));
            if (null != right) {
                ReflectionUtils.setField((Field)f, (Object)((Object)this), (Object)right.getValue());
            }
        });
    }

    @JsonIgnore
    public List<RightInfo> rights() {
        return this.rights(false);
    }

    @JsonIgnore
    public List<RightInfo> rights(boolean all) {
        ArrayList<RightInfo> rights = new ArrayList<RightInfo>();
        for (Field f : DevRightInfo.rightFields()) {
            RightValue rightValue = f.getAnnotation(RightValue.class);
            int value = (Integer)ReflectionUtils.getField((Field)f, (Object)((Object)this));
            if (!all && value == rightValue.noRight()) continue;
            int rightCode = rightValue.code();
            RightInfo right = new RightInfo(rightCode, value);
            right.setName(f.getName());
            rights.add(right);
        }
        return rights;
    }

    @JsonIgnore
    public boolean rightEquals(DevRightInfo other) {
        if (null == other) {
            return false;
        }
        List<RightInfo> thisRights = this.rights();
        List<RightInfo> otherRights = other.rights();
        if (thisRights.size() != otherRights.size()) {
            return false;
        }
        thisRights.sort(Comparator.comparingInt(RightInfo::getCode));
        otherRights.sort(Comparator.comparingInt(RightInfo::getCode));
        for (int i = 0; i < thisRights.size(); ++i) {
            RightInfo lRight = thisRights.get(i);
            RightInfo rRight = otherRights.get(i);
            if (lRight.getCode() == rRight.getCode() && lRight.getValue() == rRight.getValue()) continue;
            return false;
        }
        return true;
    }

    @JsonIgnore
    public List<RightInfo> diffRights(@NonNull DevRightInfo update) {
        ArrayList<RightInfo> diff = new ArrayList<RightInfo>();
        Map<Integer, Integer> beforeRightMap = this.rights(true).stream().collect(Collectors.toMap(RightInfo::getCode, RightInfo::getValue));
        Map<Integer, Integer> afterRightMap = update.rights(true).stream().collect(Collectors.toMap(RightInfo::getCode, RightInfo::getValue));
        HashSet<Integer> totalCodes = new HashSet<Integer>();
        totalCodes.addAll(beforeRightMap.keySet());
        totalCodes.addAll(afterRightMap.keySet());
        for (Integer code : totalCodes) {
            Integer beforeValue = beforeRightMap.get(code);
            Integer afterValue = afterRightMap.get(code);
            RightInfo diffRight = new RightInfo();
            diffRight.setCode(code);
            diffRight.setValue(afterValue - beforeValue);
            diff.add(diffRight);
        }
        return diff;
    }

    @JsonIgnore
    public Set<Integer> cancelRights(@NonNull DevRightInfo update) {
        List cancelRights = this.diffRights(update).stream().filter(r -> r.getValue() < 0).collect(Collectors.toList());
        return cancelRights.stream().map(RightInfo::getCode).collect(Collectors.toSet());
    }

    @JsonIgnore
    public List<RightInfo> buildCancelRights(@NonNull DevRightInfo update) {
        Set<Integer> cancelRightCodes = this.cancelRights(update);
        return update.rights(true).stream().filter(r -> cancelRightCodes.contains(r.getCode())).collect(Collectors.toList());
    }

    @JsonIgnore
    public Map<String, Integer> buildCancelFields(@NonNull DevRightInfo update) {
        Set<Integer> cancelRightCodes = this.cancelRights(update);
        return update.rights(true).stream().filter(r -> cancelRightCodes.contains(r.getCode())).collect(Collectors.toMap(RightInfo::getName, RightInfo::getValue));
    }

    @JsonIgnore
    public boolean patchCancelRights(List<RightInfo> cancelRights) {
        if (CollectionUtils.isEmpty(cancelRights)) {
            return false;
        }
        Map<Integer, Integer> rfMap = cancelRights.stream().collect(Collectors.toMap(RightInfo::getCode, RightInfo::getValue));
        boolean change = false;
        for (Field f : DevRightInfo.rightFields()) {
            RightValue rightValue = f.getAnnotation(RightValue.class);
            Integer patchValue = rfMap.get(rightValue.code());
            if (null == patchValue) continue;
            int orgValue = (Integer)ReflectionUtils.getField((Field)f, (Object)((Object)this));
            if (patchValue >= orgValue) continue;
            ReflectionUtils.setField((Field)f, (Object)((Object)this), (Object)patchValue);
            change = true;
        }
        return change;
    }

    public int getLivePlay() {
        return this.livePlay;
    }

    public void setLivePlay(int livePlay) {
        this.livePlay = livePlay;
    }

    public int getLiveTalk() {
        return this.liveTalk;
    }

    public void setLiveTalk(int liveTalk) {
        this.liveTalk = liveTalk;
    }

    public int getPtzControl() {
        return this.ptzControl;
    }

    public void setPtzControl(int ptzControl) {
        this.ptzControl = ptzControl;
    }

    public int getPtzControlEx() {
        return this.ptzControlEx;
    }

    public void setPtzControlEx(int ptzControlEx) {
        this.ptzControlEx = ptzControlEx;
    }

    public int getLocalRecord() {
        return this.localRecord;
    }

    public void setLocalRecord(int localRecord) {
        this.localRecord = localRecord;
    }

    public int getPuRecord() {
        return this.puRecord;
    }

    public void setPuRecord(int puRecord) {
        this.puRecord = puRecord;
    }

    public int getCloudRecord() {
        return this.cloudRecord;
    }

    public void setCloudRecord(int cloudRecord) {
        this.cloudRecord = cloudRecord;
    }

    public int getRecordPlayback() {
        return this.recordPlayback;
    }

    public void setRecordPlayback(int recordPlayback) {
        this.recordPlayback = recordPlayback;
    }

    public int getRecordDownload() {
        return this.recordDownload;
    }

    public void setRecordDownload(int recordDownload) {
        this.recordDownload = recordDownload;
    }

    public int getLocalSnap() {
        return this.localSnap;
    }

    public void setLocalSnap(int localSnap) {
        this.localSnap = localSnap;
    }

    public int getPuSnap() {
        return this.puSnap;
    }

    public void setPuSnap(int puSnap) {
        this.puSnap = puSnap;
    }

    public int getCloudSnap() {
        return this.cloudSnap;
    }

    public void setCloudSnap(int cloudSnap) {
        this.cloudSnap = cloudSnap;
    }

    public int getPuDevBaseConfig() {
        return this.puDevBaseConfig;
    }

    public void setPuDevBaseConfig(int puDevBaseConfig) {
        this.puDevBaseConfig = puDevBaseConfig;
    }

    public int getPuNetworkConfig() {
        return this.puNetworkConfig;
    }

    public void setPuNetworkConfig(int puNetworkConfig) {
        this.puNetworkConfig = puNetworkConfig;
    }

    public int getPuCamBaseConfig() {
        return this.puCamBaseConfig;
    }

    public void setPuCamBaseConfig(int puCamBaseConfig) {
        this.puCamBaseConfig = puCamBaseConfig;
    }

    public int getPuVideoCodeConfig() {
        return this.puVideoCodeConfig;
    }

    public void setPuVideoCodeConfig(int puVideoCodeConfig) {
        this.puVideoCodeConfig = puVideoCodeConfig;
    }

    public int getPuPicParamConfig() {
        return this.puPicParamConfig;
    }

    public void setPuPicParamConfig(int puPicParamConfig) {
        this.puPicParamConfig = puPicParamConfig;
    }

    public int getPuOSDConfig() {
        return this.puOSDConfig;
    }

    public void setPuOSDConfig(int puOSDConfig) {
        this.puOSDConfig = puOSDConfig;
    }

    public int getPuMoveDetectSet() {
        return this.puMoveDetectSet;
    }

    public void setPuMoveDetectSet(int puMoveDetectSet) {
        this.puMoveDetectSet = puMoveDetectSet;
    }

    public int getPuVideoBlockAlarm() {
        return this.puVideoBlockAlarm;
    }

    public void setPuVideoBlockAlarm(int puVideoBlockAlarm) {
        this.puVideoBlockAlarm = puVideoBlockAlarm;
    }

    public int getPuOverStepAlarm() {
        return this.puOverStepAlarm;
    }

    public void setPuOverStepAlarm(int puOverStepAlarm) {
        this.puOverStepAlarm = puOverStepAlarm;
    }

    public int getPuTripLineAlarm() {
        return this.puTripLineAlarm;
    }

    public void setPuTripLineAlarm(int puTripLineAlarm) {
        this.puTripLineAlarm = puTripLineAlarm;
    }

    public int getPuObjMoveAlarm() {
        return this.puObjMoveAlarm;
    }

    public void setPuObjMoveAlarm(int puObjMoveAlarm) {
        this.puObjMoveAlarm = puObjMoveAlarm;
    }

    public int getPuPrivateAreaSet() {
        return this.puPrivateAreaSet;
    }

    public void setPuPrivateAreaSet(int puPrivateAreaSet) {
        this.puPrivateAreaSet = puPrivateAreaSet;
    }

    public int getPuAudioParamConfig() {
        return this.puAudioParamConfig;
    }

    public void setPuAudioParamConfig(int puAudioParamConfig) {
        this.puAudioParamConfig = puAudioParamConfig;
    }

    public int getPuAudioParamShow() {
        return this.puAudioParamShow;
    }

    public void setPuAudioParamShow(int puAudioParamShow) {
        this.puAudioParamShow = puAudioParamShow;
    }

    public int getPuSIParamConfig() {
        return this.puSIParamConfig;
    }

    public void setPuSIParamConfig(int puSIParamConfig) {
        this.puSIParamConfig = puSIParamConfig;
    }

    public int getPuPtzParamConfig() {
        return this.puPtzParamConfig;
    }

    public void setPuPtzParamConfig(int puPtzParamConfig) {
        this.puPtzParamConfig = puPtzParamConfig;
    }

    public int getPuReboot() {
        return this.puReboot;
    }

    public void setPuReboot(int puReboot) {
        this.puReboot = puReboot;
    }

    public int getPuDevBaseShow() {
        return this.puDevBaseShow;
    }

    public void setPuDevBaseShow(int puDevBaseShow) {
        this.puDevBaseShow = puDevBaseShow;
    }

    public int getPuNetworkShow() {
        return this.puNetworkShow;
    }

    public void setPuNetworkShow(int puNetworkShow) {
        this.puNetworkShow = puNetworkShow;
    }

    public int getPuCamBaseShow() {
        return this.puCamBaseShow;
    }

    public void setPuCamBaseShow(int puCamBaseShow) {
        this.puCamBaseShow = puCamBaseShow;
    }

    public int getPuVideoCodeShow() {
        return this.puVideoCodeShow;
    }

    public void setPuVideoCodeShow(int puVideoCodeShow) {
        this.puVideoCodeShow = puVideoCodeShow;
    }

    public int getPuPicParamShow() {
        return this.puPicParamShow;
    }

    public void setPuPicParamShow(int puPicParamShow) {
        this.puPicParamShow = puPicParamShow;
    }

    public int getPuOSDShow() {
        return this.puOSDShow;
    }

    public void setPuOSDShow(int puOSDShow) {
        this.puOSDShow = puOSDShow;
    }

    public int getPuMoveDetectShow() {
        return this.puMoveDetectShow;
    }

    public void setPuMoveDetectShow(int puMoveDetectShow) {
        this.puMoveDetectShow = puMoveDetectShow;
    }

    public int getPuVideoBlockAlarmShow() {
        return this.puVideoBlockAlarmShow;
    }

    public void setPuVideoBlockAlarmShow(int puVideoBlockAlarmShow) {
        this.puVideoBlockAlarmShow = puVideoBlockAlarmShow;
    }

    public int getPuOverStepAlarmShow() {
        return this.puOverStepAlarmShow;
    }

    public void setPuOverStepAlarmShow(int puOverStepAlarmShow) {
        this.puOverStepAlarmShow = puOverStepAlarmShow;
    }

    public int getPuTripLineAlarmShow() {
        return this.puTripLineAlarmShow;
    }

    public void setPuTripLineAlarmShow(int puTripLineAlarmShow) {
        this.puTripLineAlarmShow = puTripLineAlarmShow;
    }

    public int getPuObjMoveAlarmShow() {
        return this.puObjMoveAlarmShow;
    }

    public void setPuObjMoveAlarmShow(int puObjMoveAlarmShow) {
        this.puObjMoveAlarmShow = puObjMoveAlarmShow;
    }

    public int getPuPrivateAreaSetShow() {
        return this.puPrivateAreaSetShow;
    }

    public void setPuPrivateAreaSetShow(int puPrivateAreaSetShow) {
        this.puPrivateAreaSetShow = puPrivateAreaSetShow;
    }

    public int getPuSIParamShow() {
        return this.puSIParamShow;
    }

    public void setPuSIParamShow(int puSIParamShow) {
        this.puSIParamShow = puSIParamShow;
    }

    public int getPuPtzParamShow() {
        return this.puPtzParamShow;
    }

    public void setPuPtzParamShow(int puPtzParamShow) {
        this.puPtzParamShow = puPtzParamShow;
    }

    public int getPuSnapConfig() {
        return this.puSnapConfig;
    }

    public void setPuSnapConfig(int puSnapConfig) {
        this.puSnapConfig = puSnapConfig;
    }

    public int getPuSnapShow() {
        return this.puSnapShow;
    }

    public void setPuSnapShow(int puSnapShow) {
        this.puSnapShow = puSnapShow;
    }
}

