/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.constant.system;

import com.allcam.common.utils.StringUtil;
import org.apache.commons.lang3.StringUtils;

public enum Platform {
    ALLCAM(0, "allcam"),
    SVS(1, "svs"),
    HW_QLY(2, "nvs"),
    HW_QQY(3, "qqy"),
    HK_7800(4, "hik78"),
    HK_8200(6, "hik"),
    IVS(5, "ivs"),
    GBT28181(7, "gb"),
    TY(8, "ty"),
    ARGES(9, "arges"),
    YG7(10, "ys7"),
    OTHER(99, "other");

    int type;
    String name;

    private Platform(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public String toId() {
        return StringUtil.numToString((long)this.type, (int)2);
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static Platform of(String name) {
        for (Platform platform : Platform.values()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)platform.name)) continue;
            return platform;
        }
        return OTHER;
    }

    public static Platform of(int type) {
        for (Platform platform : Platform.values()) {
            if (type != platform.type) continue;
            return platform;
        }
        return OTHER;
    }
}

