/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.base;

import com.allcam.common.system.context.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ServiceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceUtils.class);

    public static <T> T getService(Class<T> serviceClass) {
        Object service = SpringContextHolder.getBean(serviceClass);
        if (null == service) {
            LOG.debug("get service from spring context fail, try to load from dubbo.");
            service = SpringContextHolder.getDubboService(serviceClass);
        }
        Assert.notNull((Object)service, (String)"\u83b7\u53d6\u670d\u52a1\u5931\u8d25");
        return (T)service;
    }
}

