/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.utils;

import com.allcam.common.annotation.DesensitizeField;
import com.allcam.common.constant.DesensitizeType;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ClassUtils;

public class DesensitizeUtils {
    public static <T> T desensitize(T param) {
        Field[] declaredFields = param.getClass().getDeclaredFields();
        try {
            for (Field field : declaredFields) {
                DesensitizeField desensitizeField = field.getAnnotation(DesensitizeField.class);
                if (desensitizeField == null) continue;
                field.setAccessible(true);
                Object value = field.get(param);
                if (value == null || !ClassUtils.isPrimitiveOrWrapper(value.getClass()) && !String.class.isAssignableFrom(value.getClass()) && !Number.class.isAssignableFrom(value.getClass())) continue;
                String string = String.valueOf(value);
                field.set(param, DesensitizeUtils.desensitize(string, desensitizeField.type()));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return param;
    }

    public static String desensitize(String value, DesensitizeType type) {
        switch (type) {
            case FULL_NAME: {
                return DesensitizeUtils.fullName(value);
            }
            case ID_CARD: 
            case LOGIN_NAME: 
            case LOGIN_ALIAS: {
                return DesensitizeUtils.idCard(value);
            }
            case BANK_CARD: {
                return DesensitizeUtils.bankCard(value);
            }
            case MOBILE_PHONE: {
                return DesensitizeUtils.mobilePhone(value);
            }
            case ADDRESS: {
                return DesensitizeUtils.address(value, 10);
            }
            case EMAIL: {
                return DesensitizeUtils.email(value);
            }
        }
        return "******";
    }

    public static String fullName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.left((String)fullName, (int)1);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static String idCard(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        String num = StringUtils.right((String)id, (int)4);
        return StringUtils.leftPad((String)num, (int)StringUtils.length((CharSequence)id), (String)"*");
    }

    public static String fixedPhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*");
    }

    public static String mobilePhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.left((String)num, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*"), (String)"***"));
    }

    public static String address(String address, int sensitiveSize) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)(length - sensitiveSize)), (int)length, (String)"*");
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)1), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static String bankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    public static String password(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return "";
        }
        String pwd = StringUtils.left((String)password, (int)0);
        return StringUtils.rightPad((String)pwd, (int)StringUtils.length((CharSequence)password), (String)"*");
    }
}

