/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.model.group;

import com.allcam.common.model.group.GroupChild;
import com.allcam.common.model.group.GroupInfo;
import com.allcam.common.utils.tree.BranchProxy;
import com.allcam.common.utils.tree.IdTree;
import com.allcam.common.utils.tree.LeafProxy;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GroupTree<T extends GroupInfo, V extends GroupChild>
extends IdTree<T, V> {
    public GroupTree(List<? extends T> groups) {
        this(groups, null, false);
    }

    public GroupTree(List<? extends T> groups, T backRoot) {
        this(groups, (T)backRoot, false);
    }

    public GroupTree(List<? extends T> groups, T backRoot, boolean forceRoot) {
        super(new GroupBranchProxy(), new CameraLeafProxy());
        this.createTree(groups, backRoot, forceRoot);
    }

    private static class CameraLeafProxy<V extends GroupChild>
    implements LeafProxy<V, String> {
        private CameraLeafProxy() {
        }

        public String branchMark(V object) {
            return object.getGroupId();
        }
    }

    private static class GroupBranchProxy<T extends GroupInfo>
    implements BranchProxy<T, String> {
        private GroupBranchProxy() {
        }

        public String branchMark(T object) {
            return ((GroupInfo)((Object)object)).getGroupId();
        }

        public String branchFrom(T object) {
            return ((GroupInfo)((Object)object)).getParentId();
        }

        public void branchReset(T object, String parent) {
            ((GroupInfo)((Object)object)).setParentId(StringUtils.isEmpty((CharSequence)parent) ? "" : parent);
        }
    }
}

