/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.entity;

import com.allcam.common.annotation.DecryptField;
import com.allcam.common.annotation.DesensitizeField;
import com.allcam.common.annotation.EncryptField;
import com.allcam.common.base.AcBaseBean;
import com.allcam.common.constant.DesensitizeType;
import com.allcam.common.constant.UserRight;
import com.allcam.common.model.group.GroupChild;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;

public class UserInfo
extends AcBaseBean
implements GroupChild {
    private static final long serialVersionUID = -7730654166493176859L;
    private long id;
    private String userId;
    private String userName;
    @DesensitizeField(type=DesensitizeType.FULL_NAME)
    @EncryptField
    @DecryptField
    private String realName;
    @DesensitizeField(type=DesensitizeType.LOGIN_NAME)
    @EncryptField
    @DecryptField
    private String loginName;
    private String alias;
    private String password;
    private int sex;
    private String right;
    private String zoneId;
    private String areaCode;
    private String clientId;
    private String userGrpId;
    private int status;
    private int userType;
    private int isLocked;
    private int isActive;
    private int pwdExpireDay;
    @DesensitizeField(type=DesensitizeType.ADDRESS)
    @EncryptField
    @DecryptField
    private String address;
    @DesensitizeField(type=DesensitizeType.EMAIL)
    @EncryptField
    @DecryptField
    private String email;
    @DesensitizeField(type=DesensitizeType.MOBILE_PHONE)
    @EncryptField
    @DecryptField
    private String mobile;
    @DesensitizeField
    @EncryptField
    @DecryptField
    private String fax;
    private String remark;
    private String longitude;
    private String latitude;
    private int whiteListTag;
    private String createTime;
    private String lastDate;

    public boolean hasRight(UserRight userRight) {
        if (null == userRight || StringUtils.isBlank((CharSequence)this.getRight())) {
            return false;
        }
        int rIndex = userRight.getIndex();
        if (this.getRight().length() <= rIndex) {
            return false;
        }
        return '1' == this.getRight().charAt(rIndex);
    }

    @JsonIgnore
    public boolean shouldCheckPermission() {
        return !this.isSuperAdmin() && this.userType != 5;
    }

    @JsonIgnore
    public boolean isSuperAdmin() {
        return "admin".equals(this.loginName);
    }

    @JsonIgnore
    public boolean isClientAdmin() {
        return this.getUserType() == 3;
    }

    @JsonIgnore
    public boolean isZoneAdmin() {
        return this.getUserType() == 4;
    }

    @JsonIgnore
    public boolean isClientUser() {
        return this.getUserType() == 1 || this.getUserType() == 2;
    }

    @Override
    public String getGroupId() {
        return this.getUserGrpId();
    }

    public long getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getSex() {
        return this.sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getUserGrpId() {
        return this.userGrpId;
    }

    public void setUserGrpId(String userGrpId) {
        this.userGrpId = userGrpId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getUserType() {
        return this.userType;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public int getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(int isLocked) {
        this.isLocked = isLocked;
    }

    public int getIsActive() {
        return this.isActive;
    }

    public void setIsActive(int isActive) {
        this.isActive = isActive;
    }

    public int getPwdExpireDay() {
        return this.pwdExpireDay;
    }

    public void setPwdExpireDay(int pwdExpireDay) {
        this.pwdExpireDay = pwdExpireDay;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public int getWhiteListTag() {
        return this.whiteListTag;
    }

    public void setWhiteListTag(int whiteListTag) {
        this.whiteListTag = whiteListTag;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(String lastDate) {
        this.lastDate = lastDate;
    }
}

