/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.common.constant;

public enum DevRight {
    LIVE(101, 13),
    PTZ(102, 14),
    PTZ_EX(103, 209001),
    TALK(104),
    LOCAL_RECORD(201),
    PU_RECORD(202),
    CLOUD_RECORD(203),
    RECORD_PLAYBACK(204),
    RECORD_DOWNLOAD(205),
    LOCAL_SNAP(301),
    PU_SNAP(302),
    CLOUD_SNAP(303),
    PU_DEV_BASE_SHOW(401),
    PU_NETWORK_SHOW(402),
    PU_CAM_BASE_SHOW(403),
    PU_VIDEO_CODE_SHOW(404),
    PU_PIC_PARAM_SHOW(405),
    PU_OSD_SHOW(406),
    PU_MOVE_DETECT_SHOW(407),
    PU_VIDEO_BLOCK_ALARM_SHOW(408),
    PU_OVERSTEP_ALARM_SHOW(409),
    PU_TRIP_LINE_ALARM_SHOW(410),
    PU_OBJ_MOVE_ALARM_SHOW(411),
    PU_PRIVATE_AREA_SET_SHOW(412),
    PU_AUDIO_PARAM_CONFIG_SHOW(413),
    SI_PARAM_CONFIG_SHOW(414),
    PU_PTZ_PARAM_CONFIG_SHOW(415),
    PU_DEV_BASE_CONFIG(501),
    PU_NETWORK_CONFIG(502),
    PU_CAM_BASE_CONFIG(503),
    PU_VIDEO_CODE_CONFIG(504),
    PU_PIC_PARAM_CONFIG(505),
    PU_OSD_CONFIG(506),
    PU_MOVE_DETECT_SET(507),
    PU_VIDEO_BLOCK_ALARM(508),
    PU_OVERSTEP_ALARM(509),
    PU_TRIP_LINE_ALARM(510),
    PU_OBJ_MOVE_ALARM(511),
    PU_PRIVATE_AREA_SET(512),
    PU_AUDIO_PARAM_CONFIG(513),
    SI_PARAM_CONFIG(514),
    PU_PTZ_PARAM_CONFIG(515),
    PU_REBOOT(516);

    int code;
    int errorCode;

    private DevRight(int code) {
        this(code, 16);
    }

    private DevRight(int code, int errorCode) {
        this.code = code;
        this.errorCode = errorCode;
    }

    public int getCode() {
        return this.code;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return (Object)((Object)this) + " right permission denied.";
    }

    public static DevRight of(int code) {
        for (DevRight right : DevRight.values()) {
            if (right.code != code) continue;
            return right;
        }
        throw new IllegalArgumentException("right code not match to any known DevRight");
    }
}

