/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.util.StringUtil;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class DmdbType {
    public static final int CHAR = 0;
    public static final int VARCHAR2 = 1;
    public static final int VARCHAR = 2;
    public static final int BIT = 3;
    public static final int TINYINT = 5;
    public static final int SMALLINT = 6;
    public static final int INT = 7;
    public static final int BIGINT = 8;
    public static final int DECIMAL = 9;
    public static final int REAL = 10;
    public static final int DOUBLE = 11;
    public static final int BLOB = 12;
    public static final int BOOLEAN = 13;
    public static final int DATE = 14;
    public static final int TIME = 15;
    public static final int DATETIME = 16;
    public static final int BINARY = 17;
    public static final int VARBINARY = 18;
    public static final int CLOB = 19;
    public static final int INTERVAL_YM = 20;
    public static final int INTERVAL_DT = 21;
    public static final int TIME_TZ = 22;
    public static final int DATETIME_TZ = 23;
    public static final int NULL = 25;
    public static final int ANY = 31;
    public static final int STAR_ALL = 32;
    public static final int STAR = 33;
    public static final int RECORD = 40;
    public static final int TYPE = 41;
    public static final int TYPE_REF = 42;
    public static final int UNKNOWN = 54;
    public static final int ARRAY = 117;
    public static final int CLASS = 119;
    public static final int CURSOR = 120;
    public static final int PLTYPE_RECORD = 121;
    public static final int SARRAY = 122;
    public static final int CURSOR_ORACLE = -10;
    public static final int BIT_PREC = 1;
    public static final int TINYINT_PREC = 1;
    public static final int SMALLINT_PREC = 2;
    public static final int INT_PREC = 4;
    public static final int BIGINT_PREC = 8;
    public static final int REAL_PREC = 4;
    public static final int DOUBLE_PREC = 8;
    public static final int DATE_PREC = 3;
    public static final int TIME_PREC = 5;
    public static final int DATETIME_PREC = 8;
    public static final int INTERVAL_YM_PREC = 12;
    public static final int INTERVAL_DT_PREC = 24;
    public static final int TIME_TZ_PREC = 12;
    public static final int DATETIME_TZ_PREC = 12;
    public static final int VARCHAR_PREC = 8188;
    public static final int VARBINARY_PREC = 8188;
    public static final int BLOB_PREC = Integer.MAX_VALUE;
    public static final int CLOB_PREC = Integer.MAX_VALUE;
    public static final int CLASS_PREC = 32768;
    public static final int CURSOR_PREC = 32768;
    public static final int NULL_PREC = 0;
    public static final int LOCAL_TIME_ZONE_SCALE_MASK = 4096;
    public static final int BFILE_PREC = 512;
    public static final int BFILE_SCALE = 6;
    public static final int COMPLEX_SCALE = 5;
    public static final int CURRENCY_PREC = 19;
    public static final int CURRENCY_SCALE = 4;

    public static boolean isInteger(int n2) {
        return n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8;
    }

    public static boolean isNumeric(int n2) {
        return n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8 || n2 == 10 || n2 == 11 || n2 == 9;
    }

    public static boolean isComplexType(int n2, int n3) {
        return n2 == 12 && n3 == 5 || n2 == 117 || n2 == 122 || n2 == 119 || n2 == 121;
    }

    public static boolean isLocalTimeZone(int n2, int n3) {
        return n2 == 16 && (n3 & 0x1000) != 0;
    }

    public static int getLocalTimeZoneScale(int n2, int n3) {
        return n3 & 0xFFFFEFFF;
    }

    public static boolean isBFile(int n2, int n3, int n4) {
        return n2 == 2 && n3 == 512 && n4 == 6;
    }

    public static int d2jType(Column column, DmdbConnection dmdbConnection) {
        int n2 = 1111;
        if (dmdbConnection != null && dmdbConnection.compatibleOracle() && DmdbType.isNumeric(column.type)) {
            return 2;
        }
        block0 : switch (column.type) {
            case 13: {
                n2 = 16;
                break;
            }
            case 3: {
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "BOOLEAN") ? 16 : -7;
                break;
            }
            case 5: {
                n2 = -6;
                break;
            }
            case 6: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = -5;
                break;
            }
            case 9: {
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "NUMERIC") || StringUtil.equalsIgnoreCase(column.typeName, "NUMBER") ? 2 : 3;
                break;
            }
            case 10: {
                n2 = 7;
                break;
            }
            case 11: {
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "FLOAT") ? 6 : 8;
                break;
            }
            case 14: {
                n2 = 91;
                break;
            }
            case 15: {
                n2 = 92;
                break;
            }
            case 16: {
                n2 = 93;
                break;
            }
            case 17: {
                n2 = -2;
                break;
            }
            case 18: {
                n2 = -3;
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(column.type, column.scale) && column.typeDescriptor != null) {
                    switch (column.typeDescriptor.column.type) {
                        case 117: 
                        case 122: {
                            n2 = 2003;
                            break block0;
                        }
                        case 119: 
                        case 121: {
                            n2 = 2002;
                            break block0;
                        }
                    }
                    n2 = 2004;
                    break;
                }
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "LONGVARBINARY") ? -4 : 2004;
                break;
            }
            case 0: 
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 19: {
                if (dmdbConnection != null && dmdbConnection.clobAsString) {
                    n2 = 12;
                    break;
                }
                n2 = StringUtil.equalsIgnoreCase(column.typeName, "LONGVARCHAR") ? -1 : 2005;
                break;
            }
            case 117: 
            case 122: {
                n2 = 2003;
                break;
            }
            case 119: 
            case 121: {
                n2 = 2002;
                break;
            }
            case 54: {
                n2 = 12;
                break;
            }
            default: {
                n2 = 1111;
            }
        }
        return n2;
    }

    public static int j2dType(int n2) {
        int n3 = 54;
        switch (n2) {
            case 16: {
                n3 = 3;
                break;
            }
            case -7: {
                n3 = 3;
                break;
            }
            case -6: {
                n3 = 5;
                break;
            }
            case 5: {
                n3 = 6;
                break;
            }
            case 4: {
                n3 = 7;
                break;
            }
            case -5: {
                n3 = 8;
                break;
            }
            case 6: 
            case 7: {
                n3 = 10;
                break;
            }
            case 8: {
                n3 = 11;
                break;
            }
            case 2: 
            case 3: {
                n3 = 9;
                break;
            }
            case -2: {
                n3 = 17;
                break;
            }
            case -3: {
                n3 = 18;
                break;
            }
            case -4: 
            case 2004: {
                n3 = 12;
                break;
            }
            case -15: 
            case 1: {
                n3 = 0;
                break;
            }
            case -9: 
            case 12: {
                n3 = 2;
                break;
            }
            case -1: 
            case 2005: 
            case 2011: {
                n3 = 19;
                break;
            }
            case 91: {
                n3 = 14;
                break;
            }
            case 92: {
                n3 = 15;
                break;
            }
            case 93: {
                n3 = 16;
                break;
            }
            case 2003: {
                n3 = 117;
                break;
            }
            case 2000: 
            case 2002: {
                n3 = 119;
                break;
            }
            case 0: {
                n3 = 25;
                break;
            }
            default: {
                n3 = 2;
            }
        }
        return n3;
    }

    public static int d2jPrec(int n2, int n3, int n4) {
        int n5 = n3;
        switch (n2) {
            case 3: 
            case 13: {
                n5 = 1;
                break;
            }
            case 5: {
                n5 = 3;
                break;
            }
            case 6: {
                n5 = 5;
                break;
            }
            case 7: {
                n5 = 10;
                break;
            }
            case 8: {
                n5 = 19;
                break;
            }
            case 10: {
                n5 = 24;
                break;
            }
            case 11: {
                n5 = 53;
                break;
            }
            case 14: {
                n5 = 10;
                break;
            }
            case 15: {
                n5 = n4 != 0 ? 9 + n4 : 8;
                break;
            }
            case 16: {
                if (DmdbType.isLocalTimeZone(n2, n4)) {
                    n4 = DmdbType.getLocalTimeZoneScale(n2, n4);
                }
                n5 = n4 != 0 ? 20 + n4 : 19;
                break;
            }
            case 20: 
            case 21: {
                n5 = n4 >> 4 & 0xF;
                break;
            }
            default: {
                n5 = n3;
            }
        }
        return n5;
    }

    public static String getClassName(int n2, int n3) {
        String string = null;
        block0 : switch (n2) {
            case -7: 
            case 16: {
                string = Boolean.class.getName();
                break;
            }
            case -6: {
                string = Byte.class.getName();
                break;
            }
            case 5: {
                string = Short.class.getName();
                break;
            }
            case 4: {
                string = Integer.class.getName();
                break;
            }
            case -5: {
                string = Long.class.getName();
                break;
            }
            case 2: 
            case 3: {
                string = BigDecimal.class.getName();
                break;
            }
            case 7: {
                string = Float.class.getName();
                break;
            }
            case 6: 
            case 8: {
                string = Float.class.getName();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                string = String.class.getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = byte[].class.getName();
                break;
            }
            case 91: {
                string = Date.class.getName();
                break;
            }
            case 92: {
                string = Time.class.getName();
                break;
            }
            case 93: {
                string = Timestamp.class.getName();
                break;
            }
            case 2004: {
                string = Blob.class.getName();
                break;
            }
            case 2005: {
                string = Clob.class.getName();
                break;
            }
            case 2003: {
                string = Array.class.getName();
                break;
            }
            case 2002: {
                string = Struct.class.getName();
                break;
            }
            default: {
                switch (n3) {
                    case 22: {
                        string = DmdbTimestamp.class.getName();
                        break block0;
                    }
                    case 21: {
                        string = DmdbIntervalDT.class.getName();
                        break block0;
                    }
                    case 20: {
                        string = DmdbIntervalYM.class.getName();
                        break block0;
                    }
                    case 23: {
                        string = DmdbTimestamp.class.getName();
                        break block0;
                    }
                }
                string = Object.class.getName();
            }
        }
        return string;
    }

    public static boolean canCastToDecimal(Object object) {
        return object != null && (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigDecimal || object instanceof String);
    }

    public static boolean emptyStringToNull(int n2) {
        switch (n2) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public static final int j2dPrec(int n2, int n3) {
        int n4 = n3;
        switch (n2) {
            case 3: 
            case 13: {
                n4 = 1;
                break;
            }
            case 5: {
                n4 = 1;
                break;
            }
            case 6: {
                n4 = 2;
                break;
            }
            case 7: {
                n4 = 4;
                break;
            }
            case 8: {
                n4 = 8;
                break;
            }
            case 1: 
            case 2: {
                n4 = 8188;
                break;
            }
            case 19: {
                n4 = Integer.MAX_VALUE;
                break;
            }
            case 18: {
                n4 = 8188;
                break;
            }
            case 12: {
                n4 = Integer.MAX_VALUE;
                break;
            }
            case 14: {
                n4 = 3;
                break;
            }
            case 15: {
                n4 = 5;
                break;
            }
            case 16: {
                n4 = 8;
                break;
            }
            case 23: {
                n4 = 12;
                break;
            }
            case 22: {
                n4 = 12;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                n4 = 0;
                break;
            }
        }
        return n4;
    }
}

