/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.java.a.a;
import dm.java.a.b;
import dm.java.a.c;
import dm.java.a.d;
import dm.java.a.e;
import dm.java.a.g;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.MathUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;

public class DmdbTimestamp
extends Timestamp
implements Serializable {
    private static final long serialVersionUID = 544720274538766252L;
    public static final long MiSeconds_1900_1970 = 2209017600000L;
    public static final int MAX_YEAR = 9999;
    public static final int MIN_YEAR = -4712;
    public static final int OFFSET_YEAR = 0;
    public static final int OFFSET_MONTH = 1;
    public static final int OFFSET_DAY = 2;
    public static final int OFFSET_HOUR = 3;
    public static final int OFFSET_MINUTE = 4;
    public static final int OFFSET_SECOND = 5;
    public static final int OFFSET_MICROSECOND = 6;
    public static final int OFFSET_TIMEZONE = 7;
    public static final int DT_LEN = 8;
    public static final int INVALID_VALUE = Integer.MIN_VALUE;
    public int[] dt;
    public int dtype = 16;
    public int scale = 6;
    private String oracleFormatPattern;
    private int oracleDateLanguage;

    public DmdbTimestamp(int[] nArray, int n2, int n3) {
        super(DateUtil.toTimeInMillis(nArray));
        this.dt = nArray;
        this.dtype = n2;
        this.scale = n3;
        this.setNanos(this.getNanos());
    }

    public DmdbTimestamp(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        this(DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone), column.type, DmdbType.isLocalTimeZone(column.type, column.scale) ? DmdbType.getLocalTimeZoneScale(column.type, column.scale) : column.scale);
        this.oracleDateLanguage = dmdbConnection.oracleDateLanguage;
        switch (column.type) {
            case 14: {
                this.oracleFormatPattern = dmdbConnection.formatDate;
                break;
            }
            case 15: {
                this.oracleFormatPattern = dmdbConnection.formatTime;
                break;
            }
            case 22: {
                this.oracleFormatPattern = dmdbConnection.formatTimeTZ;
                break;
            }
            case 16: {
                this.oracleFormatPattern = dmdbConnection.formatTimestamp;
                break;
            }
            case 23: {
                this.oracleFormatPattern = dmdbConnection.formatTimestampTZ;
                break;
            }
        }
    }

    @Override
    public long getTime() {
        return DateUtil.toTimeInMillis(this.dt, null);
    }

    @Override
    public void setTime(long l2) {
        super.setTime(l2);
        this.dt = DateUtil.toDT(l2, null);
    }

    @Override
    public int getNanos() {
        return this.dt[6] * 1000;
    }

    @Override
    public void setNanos(int n2) {
        super.setNanos(n2);
        this.dt[6] = n2 / 1000;
    }

    @Override
    public int compareTo(DmdbTimestamp dmdbTimestamp) {
        int n2;
        int[] nArray = dmdbTimestamp.dt;
        if (this.getTimezone() != dmdbTimestamp.getTimezone()) {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
            DateUtil.transformTZ(nArray, this.dt[7], nArray[7]);
        }
        return (n2 = MathUtil.compare(DateUtil.toTimeInMillis(this.dt), DateUtil.toTimeInMillis(nArray))) != 0 ? n2 : MathUtil.compare(this.dt[6], nArray[6]);
    }

    public static DmdbTimestamp valueOf(String string) {
        int n2;
        int[] nArray;
        return new DmdbTimestamp(nArray, n2, (n2 = DateUtil.toDT(string, nArray = new int[8])) == 14 ? 0 : 6);
    }

    public static DmdbTimestamp valueOf(java.util.Date date) {
        int[] nArray = DateUtil.toDT(date, Calendar.getInstance());
        return new DmdbTimestamp(nArray, 16, 6);
    }

    public static DmdbTimestamp valueOf(a a2) {
        int[] nArray = new int[8];
        nArray[0] = a2.getYear();
        nArray[1] = a2.a();
        nArray[2] = a2.b();
        nArray[7] = Integer.MIN_VALUE;
        return new DmdbTimestamp(nArray, 14, 0);
    }

    public static DmdbTimestamp valueOf(c c2) {
        int[] nArray = new int[]{1900, 1, 1, c2.getHour(), c2.getMinute(), c2.getSecond(), c2.c() / 1000, Integer.MIN_VALUE};
        return new DmdbTimestamp(nArray, 15, 6);
    }

    public static DmdbTimestamp valueOf(b b2) {
        int[] nArray = new int[]{b2.getYear(), b2.a(), b2.b(), b2.getHour(), b2.getMinute(), b2.getSecond(), b2.c() / 1000, Integer.MIN_VALUE};
        return new DmdbTimestamp(nArray, 16, 6);
    }

    public static DmdbTimestamp valueOf(g g2) {
        int[] nArray = new int[]{g2.getYear(), g2.a(), g2.b(), g2.getHour(), g2.getMinute(), g2.getSecond(), g2.c() / 1000, g2.d().e() / 60};
        return new DmdbTimestamp(nArray, 23, 6);
    }

    public static DmdbTimestamp valueOf(d d2) {
        int[] nArray = new int[]{d2.getYear(), d2.a(), d2.b(), d2.getHour(), d2.getMinute(), d2.getSecond(), d2.c() / 1000, d2.d().e() / 60};
        return new DmdbTimestamp(nArray, 23, 6);
    }

    public static DmdbTimestamp valueOf(e e2) {
        int[] nArray = new int[]{1900, 1, 1, e2.getHour(), e2.getMinute(), e2.getSecond(), e2.c() / 1000, e2.d().e() / 60};
        return new DmdbTimestamp(nArray, 22, 6);
    }

    public Date toDate() {
        return DateUtil.toDate(this.dt, null);
    }

    public Time toTime() {
        return DateUtil.toTime(this.dt, null);
    }

    public Timestamp toTimestamp() {
        return DateUtil.toTimestamp(this.dt, null);
    }

    public byte[] toBytes() {
        return DateUtil.encode(this.dt, this.dtype, this.scale, this.getTimezone());
    }

    public int[] getDt() {
        return this.dt;
    }

    public int getTimezone() {
        return this.dt[7];
    }

    public void setTimezone(int n2) {
        if (n2 <= -780 || n2 > 840) {
            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
        }
        this.dt[7] = n2;
    }

    @Override
    public String toString() {
        if (StringUtil.isNotEmpty(this.oracleFormatPattern)) {
            return DateUtil.toString(this.dt, this.oracleFormatPattern, this.oracleDateLanguage);
        }
        return DateUtil.toString(this.dt, this.dtype, this.scale);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DmdbTimestamp)) {
            return false;
        }
        DmdbTimestamp dmdbTimestamp = (DmdbTimestamp)object;
        return dmdbTimestamp.dtype == this.dtype && dmdbTimestamp.scale == this.scale && Arrays.equals(this.dt, dmdbTimestamp.dt);
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.dtype;
        n2 = 31 * n2 + this.scale;
        n2 = 31 * n2 + Arrays.hashCode(this.dt);
        return n2;
    }

    public static void main(String[] stringArray) {
        DmdbTimestamp dmdbTimestamp;
        DmdbTimestamp dmdbTimestamp2 = dmdbTimestamp = DmdbTimestamp.valueOf("2018-09-07 16:09:13.123456");
        System.out.println(dmdbTimestamp2);
    }

    public static /* bridge */ /* synthetic */ Timestamp valueOf(String string) {
        return DmdbTimestamp.valueOf(string);
    }
}

