/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.java.a.a;
import dm.java.a.b;
import dm.java.a.c;
import dm.java.a.d;
import dm.java.a.e;
import dm.java.a.g;
import dm.jdbc.convert.J2DB;
import dm.jdbc.convert.OffRowBinder;
import dm.jdbc.desc.Column;
import dm.jdbc.desc.ExecuteRetInfo;
import dm.jdbc.desc.PStmtCacheInfo;
import dm.jdbc.desc.Parameter;
import dm.jdbc.desc.StructDescriptor;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbNumeric;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbSQLOutput;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.MathUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DmdbPreparedStatement
extends DmdbStatement
implements PreparedStatement {
    public int autoGeneratedKeys = 2;
    public Parameter[] params = new Parameter[0];
    public Parameter[] execParams;
    public int paramCount = 0;
    public List paramObjectsList = new ArrayList();
    public boolean hasOffRow;
    public Object[] curRowObjects = null;
    public int rowIndex = 0;
    public static final byte BIND_IO_IN = 1;
    public static final byte BIND_IO_OUT = 16;
    public boolean preExec = false;
    public byte[] curRowBindIndicator = null;
    public String[] generateKeyColumnNames = null;
    public boolean executeError;
    public PStmtCacheInfo poolInfo;

    private DmdbPreparedStatement(DmdbConnection dmdbConnection, String string, int n2, int n3, int n4, int n5) {
        super(dmdbConnection, n2, n3, n4);
        this.type = 2;
        this.autoGeneratedKeys = n5;
        this.allocateHandle(string);
        this.do_clearParameters();
    }

    public DmdbPreparedStatement(DmdbConnection dmdbConnection, String string, int n2) {
        this(dmdbConnection, string, dmdbConnection.resultSetType, 1007, dmdbConnection.resultSetHoldability, n2);
    }

    public DmdbPreparedStatement(DmdbConnection dmdbConnection, String string, int n2, int n3, int n4) {
        this(dmdbConnection, string, n2, n3, n4, 2);
    }

    @Override
    protected void allocateHandle() {
    }

    protected void allocateHandle(String string) {
        PStmtCacheInfo pStmtCacheInfo = this.poolInfo = this.connection.pstmtPool != null && this.connection.pstmtPool.size() > 0 ? (PStmtCacheInfo)this.connection.pstmtPool.get(string) : null;
        if (this.poolInfo != null) {
            this.handle = this.poolInfo.handle;
            this.cursorName = this.poolInfo.cursorName;
            this.readBaseColName = this.poolInfo.readBaseColName;
            this.nativeSql = string;
            this.params = this.poolInfo.params;
            this.paramCount = this.poolInfo.paramCount;
            this.rowIndex = 0;
            this.paramObjectsList = new ArrayList();
            this.curRowObjects = new Object[this.poolInfo.paramCount];
            this.curRowBindIndicator = new byte[this.poolInfo.paramCount];
            this.execInfo = this.poolInfo.execInfo;
            this.closed = false;
        } else {
            super.allocateHandle();
            try {
                this.prepareSql(string);
            }
            catch (SQLException sQLException) {
                this.free();
                throw sQLException;
            }
        }
        this.execParams = this.params;
    }

    private void prepareSql(String string) {
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_SQL_IS_EMPTY.throwException(new String[0]);
        }
        this.nativeSql = string;
        if (this.escapeProcessing) {
            try {
                this.nativeSql = this.connection.do_nativeSQL(string);
            }
            catch (Exception exception) {}
        }
        this.execInfo = this.connection.dbAccess.a(this);
    }

    @Override
    public void do_close() {
        Parameter parameter;
        int n2;
        int n3;
        Parameter[] parameterArray;
        this.do_clearParameters();
        if (this.params != null) {
            parameterArray = this.params;
            n3 = this.params.length;
            n2 = 0;
            while (n2 < n3) {
                parameter = parameterArray[n2];
                parameter.close();
                ++n2;
            }
        }
        if (this.execParams != null) {
            parameterArray = this.execParams;
            n3 = this.execParams.length;
            n2 = 0;
            while (n2 < n3) {
                parameter = parameterArray[n2];
                parameter.close();
                ++n2;
            }
        }
        super.do_close();
    }

    @Override
    public boolean pool() {
        if (!this.closed && this.poolable && !this.executeError && this.connection.pstmtPoolMaxSize > 0) {
            this.connection.pstmtPool.put(this.nativeSql, this.poolInfo != null ? this.poolInfo : new PStmtCacheInfo(this.handle, this.cursorName, this.readBaseColName, this.nativeSql, this.params, this.execInfo));
            return true;
        }
        return false;
    }

    @Override
    public void reconnect() {
        super.reconnect();
        this.allocateHandle(this.nativeSql);
    }

    protected void checkParametersByIndex() {
        int n2 = 0;
        while (n2 < this.paramCount) {
            if (this.params[n2].type == 120) {
                if (this.params[n2].cursorStmt == null) {
                    this.params[n2].cursorStmt = this.connection.do_createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
                }
                int n3 = n2;
                this.curRowBindIndicator[n3] = (byte)(this.curRowBindIndicator[n3] | 1);
            } else if (this.params[n2].ioType != 1 && (this.curRowBindIndicator[n2] & 1) == 0) {
                if (this.params[n2].ioType == 2 && (this.curRowBindIndicator[n2] & 0x10) != 0) {
                    int n4 = n2;
                    this.curRowBindIndicator[n4] = (byte)(this.curRowBindIndicator[n4] | 1);
                    this.curRowObjects[n2] = null;
                } else {
                    DBError.ECJDBC_UNBINDED_PARAMETER.throwException(new String[0]);
                    break;
                }
            }
            ++n2;
        }
    }

    protected void checkParameters() {
        this.checkParametersByIndex();
        this.execParams = this.params;
    }

    protected void beforeExectueWithParameters(boolean bl) {
        if (!bl) {
            this.checkParameters();
        }
        int n2 = 0;
        while (n2 < this.paramCount) {
            if (!StringUtil.equals(this.params[n2].name, this.execParams[n2].name)) {
                this.connection.dbAccess.a(this, this.execParams, true);
                this.preExec = true;
                break;
            }
            ++n2;
        }
    }

    protected void executeInner() {
        this.execInfo = this.connection.dbAccess.a(this, this.execParams, this.curRowObjects, this.preExec);
        if (this.execInfo.hasResultSet) {
            this.curResultSet = this.createAndCacheResultSet((short)1, this.execInfo);
        }
    }

    private long[] executeBatchByRow() {
        if (this.rowIndex > 0) {
            int n2 = this.rowIndex;
            this.execInfo = new ExecuteRetInfo();
            this.execInfo.updateCounts = new long[n2];
            ArrayList<String> arrayList = new ArrayList<String>();
            int n3 = 0;
            while (n3 < n2) {
                block14: {
                    try {
                        ExecuteRetInfo sQLException = this.connection.dbAccess.a(this, this.execParams, (Object[])this.paramObjectsList.get(n3), this.preExec || n3 != 0);
                        this.execInfo.union(sQLException, n3, 1);
                    }
                    catch (SQLException sQLException) {
                        Object object;
                        this.execInfo.updateCounts[n3] = -3L;
                        if (this.connection.batchContinueOnError) {
                            arrayList.add("row[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            object = new SQLWarning("row[" + n3 + "]:" + sQLException.getErrorCode() + ", " + sQLException.getMessage());
                            this.addSQLWarning((SQLWarning)object);
                            if (this.connection.compatibleOracle()) {
                                this.execInfo.updateCounts[n3] = -2L;
                            }
                            break block14;
                        }
                        try {
                            object = new long[n3 + 1];
                            System.arraycopy(this.execInfo.updateCounts, 0, object, 0, ((Object)object).length);
                            DBError.throwBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), (long[])object);
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (this.connection.compatibleOracle()) {
                                this.execInfo.updateCounts[n3] = -2L;
                            }
                        }
                    }
                    if (this.connection.compatibleOracle()) {
                        this.execInfo.updateCounts[n3] = -2L;
                    }
                }
                ++n3;
            }
            if (arrayList.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : arrayList) {
                    stringBuilder.append(StringUtil.LINE_SEPARATOR).append(string);
                }
                DBError.throwBatchUpdateException(String.valueOf(DBError.EC_BP_WITH_ERROR.reason) + stringBuilder.toString(), DBError.EC_BP_WITH_ERROR.sqlState, DBError.EC_BP_WITH_ERROR.errCode, this.execInfo.updateCounts);
            }
            return this.execInfo.updateCounts;
        }
        return new long[0];
    }

    public boolean do_execute() {
        try {
            this.beforeExecute();
            this.beforeExectueWithParameters(false);
            this.executeInner();
            boolean bl = this.curResultSet != null;
            return bl;
        }
        finally {
            this.afterExecute();
        }
    }

    public DmdbResultSet do_executeQuery() {
        try {
            this.beforeExecute();
            this.beforeExectueWithParameters(false);
            this.executeInner();
            DmdbResultSet dmdbResultSet = this.curResultSet == null ? DmdbResultSet.newEmptyResultSet(this) : this.curResultSet;
            return dmdbResultSet;
        }
        finally {
            this.afterExecute();
        }
    }

    public int do_executeUpdate() {
        try {
            this.beforeExecute();
            this.beforeExectueWithParameters(false);
            this.executeInner();
            if (!this.connection.compatibleOracle() && this.curResultSet != null) {
                DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
            }
            int n2 = this.do_getUpdateCount();
            return n2;
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public int[] do_executeBatch() {
        long[] lArray = this.do_executeLargeBatch();
        int[] nArray = lArray == null ? new int[]{} : new int[lArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = ConvertUtil.toInt(lArray[n2]);
            ++n2;
        }
        return nArray;
    }

    @Override
    public long[] do_executeLargeBatch() {
        if (this.batchSqls != null && this.batchSqls.size() > 0) {
            return super.do_executeLargeBatch();
        }
        try {
            int n2;
            this.beforeExecute();
            this.beforeExectueWithParameters(true);
            if (this.connection.readOnly) {
                DBError.ECJDBC_READ_ONLY_CONNECTION.throwException(new String[0]);
            }
            if (this.execInfo.retSqlType == 160 || this.execInfo.retSqlType == 198) {
                DBError.throwBatchUpdateException(DBError.ECJDBC_INVALID_SQL_TYPE.reason, DBError.ECJDBC_INVALID_SQL_TYPE.sqlState, DBError.ECJDBC_INVALID_SQL_TYPE.errCode, new long[0]);
            }
            int n3 = n2 = this.rowIndex > 0 ? this.rowIndex : 0;
            if (n2 > 0) {
                if (n2 == 1 || this.connection.batchType == 2 || this.connection.batchNotOnCall && this.execInfo.retSqlType == 162) {
                    long[] lArray = this.executeBatchByRow();
                    return lArray;
                }
                this.execInfo = this.connection.dbAccess.a(this, this.execParams, this.paramObjectsList, this.preExec);
                long[] lArray = this.execInfo.updateCounts;
                return lArray;
            }
            long[] lArray = new long[]{};
            return lArray;
        }
        finally {
            if (this.clearBatch) {
                this.do_clearBatch();
            }
            this.afterExecute();
        }
    }

    public void do_addBatch() {
        this.checkParameters();
        this.paramObjectsList.add(this.curRowObjects);
        ++this.rowIndex;
        Object[] objectArray = new Object[this.paramCount];
        System.arraycopy(this.curRowObjects, 0, objectArray, 0, this.paramCount);
        this.curRowObjects = objectArray;
    }

    @Override
    public void do_clearBatch() {
        this.rowIndex = 0;
        if (this.paramObjectsList != null) {
            this.paramObjectsList.clear();
        }
        super.do_clearBatch();
    }

    public void do_clearParameters() {
        this.curRowObjects = new Object[this.paramCount];
        this.curRowBindIndicator = new byte[this.paramCount];
    }

    public DmdbResultSetMetaData do_getMetaData() {
        return new DmdbResultSetMetaData(this.connection, this.columns);
    }

    public DmdbParameterMetaData do_getParameterMetaData() {
        return new DmdbParameterMetaData(this);
    }

    @Override
    public DmdbResultSet do_getGeneratedKeys() {
        if (this.generateKeyColumnNames != null && this.execInfo.outParamDatas != null && this.execInfo.outParamDatas.size() > 0) {
            Column[] columnArray = new Column[this.generateKeyColumnNames.length];
            byte[][][] byArray = new byte[this.execInfo.outParamDatas.size()][this.generateKeyColumnNames.length + 1][];
            int n2 = 0;
            byte[][] byArray2 = null;
            int n3 = 0;
            while (n3 < this.execInfo.outParamDatas.size()) {
                byArray2 = (byte[][])this.execInfo.outParamDatas.get(n3);
                int n4 = 0;
                while (n4 < this.generateKeyColumnNames.length) {
                    n2 = this.execParams.length - this.generateKeyColumnNames.length + n4;
                    columnArray[n4] = new Column();
                    columnArray[n4].type = this.execParams[n2].type;
                    columnArray[n4].prec = this.execParams[n2].prec;
                    columnArray[n4].scale = this.execParams[n2].scale;
                    columnArray[n4].typeName = this.execParams[n2].typeName;
                    columnArray[n4].name = this.generateKeyColumnNames[n4];
                    columnArray[n4].nullable = this.execParams[n2].nullable;
                    columnArray[n4].schemaName = this.execParams[n2].schemaName;
                    columnArray[n4].tableName = this.execParams[n2].tableName;
                    byArray[n3][n4 + 1] = new byte[byArray2[n2].length];
                    ByteUtil.setBytes(byArray[n3][n4 + 1], 0, byArray2[n2]);
                    ++n4;
                }
                ++n3;
            }
            return DmdbResultSet.newLocalResultSet(this, columnArray, byArray);
        }
        return super.do_getGeneratedKeys();
    }

    protected boolean prepareBindInParam(int n2, int n3, boolean bl) {
        if (n2 < 1 || n2 > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwException(new String[0]);
        }
        int n4 = n2 - 1;
        if (this.params[n4].ioType == 1) {
            return false;
        }
        int n5 = n4;
        this.curRowBindIndicator[n5] = (byte)(this.curRowBindIndicator[n5] | 1);
        if (this.params[n4].type == 54) {
            this.params[n4].resetType(n3);
        } else if (!bl && this.rowIndex == 0 && this.params[n4].typeFlag != 1) {
            this.params[n4].resetType(n3);
        }
        return true;
    }

    public void do_setNull(int n2, int n3) {
        if (!this.prepareBindInParam(n2, DmdbType.j2dType(n3), true)) {
            return;
        }
        this.curRowObjects[n2 - 1] = null;
    }

    public void do_setNull(int n2, int n3, String string) {
        this.do_setNull(n2, n3);
    }

    public void do_setBoolean(int n2, boolean bl) {
        if (!this.prepareBindInParam(n2, 5, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromBoolean(bl, this.params[n3], this.connection);
    }

    public void do_setByte(int n2, byte by) {
        if (!this.prepareBindInParam(n2, 5, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromLong(by, this.params[n3], this.connection);
    }

    public void do_setShort(int n2, short s2) {
        if (!this.prepareBindInParam(n2, 6, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n2 - 1] = J2DB.fromLong(s2, this.params[n3], this.connection);
    }

    public void do_setInt(int n2, int n3) {
        if (!this.prepareBindInParam(n2, 7, false)) {
            return;
        }
        int n4 = n2 - 1;
        this.curRowObjects[n4] = J2DB.fromLong(n3, this.params[n4], this.connection);
    }

    public void do_setLong(int n2, long l2) {
        if (!this.prepareBindInParam(n2, 8, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromLong(l2, this.params[n3], this.connection);
    }

    public void do_setFloat(int n2, float f2) {
        if (!this.prepareBindInParam(n2, 10, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromFloat(f2, this.params[n3], this.connection);
    }

    public void do_setDouble(int n2, double d2) {
        if (!this.prepareBindInParam(n2, 11, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromDouble(d2, this.params[n3], this.connection);
    }

    public void do_setBigDecimal(int n2, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.do_setNull(n2, 9);
            return;
        }
        int n3 = 9;
        if (bigDecimal.compareTo(DmdbNumeric.MAX_VALUE) > 0 || bigDecimal.compareTo(DmdbNumeric.MIN_VALUE) < 0) {
            n3 = 2;
        }
        int n4 = n2 - 1;
        if (!this.prepareBindInParam(n2, n3, false)) {
            return;
        }
        this.curRowObjects[n4] = J2DB.fromBigDecimal(bigDecimal, this.params[n4], this.connection);
    }

    public void do_setString(int n2, String string) {
        if (string == null || string.length() == 0 && DmdbType.emptyStringToNull(this.params[n2 - 1].type)) {
            this.do_setNull(n2, 2);
            return;
        }
        if (!this.prepareBindInParam(n2, 2, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromString(string, this.params[n3], this.connection);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setBytes(int n2, byte[] byArray) {
        if (byArray == null) {
            this.do_setNull(n2, 18);
            return;
        }
        if (!this.prepareBindInParam(n2, 18, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromBytes(byArray, this.params[n3], this.connection);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setDate(int n2, Date date) {
        this.do_setDate(n2, date, null);
    }

    public void do_setDate(int n2, Date date, Calendar calendar) {
        if (date == null) {
            this.do_setNull(n2, 14);
            return;
        }
        if (!this.prepareBindInParam(n2, 14, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromDate(date, this.params[n3], this.connection, calendar);
    }

    public void do_setTime(int n2, Time time) {
        this.do_setTime(n2, time, null);
    }

    public void do_setTime(int n2, Time time, Calendar calendar) {
        if (time == null) {
            this.do_setNull(n2, 15);
            return;
        }
        if (!this.prepareBindInParam(n2, 15, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromDate(time, this.params[n3], this.connection, calendar != null ? (Calendar)calendar.clone() : null);
    }

    public void do_setTimestamp(int n2, Timestamp timestamp) {
        this.do_setTimestamp(n2, timestamp, null);
    }

    public void do_setTimestamp(int n2, Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            this.do_setNull(n2, 16);
            return;
        }
        if (!this.prepareBindInParam(n2, 16, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromDate(timestamp, this.params[n3], this.connection, calendar != null ? (Calendar)calendar.clone() : null);
    }

    public void do_setAsciiStream(int n2, InputStream inputStream) {
        this.do_setAsciiStream(n2, inputStream, -1);
    }

    public void do_setAsciiStream(int n2, InputStream inputStream, int n3) {
        this.do_setAsciiStream(n2, inputStream, (long)n3);
    }

    public void do_setAsciiStream(int n2, InputStream inputStream, long l2) {
        if (inputStream instanceof DmdbInputStream) {
            DmdbInputStream dmdbInputStream = (DmdbInputStream)inputStream;
            Object object = dmdbInputStream.useRealObject(l2);
            if (object instanceof DmdbBlob) {
                this.do_setBlob(n2, (Blob)object);
                return;
            }
            if (object instanceof DmdbClob) {
                this.do_setClob(n2, (Clob)object);
                return;
            }
            if (object instanceof byte[]) {
                this.do_setBytes(n2, (byte[])object);
                return;
            }
        }
        if (inputStream == null) {
            this.do_setNull(n2, 12);
            return;
        }
        if (!this.prepareBindInParam(n2, 12, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromInputStream(inputStream, this.params[n3], this.connection, l2);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setUnicodeStream(int n2, InputStream inputStream) {
        this.do_setUnicodeStream(n2, inputStream, -1);
    }

    public void do_setUnicodeStream(int n2, InputStream inputStream, int n3) {
        if (inputStream == null) {
            this.do_setNull(n2, 12);
            return;
        }
        if (!this.prepareBindInParam(n2, 12, false)) {
            return;
        }
        int n4 = n2 - 1;
        this.curRowObjects[n4] = J2DB.fromInputStream(inputStream, this.params[n4], this.connection, n3);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n4] instanceof OffRowBinder;
        }
    }

    public void do_setBinaryStream(int n2, InputStream inputStream) {
        this.do_setBinaryStream(n2, inputStream, -1);
    }

    public void do_setBinaryStream(int n2, InputStream inputStream, long l2) {
        if (inputStream instanceof DmdbInputStream) {
            DmdbInputStream dmdbInputStream = (DmdbInputStream)inputStream;
            Object object = dmdbInputStream.useRealObject(l2);
            if (object instanceof DmdbBlob) {
                this.do_setBlob(n2, (Blob)object);
                return;
            }
            if (object instanceof DmdbClob) {
                this.do_setClob(n2, (Clob)object);
                return;
            }
            if (object instanceof byte[]) {
                this.do_setBytes(n2, (byte[])object);
                return;
            }
        }
        if (inputStream == null) {
            this.do_setNull(n2, 12);
            return;
        }
        if (!this.prepareBindInParam(n2, 12, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromInputStream(inputStream, this.params[n3], this.connection, l2);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setBinaryStream(int n2, InputStream inputStream, int n3) {
        this.do_setBinaryStream(n2, inputStream, (long)n3);
    }

    public void do_setCharacterStream(int n2, Reader reader) {
        this.do_setCharacterStream(n2, reader, -1);
    }

    public void do_setCharacterStream(int n2, Reader reader, int n3) {
        this.do_setCharacterStream(n2, reader, (long)n3);
    }

    public void do_setCharacterStream(int n2, Reader reader, long l2) {
        if (reader == null) {
            this.do_setNull(n2, 19);
            return;
        }
        if (!this.prepareBindInParam(n2, 19, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromReader(reader, this.params[n3], this.connection, l2);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setBlob(int n2, Blob blob) {
        if (blob == null) {
            this.do_setNull(n2, 12);
            return;
        }
        if (!this.prepareBindInParam(n2, 12, false)) {
            return;
        }
        int n3 = n2 - 1;
        Object object = this.curRowObjects[n3] = blob instanceof DmdbBlob ? J2DB.fromBlob((DmdbBlob)blob, this.params[n3], this.connection) : J2DB.fromInputStream(blob.getBinaryStream(), this.params[n3], this.connection, -1L);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setClob(int n2, Clob clob) {
        if (clob == null) {
            this.do_setNull(n2, 19);
            return;
        }
        if (!this.prepareBindInParam(n2, 19, false)) {
            return;
        }
        int n3 = n2 - 1;
        Object object = this.curRowObjects[n3] = clob instanceof DmdbClob ? J2DB.fromClob((DmdbClob)clob, this.params[n3], this.connection) : J2DB.fromReader(clob.getCharacterStream(), this.params[n3], this.connection, -1L);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setArray(int n2, Array array) {
        if (array == null) {
            this.do_setNull(n2, 117);
            return;
        }
        if (!this.prepareBindInParam(n2, 117, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromArray((DmdbArray)array, this.params[n3], this.connection);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setStruct(int n2, Struct struct) {
        if (struct == null) {
            this.do_setNull(n2, 119);
            return;
        }
        if (!this.prepareBindInParam(n2, 119, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromStruct((DmdbStruct)struct, this.params[n3], this.connection);
        if (!this.hasOffRow) {
            this.hasOffRow = this.curRowObjects[n3] instanceof OffRowBinder;
        }
    }

    public void do_setObject(int n2, Object object) {
        this.do_setObject(n2, object, 0, -1);
    }

    public void do_setObject(int n2, Object object, int n3) {
        this.do_setObject(n2, object, n3, -1);
    }

    public void do_setObject(int n2, Object object, int n3, int n4) {
        this.do_setObject(n2, object, n3, (long)n4);
    }

    public void do_setObject(int n2, Object object, int n3, long l2) {
        if (l2 != -1L && (n3 == 3 || n3 == 2) && DmdbType.canCastToDecimal(object)) {
            String string = "";
            string = object instanceof Boolean ? ((Boolean)object != false ? "1" : "0") : String.valueOf(object);
            BigDecimal bigDecimal = new BigDecimal(string);
            object = bigDecimal.setScale((int)l2, 4);
        }
        if (object == null) {
            this.do_setNull(n2, n3);
        } else if (object instanceof Boolean) {
            this.do_setBoolean(n2, (Boolean)object);
        } else if (object instanceof Byte) {
            this.do_setByte(n2, (Byte)object);
        } else if (object instanceof Short) {
            this.do_setShort(n2, (Short)object);
        } else if (object instanceof Integer) {
            this.do_setInt(n2, (Integer)object);
        } else if (object instanceof Long) {
            this.do_setLong(n2, (Long)object);
        } else if (object instanceof Float) {
            this.do_setFloat(n2, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.do_setDouble(n2, (Double)object);
        } else if (object instanceof BigDecimal) {
            this.do_setBigDecimal(n2, (BigDecimal)object);
        } else if (object instanceof byte[]) {
            this.do_setBytes(n2, (byte[])object);
        } else if (object instanceof String) {
            this.do_setString(n2, (String)object);
        } else if (object instanceof Clob) {
            this.do_setClob(n2, (Clob)object);
        } else if (object instanceof Blob) {
            this.do_setBlob(n2, (Blob)object);
        } else if (object instanceof InputStream) {
            this.do_setBinaryStream(n2, (InputStream)object, l2);
        } else if (object instanceof Reader) {
            this.do_setCharacterStream(n2, (Reader)object, l2);
        } else if (object instanceof Array) {
            this.do_setArray(n2, (Array)object);
        } else if (object instanceof BigInteger) {
            this.do_setBigDecimal(n2, new BigDecimal((BigInteger)object));
        } else if (object instanceof Character) {
            this.do_setString(n2, object.toString());
        } else if (object instanceof DmdbBFile) {
            this.do_setString(n2, ((DmdbBFile)object).getFileName());
        } else if (object instanceof Struct) {
            this.do_setStruct(n2, (Struct)object);
        } else if (object instanceof SQLData) {
            this.do_setSQLData(n2, (SQLData)object);
        } else if (object instanceof RowId) {
            this.do_setRowId(n2, (RowId)object);
        } else if (object instanceof DmdbTimestamp) {
            this.do_setTIMESTAMP(n2, (DmdbTimestamp)object);
        } else if (object instanceof DmdbIntervalDT) {
            this.do_setINTERVALDT(n2, (DmdbIntervalDT)object);
        } else if (object instanceof DmdbIntervalYM) {
            this.do_setINTERVALYM(n2, (DmdbIntervalYM)object);
        } else if (object instanceof Date) {
            this.do_setDate(n2, (Date)object);
        } else if (object instanceof Time) {
            this.do_setTime(n2, (Time)object);
        } else if (object instanceof Timestamp) {
            this.do_setTimestamp(n2, (Timestamp)object);
        } else if (object instanceof java.util.Date) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((java.util.Date)object));
        } else if (object instanceof a) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((a)object));
        } else if (object instanceof c) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((c)object));
        } else if (object instanceof b) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((b)object));
        } else if (object instanceof g) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((g)object));
        } else if (object instanceof d) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((d)object));
        } else if (object instanceof e) {
            this.do_setTIMESTAMP(n2, DmdbTimestamp.valueOf((e)object));
        } else {
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwException(new String[0]);
        }
    }

    public void do_setSQLData(int n2, SQLData sQLData) {
        String string = sQLData.getSQLTypeName();
        if (this.connection.do_getTypeMap().containsKey(string) && sQLData.getClass() == this.connection.do_getTypeMap().get(string)) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, this.connection);
            DmdbSQLOutput dmdbSQLOutput = new DmdbSQLOutput();
            sQLData.writeSQL(dmdbSQLOutput);
            DmdbStruct dmdbStruct = new DmdbStruct(structDescriptor, this.connection, dmdbSQLOutput.getAttribs());
            this.do_setStruct(n2, dmdbStruct);
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
    }

    public void do_setURL(int n2, URL uRL) {
        if (uRL == null) {
            this.do_setNull(n2, 25);
            return;
        }
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setRef(int n2, Ref ref) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public boolean isReturnGeneratedKeys() {
        return this.autoGeneratedKeys == 1;
    }

    public void do_setNString(int n2, String string) {
        this.do_setString(n2, string);
    }

    public void do_setNCharacterStream(int n2, Reader reader, long l2) {
        this.do_setCharacterStream(n2, reader, l2);
    }

    public void do_setNClob(int n2, Reader reader, long l2) {
        this.do_setClob(n2, reader, l2);
    }

    public void do_setNCharacterStream(int n2, Reader reader) {
        this.do_setCharacterStream(n2, reader);
    }

    public void do_setNClob(int n2, Reader reader) {
        this.do_setClob(n2, reader);
    }

    public void do_setRowId(int n2, RowId rowId) {
        if (rowId == null) {
            this.do_setNull(n2, 8);
        } else {
            long l2 = ((DmdbRowId)rowId).getValue();
            this.do_setLong(n2, l2);
        }
    }

    public void do_setNClob(int n2, NClob nClob) {
        this.do_setClob(n2, nClob);
    }

    public void do_setClob(int n2, Reader reader, long l2) {
        this.do_setCharacterStream(n2, reader, l2);
    }

    public void do_setBlob(int n2, InputStream inputStream, long l2) {
        this.do_setBinaryStream(n2, inputStream, l2);
    }

    public void do_setSQLXML(int n2, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setClob(int n2, Reader reader) {
        this.do_setCharacterStream(n2, reader);
    }

    public void do_setBlob(int n2, InputStream inputStream) {
        this.do_setBinaryStream(n2, inputStream);
    }

    public void do_setObject(int n2, Object object, dm.java.sql.a a2, int n3) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setObject(int n2, Object object, dm.java.sql.a a2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public long do_executeLargeUpdate() {
        try {
            this.beforeExecute();
            this.beforeExectueWithParameters(false);
            this.executeInner();
            if (!this.connection.compatibleOracle() && this.curResultSet != null) {
                DBError.ECJDBC_INVALID_SQL_TYPE.throwException(new String[0]);
            }
            long l2 = this.do_getLargeUpdateCount();
            return l2;
        }
        finally {
            this.afterExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeQuery();
            }
            return this.filterChain.reset().PreparedStatement_executeQuery(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeUpdate();
            }
            return this.filterChain.reset().PreparedStatement_executeUpdate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeBatch();
            }
            return this.filterChain.reset().PreparedStatement_executeBatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeBatch();
            }
            return this.filterChain.reset().PreparedStatement_executeLargeBatch(this);
        }
    }

    @Override
    public void setNull(int n2, int n3) {
        if (this.filterChain == null) {
            this.do_setNull(n2, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setNull(this, n2, n3);
        }
    }

    @Override
    public void setBoolean(int n2, boolean bl) {
        if (this.filterChain == null) {
            this.do_setBoolean(n2, bl);
        } else {
            this.filterChain.reset().PreparedStatement_setBoolean(this, n2, bl);
        }
    }

    @Override
    public void setByte(int n2, byte by) {
        if (this.filterChain == null) {
            this.do_setByte(n2, by);
        } else {
            this.filterChain.reset().PreparedStatement_setByte(this, n2, by);
        }
    }

    @Override
    public void setShort(int n2, short s2) {
        if (this.filterChain == null) {
            this.do_setShort(n2, s2);
        } else {
            this.filterChain.reset().PreparedStatement_setShort(this, n2, s2);
        }
    }

    @Override
    public void setInt(int n2, int n3) {
        if (this.filterChain == null) {
            this.do_setInt(n2, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setInt(this, n2, n3);
        }
    }

    @Override
    public void setLong(int n2, long l2) {
        if (this.filterChain == null) {
            this.do_setLong(n2, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setLong(this, n2, l2);
        }
    }

    @Override
    public void setFloat(int n2, float f2) {
        if (this.filterChain == null) {
            this.do_setFloat(n2, f2);
        } else {
            this.filterChain.reset().PreparedStatement_setFloat(this, n2, f2);
        }
    }

    @Override
    public void setDouble(int n2, double d2) {
        if (this.filterChain == null) {
            this.do_setDouble(n2, d2);
        } else {
            this.filterChain.reset().PreparedStatement_setDouble(this, n2, d2);
        }
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) {
        if (this.filterChain == null) {
            this.do_setBigDecimal(n2, bigDecimal);
        } else {
            this.filterChain.reset().PreparedStatement_setBigDecimal(this, n2, bigDecimal);
        }
    }

    @Override
    public void setString(int n2, String string) {
        if (this.filterChain == null) {
            this.do_setString(n2, string);
        } else {
            this.filterChain.reset().PreparedStatement_setString(this, n2, string);
        }
    }

    @Override
    public void setBytes(int n2, byte[] byArray) {
        if (this.filterChain == null) {
            this.do_setBytes(n2, byArray);
        } else {
            this.filterChain.reset().PreparedStatement_setBytes(this, n2, byArray);
        }
    }

    @Override
    public void setDate(int n2, Date date) {
        if (this.filterChain == null) {
            this.do_setDate(n2, date);
        } else {
            this.filterChain.reset().PreparedStatement_setDate(this, n2, date);
        }
    }

    @Override
    public void setTime(int n2, Time time) {
        if (this.filterChain == null) {
            this.do_setTime(n2, time);
        } else {
            this.filterChain.reset().PreparedStatement_setTime(this, n2, time);
        }
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) {
        if (this.filterChain == null) {
            this.do_setTimestamp(n2, timestamp);
        } else {
            this.filterChain.reset().PreparedStatement_setTimestamp(this, n2, timestamp);
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(n2, inputStream, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setAsciiStream(this, n2, inputStream, n3);
        }
    }

    @Override
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) {
        if (this.filterChain == null) {
            this.do_setUnicodeStream(n2, inputStream, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setUnicodeStream(this, n2, inputStream, n3);
        }
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(n2, inputStream, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setBinaryStream(this, n2, inputStream, n3);
        }
    }

    @Override
    public void clearParameters() {
        if (this.filterChain == null) {
            this.do_clearParameters();
        } else {
            this.filterChain.reset().PreparedStatement_clearParameters(this);
        }
    }

    @Override
    public void setObject(int n2, Object object, int n3) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object, n3);
        }
    }

    @Override
    public void setObject(int n2, Object object) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_execute();
            }
            return this.filterChain.reset().PreparedStatement_execute(this);
        }
    }

    @Override
    public void addBatch() {
        if (this.filterChain == null) {
            this.do_addBatch();
        } else {
            this.filterChain.reset().PreparedStatement_addBatch(this);
        }
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(n2, reader, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setCharacterStream(this, n2, reader, n3);
        }
    }

    @Override
    public void setRef(int n2, Ref ref) {
        if (this.filterChain == null) {
            this.do_setRef(n2, ref);
        } else {
            this.filterChain.reset().PreparedStatement_setRef(this, n2, ref);
        }
    }

    @Override
    public void setBlob(int n2, Blob blob) {
        if (this.filterChain == null) {
            this.do_setBlob(n2, blob);
        } else {
            this.filterChain.reset().PreparedStatement_setBlob(this, n2, blob);
        }
    }

    @Override
    public void setClob(int n2, Clob clob) {
        if (this.filterChain == null) {
            this.do_setClob(n2, clob);
        } else {
            this.filterChain.reset().PreparedStatement_setClob(this, n2, clob);
        }
    }

    @Override
    public void setArray(int n2, Array array) {
        if (this.filterChain == null) {
            this.do_setArray(n2, array);
        } else {
            this.filterChain.reset().PreparedStatement_setArray(this, n2, array);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        if (this.filterChain == null) {
            return this.do_getMetaData();
        }
        return this.filterChain.reset().PreparedStatement_getMetaData(this);
    }

    @Override
    public void setDate(int n2, Date date, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setDate(n2, date, calendar);
        } else {
            this.filterChain.reset().PreparedStatement_setDate(this, n2, date, calendar);
        }
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setTime(n2, time, calendar);
        } else {
            this.filterChain.reset().PreparedStatement_setTime(this, n2, time, calendar);
        }
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setTimestamp(n2, timestamp, calendar);
        } else {
            this.filterChain.reset().PreparedStatement_setTimestamp(this, n2, timestamp, calendar);
        }
    }

    @Override
    public void setNull(int n2, int n3, String string) {
        if (this.filterChain == null) {
            this.do_setNull(n2, n3, string);
        } else {
            this.filterChain.reset().PreparedStatement_setNull(this, n2, n3, string);
        }
    }

    @Override
    public void setURL(int n2, URL uRL) {
        if (this.filterChain == null) {
            this.do_setURL(n2, uRL);
        } else {
            this.filterChain.reset().PreparedStatement_setURL(this, n2, uRL);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        if (this.filterChain == null) {
            return this.do_getParameterMetaData();
        }
        return this.filterChain.reset().PreparedStatement_getParameterMetaData(this);
    }

    @Override
    public void setRowId(int n2, RowId rowId) {
        if (this.filterChain == null) {
            this.do_setRowId(n2, rowId);
        } else {
            this.filterChain.reset().PreparedStatement_setRowId(this, n2, rowId);
        }
    }

    @Override
    public void setNString(int n2, String string) {
        if (this.filterChain == null) {
            this.do_setNString(n2, string);
        } else {
            this.filterChain.reset().PreparedStatement_setNString(this, n2, string);
        }
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setNCharacterStream(n2, reader, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setNCharacterStream(this, n2, reader, l2);
        }
    }

    @Override
    public void setNClob(int n2, NClob nClob) {
        if (this.filterChain == null) {
            this.do_setNClob(n2, nClob);
        } else {
            this.filterChain.reset().PreparedStatement_setNClob(this, n2, nClob);
        }
    }

    @Override
    public void setClob(int n2, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setClob(n2, reader, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setClob(this, n2, reader, l2);
        }
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setBlob(n2, inputStream, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setBlob(this, n2, inputStream, l2);
        }
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setNClob(n2, reader, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setNClob(this, n2, reader, l2);
        }
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) {
        if (this.filterChain == null) {
            this.do_setSQLXML(n2, sQLXML);
        } else {
            this.filterChain.reset().PreparedStatement_setSQLXML(this, n2, sQLXML);
        }
    }

    @Override
    public void setObject(int n2, Object object, int n3, int n4) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object, n3, n4);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object, n3, n4);
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(n2, inputStream, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setAsciiStream(this, n2, inputStream, l2);
        }
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(n2, inputStream, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setBinaryStream(this, n2, inputStream, l2);
        }
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(n2, reader, l2);
        } else {
            this.filterChain.reset().PreparedStatement_setCharacterStream(this, n2, reader, l2);
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(n2, inputStream);
        } else {
            this.filterChain.reset().PreparedStatement_setAsciiStream(this, n2, inputStream);
        }
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(n2, inputStream);
        } else {
            this.filterChain.reset().PreparedStatement_setBinaryStream(this, n2, inputStream);
        }
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(n2, reader);
        } else {
            this.filterChain.reset().PreparedStatement_setCharacterStream(this, n2, reader);
        }
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) {
        if (this.filterChain == null) {
            this.do_setNCharacterStream(n2, reader);
        } else {
            this.filterChain.reset().PreparedStatement_setNCharacterStream(this, n2, reader);
        }
    }

    @Override
    public void setClob(int n2, Reader reader) {
        if (this.filterChain == null) {
            this.do_setClob(n2, reader);
        } else {
            this.filterChain.reset().PreparedStatement_setClob(this, n2, reader);
        }
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setBlob(n2, inputStream);
        } else {
            this.filterChain.reset().PreparedStatement_setBlob(this, n2, inputStream);
        }
    }

    @Override
    public void setNClob(int n2, Reader reader) {
        if (this.filterChain == null) {
            this.do_setNClob(n2, reader);
        } else {
            this.filterChain.reset().PreparedStatement_setNClob(this, n2, reader);
        }
    }

    public void setObject(int n2, Object object, dm.java.sql.a a2, int n3) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object, a2, n3);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object, a2, n3);
        }
    }

    public void setObject(int n2, Object object, dm.java.sql.a a2) {
        if (this.filterChain == null) {
            this.do_setObject(n2, object, a2);
        } else {
            this.filterChain.reset().PreparedStatement_setObject(this, n2, object, a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_executeLargeUpdate();
            }
            return this.filterChain.reset().PreparedStatement_executeLargeUpdate(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCompile(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_preCompile(string);
            } else {
                this.filterChain.reset().PreparedStatement_preCompile(this, string);
            }
        }
    }

    public void do_preCompile(String string) {
        try {
            this.beforeExecute();
            this.prepareSql(string);
        }
        finally {
            this.afterExecute();
        }
    }

    public void executeDirect() {
        this.execute();
    }

    public void setINTERVALDT(int n2, DmdbIntervalDT dmdbIntervalDT) {
        if (this.filterChain == null) {
            this.do_setINTERVALDT(n2, dmdbIntervalDT);
        } else {
            this.filterChain.reset().PreparedStatement_setINTERVALDT(this, n2, dmdbIntervalDT);
        }
    }

    public void do_setINTERVALDT(int n2, DmdbIntervalDT dmdbIntervalDT) {
        if (dmdbIntervalDT == null) {
            this.do_setNull(n2, 21);
            return;
        }
        if (!this.prepareBindInParam(n2, 21, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromDmdbIntervalDT(dmdbIntervalDT, this.params[n3], this.connection);
    }

    public void setINTERVALYM(int n2, DmdbIntervalYM dmdbIntervalYM) {
        if (this.filterChain == null) {
            this.do_setINTERVALYM(n2, dmdbIntervalYM);
        } else {
            this.filterChain.reset().PreparedStatement_setINTERVALYM(this, n2, dmdbIntervalYM);
        }
    }

    public void do_setINTERVALYM(int n2, DmdbIntervalYM dmdbIntervalYM) {
        if (dmdbIntervalYM == null) {
            this.do_setNull(n2, 20);
            return;
        }
        if (!this.prepareBindInParam(n2, 20, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromDmdbIntervalYM(dmdbIntervalYM, this.params[n3], this.connection);
    }

    public void setTIMESTAMP(int n2, DmdbTimestamp dmdbTimestamp) {
        if (this.filterChain == null) {
            this.do_setTIMESTAMP(n2, dmdbTimestamp);
        } else {
            this.filterChain.reset().PreparedStatement_setTIMESTAMP(this, n2, dmdbTimestamp);
        }
    }

    public void do_setTIMESTAMP(int n2, DmdbTimestamp dmdbTimestamp) {
        if (dmdbTimestamp == null) {
            this.do_setNull(n2, 16);
            return;
        }
        if (!this.prepareBindInParam(n2, dmdbTimestamp.dtype, false)) {
            return;
        }
        int n3 = n2 - 1;
        this.curRowObjects[n3] = J2DB.fromDmdbTimestamp(dmdbTimestamp, this.params[n3], this.connection);
    }

    public Parameter[] getParameters() {
        return this.params;
    }

    public int getBatchSize() {
        return this.rowIndex > 0 ? this.rowIndex : 0;
    }

    @Override
    public void resetParams(DmdbStatement dmdbStatement) {
        super.resetParams(dmdbStatement);
        if (dmdbStatement instanceof DmdbPreparedStatement) {
            int n2;
            DmdbPreparedStatement dmdbPreparedStatement = (DmdbPreparedStatement)dmdbStatement;
            this.nativeSql = dmdbPreparedStatement.nativeSql;
            if (dmdbPreparedStatement.params != null) {
                if (this.params != null) {
                    n2 = 0;
                    while (n2 < this.params.length) {
                        if (this.params[n2] != null) {
                            this.params[n2].clear();
                        }
                        ++n2;
                    }
                }
                this.params = new Parameter[dmdbPreparedStatement.params.length];
                n2 = 0;
                while (n2 < this.params.length) {
                    this.params[n2] = dmdbPreparedStatement.params[n2].clone(this.connection, dmdbPreparedStatement);
                    ++n2;
                }
            }
            if (dmdbPreparedStatement.execParams != null) {
                if (this.execParams != null) {
                    n2 = 0;
                    while (n2 < this.execParams.length) {
                        if (this.execParams[n2] != null) {
                            this.execParams[n2].clear();
                        }
                        ++n2;
                    }
                }
                this.execParams = new Parameter[dmdbPreparedStatement.execParams.length];
                n2 = 0;
                while (n2 < this.execParams.length) {
                    this.execParams[n2] = dmdbPreparedStatement.execParams[n2].clone(this.connection, dmdbPreparedStatement);
                    ++n2;
                }
            }
            this.paramCount = dmdbPreparedStatement.paramCount;
            if (dmdbPreparedStatement.rowIndex > 0 || dmdbPreparedStatement.paramObjectsList != null && dmdbPreparedStatement.paramObjectsList.size() > 0 || MathUtil.max(dmdbPreparedStatement.curRowBindIndicator) > 0) {
                this.rowIndex = dmdbPreparedStatement.rowIndex;
                this.curRowObjects = new Object[dmdbPreparedStatement.curRowObjects.length];
                System.arraycopy(dmdbPreparedStatement.curRowObjects, 0, this.curRowObjects, 0, this.curRowObjects.length);
                this.paramObjectsList = this.paramObjectsList == null ? new ArrayList() : this.paramObjectsList;
                this.paramObjectsList.clear();
                this.paramObjectsList.addAll(dmdbPreparedStatement.paramObjectsList);
                this.curRowBindIndicator = new byte[dmdbPreparedStatement.curRowBindIndicator.length];
                System.arraycopy(dmdbPreparedStatement.curRowBindIndicator, 0, this.curRowBindIndicator, 0, this.curRowBindIndicator.length);
            }
        }
    }
}

