/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.java.a.a;
import dm.java.a.b;
import dm.java.a.c;
import dm.java.a.d;
import dm.java.a.e;
import dm.java.a.g;
import dm.jdbc.convert.DB2J;
import dm.jdbc.convert.J2DB;
import dm.jdbc.desc.ExecuteRetInfo;
import dm.jdbc.desc.NameBind;
import dm.jdbc.desc.Parameter;
import dm.jdbc.desc.StructDescriptor;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbSQLOutput;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.CaseUnsensitiveMap;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DmdbCallableStatement
extends DmdbPreparedStatement
implements CallableStatement {
    private boolean wasNull;
    private Map nameBindParamMap;

    public DmdbCallableStatement(DmdbConnection dmdbConnection, String string, int n2, int n3, int n4) {
        super(dmdbConnection, string, n2, n3, n4);
        this.nameBindParamMap = dmdbConnection.getIgnoreCase() ? new CaseUnsensitiveMap() : new LinkedHashMap();
    }

    @Override
    public void do_clearParameters() {
        super.do_clearParameters();
        if (this.nameBindParamMap != null) {
            for (NameBind nameBind : this.nameBindParamMap.values()) {
                nameBind.setInValue(null);
            }
        }
    }

    @Override
    protected void checkParameters() {
        if (this.checkParametersByName()) {
            Object[] objectArray = new Object[this.paramCount];
            Parameter[] parameterArray = new Parameter[this.paramCount];
            int n2 = 0;
            for (NameBind nameBind : this.nameBindParamMap.values()) {
                parameterArray[n2] = nameBind.getParameter();
                objectArray[n2] = nameBind.param.getIParam(nameBind) >= 0 ? this.curRowObjects[nameBind.param.getIParam(nameBind)] : nameBind.getInValue();
                ++n2;
            }
            this.execParams = parameterArray;
            this.curRowObjects = objectArray;
        } else {
            Object[] objectArray = new Object[this.paramCount];
            byte[] byArray = new byte[this.paramCount];
            int n3 = 0;
            Parameter[] parameterArray = this.params;
            int n4 = this.params.length;
            int n5 = 0;
            while (n5 < n4) {
                Parameter parameter = parameterArray[n5];
                NameBind nameBind = (NameBind)this.nameBindParamMap.get(parameter.name);
                if (nameBind != null) {
                    if (nameBind.param.getIParam(nameBind) >= 0) {
                        objectArray[n3] = this.curRowObjects[nameBind.param.getIParam(nameBind)];
                        int n6 = n3;
                        byArray[n6] = (byte)(byArray[n6] | 1);
                    } else if (nameBind.getParameter().ioType != 1) {
                        objectArray[n3] = nameBind.getInValue();
                        int n7 = n3;
                        byArray[n7] = (byte)(byArray[n7] | 1);
                    }
                } else {
                    objectArray[n3] = this.curRowObjects[n3];
                    byArray[n3] = this.curRowBindIndicator[n3];
                }
                ++n3;
                ++n5;
            }
            this.curRowObjects = objectArray;
            this.curRowBindIndicator = byArray;
            super.checkParameters();
        }
    }

    @Override
    protected void afterExecute() {
        super.afterExecute();
        this.preExec = false;
    }

    @Override
    public int[] do_executeBatch() {
        return super.do_executeBatch();
    }

    private boolean checkParametersByName() {
        if (this.nameBindParamMap.size() > this.paramCount) {
            Iterator iterator = this.nameBindParamMap.entrySet().iterator();
            while (iterator.hasNext()) {
                if (this.nameBindParamMap.size() == this.paramCount) break;
                Object object = iterator.next();
                if (!((NameBind)object.getValue()).getParameter().hasDefault) continue;
                this.nameBindParamMap.remove(object.getKey());
            }
        }
        boolean bl = true;
        for (Object object : this.nameBindParamMap.values()) {
            int[] nArray = this.findParamIndexList(((NameBind)object).getParameter().name);
            if (nArray.length != 0) continue;
            bl = false;
            break;
        }
        if (bl) {
            return false;
        }
        if (this.nameBindParamMap.size() != this.paramCount) {
            DBError.ECJDBC_UNBINDED_PARAMETER.throwException(new String[0]);
        }
        for (Object object : this.nameBindParamMap.values()) {
            if (((NameBind)object).getParameter().type != 120 || ((NameBind)object).getParameter().cursorStmt != null) continue;
            ((NameBind)object).getParameter().cursorStmt = this.connection.do_createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        }
        return true;
    }

    public int[] findParamIndexList(String string) {
        int[] nArray = new int[this.params.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.params.length) {
            if (this.connection.getIgnoreCase() ? StringUtil.equalsIgnoreCase(this.params[n3].name, string) : StringUtil.equals(this.params[n3].name, string)) {
                nArray[n2] = n3 + 1;
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return new int[0];
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void do_registerOutParameter(String string, int n2) {
        this.do_registerOutParameter(string, n2, -1);
    }

    public void do_registerOutParameter(String string, int n2, int n3) {
        NameBind nameBind;
        int[] nArray = this.findParamIndexList(string);
        if (!this.connection.supportNameBind && nArray.length == 0) {
            DBError.ECJDBC_INVALID_PARAMETER_NAME.throwException(new String[0]);
        }
        if ((nameBind = (NameBind)this.nameBindParamMap.get(string)) == null) {
            nameBind = new NameBind();
        }
        if (this.rowIndex == 0 && nArray.length > 0) {
            nameBind.setParameter(this.params[nArray[0] - 1]);
        } else if (nameBind.getParameter() == null && this.rowIndex > 0) {
            DBError.ECJDBC_BATCH_WITH_DIFF_COLUMN.throwException(new String[0]);
        }
        if (nameBind.getParameter() == null) {
            Parameter parameter = new Parameter();
            parameter.name = string;
            parameter.ioType = 1;
            parameter.typeFlag = 0;
            parameter.resetType(n2 == 120 ? 120 : DmdbType.j2dType(n2));
            parameter.outJType = n2;
            parameter.outScale = n3;
            nameBind.setParameter(parameter);
        } else {
            Parameter parameter = nameBind.getParameter();
            if (parameter.typeFlag == 0 && parameter.ioType == 0) {
                parameter.ioType = (byte)2;
            }
            if (parameter.typeFlag != 0 && parameter.type == 120) {
                parameter.outJType = 120;
                parameter.outScale = 0;
            } else {
                parameter.outJType = n2;
                parameter.outScale = n3;
            }
        }
        this.nameBindParamMap.put(string, nameBind);
    }

    public void do_registerOutParameter(String string, int n2, String string2) {
        this.do_registerOutParameter(string, n2);
        NameBind nameBind = (NameBind)this.nameBindParamMap.get(string);
        if (nameBind != null) {
            nameBind.getParameter().outObjectName = string2;
        }
    }

    public boolean do_wasNull() {
        return this.wasNull;
    }

    public int findOutValueIndex(String string) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.execParams.length) {
            if (this.connection.getIgnoreCase() ? StringUtil.equalsIgnoreCase(this.execParams[n3].name, string) : StringUtil.equals(this.execParams[n3].name, string)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            DBError.ECJDBC_INVALID_PARAMETER_NAME.throwException(new String[0]);
        }
        return n2 + 1;
    }

    public boolean do_getBoolean(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getBoolean(n2);
    }

    public byte do_getByte(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getByte(n2);
    }

    public short do_getShort(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getShort(n2);
    }

    public int do_getInt(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getInt(n2);
    }

    public long do_getLong(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getLong(n2);
    }

    public float do_getFloat(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getFloat(n2);
    }

    public double do_getDouble(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getDouble(n2);
    }

    public BigDecimal do_getBigDecimal(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getBigDecimal(n2);
    }

    public byte[] do_getBytes(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getBytes(n2);
    }

    public String do_getString(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getString(n2);
    }

    public Date do_getDate(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getDate(n2);
    }

    public Date do_getDate(String string, Calendar calendar) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getDate(n2, calendar);
    }

    public Time do_getTime(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getTime(n2);
    }

    public Time do_getTime(String string, Calendar calendar) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getTime(n2, calendar);
    }

    public Timestamp do_getTimestamp(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getTimestamp(n2);
    }

    public Timestamp do_getTimestamp(String string, Calendar calendar) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getTimestamp(n2, calendar);
    }

    public DmdbIntervalYM do_getINTERVALYM(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getINTERVALYM(n2);
    }

    public DmdbIntervalDT do_getINTERVALDT(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getINTERVALDT(n2);
    }

    public DmdbTimestamp do_getTIMESTAMP(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getTIMESTAMP(n2);
    }

    public DmdbBlob do_getBlob(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getBlob(n2);
    }

    public DmdbClob do_getClob(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getClob(n2);
    }

    public DmdbArray do_getArray(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getArray(n2);
    }

    public DmdbReader do_getCharacterStream(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getCharacterStream(n2);
    }

    public Object do_getObject(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getObject(n2);
    }

    public Object do_getObject(String string, Map map) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getObject(n2, map);
    }

    public ResultSet do_getCursor(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getCursor(n2);
    }

    public URL do_getURL(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getURL(n2);
    }

    public Ref do_getRef(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getRef(n2);
    }

    public String do_getNString(String string) {
        return this.do_getString(string);
    }

    public DmdbReader do_getNCharacterStream(String string) {
        return this.do_getCharacterStream(string);
    }

    public DmdbRowId do_getRowId(String string) {
        return this.do_getRowId(this.findOutValueIndex(string));
    }

    public NClob do_getNClob(String string) {
        return (NClob)((Object)this.do_getClob(string));
    }

    public SQLXML do_getSQLXML(String string) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getSQLXML(n2);
    }

    public Object do_getObject(String string, Class clazz) {
        int n2 = this.findOutValueIndex(string);
        return this.do_getObject(n2, clazz);
    }

    @Override
    protected boolean prepareBindInParam(int n2, int n3, boolean bl) {
        boolean bl2 = super.prepareBindInParam(n2, n3, bl);
        if (bl2) {
            NameBind nameBind = (NameBind)this.nameBindParamMap.get(this.params[n2 - 1].name);
            if (nameBind == null) {
                nameBind = new NameBind();
                this.nameBindParamMap.put(this.params[n2 - 1].name, nameBind);
            }
            nameBind.setParameter(this.params[n2 - 1]);
            nameBind.setIParam(n2 - 1);
        }
        return bl2;
    }

    private NameBind prepareBindInParam(String string, int n2, boolean bl) {
        NameBind nameBind;
        int[] nArray = this.findParamIndexList(string);
        if (!this.connection.supportNameBind && nArray.length == 0) {
            DBError.ECJDBC_INVALID_PARAMETER_NAME.throwException(new String[0]);
        }
        if ((nameBind = (NameBind)this.nameBindParamMap.get(string)) == null) {
            nameBind = new NameBind();
        }
        if (this.rowIndex == 0 && nArray.length > 0) {
            nameBind.setParameter(this.params[nArray[0] - 1]);
            nameBind.setIParam(-1);
        } else if (nameBind.getParameter() == null && this.rowIndex > 0) {
            DBError.ECJDBC_BATCH_WITH_DIFF_COLUMN.throwException(new String[0]);
        }
        if (nameBind.getParameter() == null) {
            Parameter parameter = new Parameter();
            parameter.name = string;
            parameter.ioType = 0;
            parameter.typeFlag = 0;
            parameter.resetType(n2);
            nameBind.setParameter(parameter);
            nameBind.setIParam(-1);
        } else {
            Parameter parameter = nameBind.getParameter();
            if (parameter.typeFlag == 0 && parameter.ioType == 1) {
                parameter.ioType = (byte)2;
            }
            if (parameter.type == 54) {
                parameter.resetType(n2);
            } else if (!bl && this.rowIndex == 0 && parameter.typeFlag != 1) {
                parameter.resetType(n2);
            }
        }
        this.nameBindParamMap.put(string, nameBind);
        return nameBind;
    }

    public void do_setNull(String string, int n2) {
        NameBind nameBind = this.prepareBindInParam(string, DmdbType.j2dType(n2), true);
        nameBind.setInValue(null);
    }

    public void do_setNull(String string, int n2, String string2) {
        this.do_setNull(string, n2);
    }

    public void do_setBoolean(String string, boolean bl) {
        NameBind nameBind = this.prepareBindInParam(string, 5, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromBoolean(bl, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setByte(String string, byte by) {
        NameBind nameBind = this.prepareBindInParam(string, 5, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromLong(by, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setShort(String string, short s2) {
        NameBind nameBind = this.prepareBindInParam(string, 6, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromLong(s2, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setInt(String string, int n2) {
        NameBind nameBind = this.prepareBindInParam(string, 7, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromLong(n2, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setLong(String string, long l2) {
        NameBind nameBind = this.prepareBindInParam(string, 8, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromLong(l2, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setFloat(String string, float f2) {
        NameBind nameBind = this.prepareBindInParam(string, 10, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromFloat(f2, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setDouble(String string, double d2) {
        NameBind nameBind = this.prepareBindInParam(string, 11, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromDouble(d2, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setBigDecimal(String string, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.do_setNull(string, 2);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 2, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromBigDecimal(bigDecimal, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setString(String string, String string2) {
        if (string2 == null) {
            this.do_setNull(string, 2);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 2, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromString(string2, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(object);
    }

    public void do_setBytes(String string, byte[] byArray) {
        if (byArray == null) {
            this.do_setNull(string, 18);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 18, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromBytes(byArray, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(object);
    }

    public void do_setDate(String string, Date date) {
        this.do_setDate(string, date, null);
    }

    public void do_setDate(String string, Date date, Calendar calendar) {
        if (date == null) {
            this.do_setNull(string, 14);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 14, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromDate(date, nameBind.getParameter(), this.connection, calendar);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setTime(String string, Time time) {
        this.do_setTime(string, time, null);
    }

    public void do_setTime(String string, Time time, Calendar calendar) {
        if (time == null) {
            this.do_setNull(string, 15);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 15, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromDate(time, nameBind.getParameter(), this.connection, calendar);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setTimestamp(String string, Timestamp timestamp) {
        this.do_setTimestamp(string, timestamp, null);
    }

    public void do_setTimestamp(String string, Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            this.do_setNull(string, 16);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 16, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromDate(timestamp, nameBind.getParameter(), this.connection, calendar);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setTIMESTAMP(String string, DmdbTimestamp dmdbTimestamp) {
        if (dmdbTimestamp == null) {
            this.do_setNull(string, 16);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 16, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromDmdbTimestamp(dmdbTimestamp, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setINTERVALDT(String string, DmdbIntervalDT dmdbIntervalDT) {
        if (dmdbIntervalDT == null) {
            this.do_setNull(string, 21);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 21, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromDmdbIntervalDT(dmdbIntervalDT, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setINTERVALYM(String string, DmdbIntervalYM dmdbIntervalYM) {
        if (dmdbIntervalYM == null) {
            this.do_setNull(string, 20);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 20, false);
        byte[] byArray = null;
        if (nameBind.getParameter().ioType != 1) {
            byArray = J2DB.fromDmdbIntervalYM(dmdbIntervalYM, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(byArray);
    }

    public void do_setAsciiStream(String string, InputStream inputStream) {
        this.do_setAsciiStream(string, inputStream, -1);
    }

    public void do_setAsciiStream(String string, InputStream inputStream, int n2) {
        this.do_setAsciiStream(string, inputStream, (long)n2);
    }

    public void do_setAsciiStream(String string, InputStream inputStream, long l2) {
        if (inputStream == null) {
            this.do_setNull(string, 12);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 12, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromInputStream(inputStream, nameBind.getParameter(), this.connection, l2);
        }
        nameBind.setInValue(object);
    }

    public void do_setBinaryStream(String string, InputStream inputStream) {
        this.do_setBinaryStream(string, inputStream, -1);
    }

    public void do_setBinaryStream(String string, InputStream inputStream, int n2) {
        this.do_setBinaryStream(string, inputStream, (long)n2);
    }

    public void do_setBinaryStream(String string, InputStream inputStream, long l2) {
        if (inputStream == null) {
            this.do_setNull(string, 12);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 12, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromInputStream(inputStream, nameBind.getParameter(), this.connection, l2);
        }
        nameBind.setInValue(object);
    }

    public void do_setCharacterStream(String string, Reader reader) {
        this.do_setCharacterStream(string, reader, -1);
    }

    public void do_setCharacterStream(String string, Reader reader, int n2) {
        this.do_setCharacterStream(string, reader, (long)n2);
    }

    public void do_setCharacterStream(String string, Reader reader, long l2) {
        if (reader == null) {
            this.do_setNull(string, 19);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 19, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromReader(reader, nameBind.getParameter(), this.connection, l2);
        }
        nameBind.setInValue(object);
    }

    public void do_setBlob(String string, Blob blob) {
        if (blob == null) {
            this.do_setNull(string, 12);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 12, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = blob instanceof DmdbBlob ? J2DB.fromBlob((DmdbBlob)blob, nameBind.getParameter(), this.connection) : J2DB.fromInputStream(blob.getBinaryStream(), nameBind.getParameter(), this.connection, -1L);
        }
        nameBind.setInValue(object);
    }

    public void do_setBlob(String string, InputStream inputStream) {
        this.do_setBlob(string, inputStream, -1L);
    }

    public void do_setBlob(String string, InputStream inputStream, long l2) {
        if (inputStream == null) {
            this.do_setNull(string, 12);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 12, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromInputStream(inputStream, nameBind.getParameter(), this.connection, l2);
        }
        nameBind.setInValue(object);
    }

    public void do_setClob(String string, Clob clob) {
        if (clob == null) {
            this.do_setNull(string, 19);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 19, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = clob instanceof DmdbClob ? J2DB.fromClob((DmdbClob)clob, nameBind.getParameter(), this.connection) : J2DB.fromReader(clob.getCharacterStream(), nameBind.getParameter(), this.connection, -1L);
        }
        nameBind.setInValue(object);
    }

    public void do_setClob(String string, Reader reader) {
        this.do_setClob(string, reader, -1L);
    }

    public void do_setClob(String string, Reader reader, long l2) {
        if (reader == null) {
            this.do_setNull(string, 19);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 19, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromReader(reader, nameBind.getParameter(), this.connection, l2);
        }
        nameBind.setInValue(object);
    }

    public void do_setObject(String string, Object object) {
        this.do_setObject(string, object, 0, -1);
    }

    public void do_setObject(String string, Object object, int n2) {
        this.do_setObject(string, object, n2, -1);
    }

    public void do_setObject(String string, Object object, int n2, int n3) {
        if (n3 != -1 && (n2 == 3 || n2 == 2) && DmdbType.canCastToDecimal(object)) {
            String string2 = "";
            string2 = object instanceof Boolean ? ((Boolean)object != false ? "1" : "0") : String.valueOf(object);
            BigDecimal bigDecimal = new BigDecimal(string2);
            object = bigDecimal.setScale(n3, 4);
        }
        if (object == null) {
            this.do_setNull(string, n2);
        } else if (object instanceof Boolean) {
            this.do_setBoolean(string, (boolean)((Boolean)object));
        } else if (object instanceof Byte) {
            this.do_setByte(string, (byte)((Byte)object));
        } else if (object instanceof Short) {
            this.do_setShort(string, (short)((Short)object));
        } else if (object instanceof Integer) {
            this.do_setInt(string, (int)((Integer)object));
        } else if (object instanceof Long) {
            this.do_setLong(string, (long)((Long)object));
        } else if (object instanceof Float) {
            this.do_setFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.do_setDouble(string, (double)((Double)object));
        } else if (object instanceof BigDecimal) {
            this.do_setBigDecimal(string, (BigDecimal)object);
        } else if (object instanceof byte[]) {
            this.do_setBytes(string, (byte[])object);
        } else if (object instanceof String) {
            this.do_setString(string, (String)object);
        } else if (object instanceof Clob) {
            this.do_setClob(string, (Clob)object);
        } else if (object instanceof Blob) {
            this.do_setBlob(string, (Blob)object);
        } else if (object instanceof InputStream) {
            this.do_setBinaryStream(string, (InputStream)object, n3);
        } else if (object instanceof Reader) {
            this.do_setCharacterStream(string, (Reader)object, n3);
        } else if (object instanceof Array) {
            this.do_setArray(string, (Array)object);
        } else if (object instanceof BigInteger) {
            this.do_setBigDecimal(string, new BigDecimal((BigInteger)object));
        } else if (object instanceof Character) {
            this.do_setString(string, object.toString());
        } else if (object instanceof DmdbBFile) {
            this.do_setString(string, ((DmdbBFile)object).getFileName());
        } else if (object instanceof Struct) {
            this.do_setStruct(string, (Struct)object);
        } else if (object instanceof SQLData) {
            this.do_setSQLData(string, (SQLData)object);
        } else if (object instanceof RowId) {
            this.do_setRowId(string, (RowId)object);
        } else if (object instanceof DmdbTimestamp) {
            this.do_setTIMESTAMP(string, (DmdbTimestamp)object);
        } else if (object instanceof DmdbIntervalDT) {
            this.do_setINTERVALDT(string, (DmdbIntervalDT)object);
        } else if (object instanceof DmdbIntervalYM) {
            this.do_setINTERVALYM(string, (DmdbIntervalYM)object);
        } else if (object instanceof Date) {
            this.do_setDate(string, (Date)object);
        } else if (object instanceof Time) {
            this.do_setTime(string, (Time)object);
        } else if (object instanceof Timestamp) {
            this.do_setTimestamp(string, (Timestamp)object);
        } else if (object instanceof java.util.Date) {
            this.do_setTIMESTAMP(string, DmdbTimestamp.valueOf((java.util.Date)object));
        } else if (object instanceof a) {
            this.do_setTIMESTAMP(string, DmdbTimestamp.valueOf((a)object));
        } else if (object instanceof c) {
            this.do_setTIMESTAMP(string, DmdbTimestamp.valueOf((c)object));
        } else if (object instanceof b) {
            this.do_setTIMESTAMP(string, DmdbTimestamp.valueOf((b)object));
        } else if (object instanceof g) {
            this.do_setTIMESTAMP(string, DmdbTimestamp.valueOf((g)object));
        } else if (object instanceof d) {
            this.do_setTIMESTAMP(string, DmdbTimestamp.valueOf((d)object));
        } else if (object instanceof e) {
            this.do_setTIMESTAMP(string, DmdbTimestamp.valueOf((e)object));
        } else {
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwException(new String[0]);
        }
    }

    private void do_setSQLData(String string, SQLData sQLData) {
        String string2 = sQLData.getSQLTypeName();
        if (this.connection.do_getTypeMap().containsKey(string2) && sQLData.getClass() == this.connection.do_getTypeMap().get(string2)) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string2, this.connection);
            DmdbSQLOutput dmdbSQLOutput = new DmdbSQLOutput();
            sQLData.writeSQL(dmdbSQLOutput);
            DmdbStruct dmdbStruct = new DmdbStruct(structDescriptor, this.connection, dmdbSQLOutput.getAttribs());
            this.do_setStruct(string, (Struct)dmdbStruct);
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
    }

    private void do_setStruct(String string, Struct struct) {
        if (struct == null) {
            this.do_setNull(string, 119);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 119, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromStruct((DmdbStruct)struct, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(object);
    }

    private void do_setArray(String string, Array array) {
        if (array == null) {
            this.do_setNull(string, 117);
            return;
        }
        NameBind nameBind = this.prepareBindInParam(string, 117, false);
        Object object = null;
        if (nameBind.getParameter().ioType != 1) {
            object = J2DB.fromArray((DmdbArray)array, nameBind.getParameter(), this.connection);
        }
        nameBind.setInValue(object);
    }

    public void do_setURL(String string, URL uRL) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setNString(String string, String string2) {
        this.do_setString(string, string2);
    }

    public void do_setNCharacterStream(String string, Reader reader, long l2) {
        this.do_setCharacterStream(string, reader, l2);
    }

    public void do_setNClob(String string, Reader reader, long l2) {
        this.do_setClob(string, reader, l2);
    }

    public void do_setNCharacterStream(String string, Reader reader) {
        this.do_setCharacterStream(string, reader);
    }

    public void do_setNClob(String string, Reader reader) {
        this.do_setClob(string, reader);
    }

    public void do_setRowId(String string, RowId rowId) {
        if (rowId == null) {
            this.do_setNull(string, 8);
        } else {
            long l2 = ((DmdbRowId)rowId).getValue();
            this.do_setLong(string, l2);
        }
    }

    public void do_setNClob(String string, NClob nClob) {
        this.do_setClob(string, (Clob)nClob);
    }

    public void do_setSQLXML(String string, SQLXML sQLXML) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setObject(String string, Object object, dm.java.sql.a a2, int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_setObject(String string, Object object, dm.java.sql.a a2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_registerOutParameter(String string, dm.java.sql.a a2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_registerOutParameter(String string, dm.java.sql.a a2, int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_registerOutParameter(String string, dm.java.sql.a a2, String string2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_registerOutParameter(int n2, int n3) {
        this.do_registerOutParameter(n2, n3, -1);
    }

    public void do_registerOutParameter(int n2, int n3, int n4) {
        if (n2 < 1 || n2 > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwException(new String[0]);
        }
        int n5 = n2 - 1;
        this.do_registerOutParameter(this.params[n5].name, n3, n4);
        int n6 = n5;
        this.curRowBindIndicator[n6] = (byte)(this.curRowBindIndicator[n6] | 0x10);
    }

    public void do_registerOutParameter(int n2, int n3, String string) {
        this.do_registerOutParameter(n2, n3);
        this.params[n2 - 1].outObjectName = string;
    }

    public void do_registerOutParameter(int n2, dm.java.sql.a a2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_registerOutParameter(int n2, dm.java.sql.a a2, int n3) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    public void do_registerOutParameter(int n2, dm.java.sql.a a2, String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
    }

    protected void checkIsOutParam(int n2) {
        if (n2 < 1 || n2 > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwException(new String[0]);
        }
        if (this.execParams[n2 - 1].ioType == 0) {
            DBError.ECJDBC_NOT_OUT_PARAM.throwException(new String[0]);
        }
    }

    protected byte[] getOutParamData(int n2) {
        this.checkIsOutParam(n2);
        if (this.execInfo.outParamDatas == null || this.execInfo.outParamDatas.size() == 0 || ((byte[][])this.execInfo.outParamDatas.get(0)).length < n2) {
            this.wasNull = true;
            return null;
        }
        byte[] byArray = ((byte[][])this.execInfo.outParamDatas.get(0))[n2 - 1];
        this.wasNull = byArray == null;
        return byArray;
    }

    public boolean do_getBoolean(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null && DB2J.toBoolean(byArray, this.execParams[n2 - 1], this.connection);
    }

    public byte do_getByte(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toByte(byArray, this.execParams[n2 - 1], this.connection) : (byte)0;
    }

    public short do_getShort(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toShort(byArray, this.execParams[n2 - 1], this.connection) : (short)0;
    }

    public int do_getInt(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toInt(byArray, this.execParams[n2 - 1], this.connection) : 0;
    }

    public long do_getLong(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toLong(byArray, this.execParams[n2 - 1], this.connection) : 0L;
    }

    public float do_getFloat(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toFloat(byArray, this.execParams[n2 - 1], this.connection) : 0.0f;
    }

    public double do_getDouble(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toDouble(byArray, this.execParams[n2 - 1], this.connection) : 0.0;
    }

    public BigDecimal do_getBigDecimal(int n2) {
        return this.do_getBigDecimal(n2, this.execParams[n2 - 1].outScale);
    }

    public BigDecimal do_getBigDecimal(int n2, int n3) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toBigDecimal(byArray, this.execParams[n2 - 1], this.connection, n3) : null;
    }

    public byte[] do_getBytes(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toBytes(byArray, this.execParams[n2 - 1], this.connection) : null;
    }

    public String do_getString(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toString(byArray, this.execParams[n2 - 1], this.connection) : null;
    }

    public Date do_getDate(int n2) {
        return this.do_getDate(n2, null);
    }

    public Date do_getDate(int n2, Calendar calendar) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toDate(byArray, this.execParams[n2 - 1], this.connection, calendar) : null;
    }

    public Time do_getTime(int n2) {
        return this.do_getTime(n2, null);
    }

    public Time do_getTime(int n2, Calendar calendar) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toTime(byArray, this.execParams[n2 - 1], this.connection, calendar) : null;
    }

    public Timestamp do_getTimestamp(int n2) {
        return this.do_getTimestamp(n2, null);
    }

    public Timestamp do_getTimestamp(int n2, Calendar calendar) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toTimestamp(byArray, this.execParams[n2 - 1], this.connection, calendar) : null;
    }

    public DmdbBlob do_getBlob(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toBlob(byArray, this.execParams[n2 - 1], this.connection) : null;
    }

    public DmdbClob do_getClob(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toClob(byArray, this.execParams[n2 - 1], this.connection) : null;
    }

    public DmdbArray do_getArray(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toArray(byArray, this.execParams[n2 - 1], this.connection) : null;
    }

    public DmdbReader do_getCharacterStream(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toCharacterStream(byArray, this.execParams[n2 - 1], this.connection) : null;
    }

    public Object do_getObject(int n2) {
        return this.do_getObject(n2, this.connection.do_getTypeMap());
    }

    public Object do_getObject(int n2, Map map) {
        byte[] byArray;
        this.checkIsOutParam(n2);
        Parameter parameter = this.execParams[n2 - 1];
        Object object = null;
        boolean bl = true;
        if (parameter.outJType != Integer.MIN_VALUE) {
            bl = false;
            switch (parameter.outJType) {
                case 120: {
                    object = this.do_getCursor(n2);
                    break;
                }
                case -7: 
                case 16: {
                    object = this.do_getBoolean(n2);
                    break;
                }
                case -6: {
                    object = this.do_getByte(n2);
                    break;
                }
                case 5: {
                    object = this.do_getShort(n2);
                    break;
                }
                case 4: {
                    object = this.do_getInt(n2);
                    break;
                }
                case -5: {
                    object = this.do_getLong(n2);
                    break;
                }
                case 2: 
                case 3: {
                    object = this.do_getBigDecimal(n2);
                    break;
                }
                case 6: 
                case 7: {
                    object = Float.valueOf(this.do_getFloat(n2));
                    break;
                }
                case 8: {
                    object = this.do_getDouble(n2);
                    break;
                }
                case 91: {
                    object = this.do_getDate(n2);
                    break;
                }
                case 92: {
                    object = this.do_getTime(n2);
                    break;
                }
                case 93: {
                    object = this.do_getTimestamp(n2);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    object = this.do_getBytes(n2);
                    break;
                }
                case 2004: {
                    if (DmdbType.isComplexType(parameter.type, parameter.scale)) {
                        byArray = this.getOutParamData(n2);
                        object = byArray != null ? DB2J.toComplexType(byArray, parameter, this.connection, map) : null;
                        break;
                    }
                    if (StringUtil.equalsIgnoreCase(parameter.typeName, "LONGVARBINARY")) {
                        object = this.do_getBytes(n2);
                        break;
                    }
                    object = this.do_getBlob(n2);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    object = this.do_getString(n2);
                    if (object == null || !DmdbType.isBFile(parameter.type, parameter.prec, parameter.scale)) break;
                    object = new DmdbBFile((String)object);
                    break;
                }
                case 2005: {
                    object = StringUtil.equalsIgnoreCase(parameter.typeName, "LONGVARCHAR") ? this.do_getString(n2) : this.do_getClob(n2);
                    break;
                }
                case 2002: 
                case 2003: {
                    byArray = this.getOutParamData(n2);
                    object = byArray != null ? DB2J.toComplexType(byArray, parameter, this.connection, map) : null;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        if (!bl) {
            return this.wasNull ? null : object;
        }
        if (this.connection.compatibleOracle() && DmdbType.isNumeric(parameter.type)) {
            return this.do_getBigDecimal(n2);
        }
        switch (parameter.type) {
            case 3: 
            case 13: {
                object = this.do_getBoolean(n2);
                break;
            }
            case 5: {
                object = this.do_getByte(n2);
                break;
            }
            case 6: {
                object = this.do_getShort(n2);
                break;
            }
            case 7: {
                object = this.do_getInt(n2);
                break;
            }
            case 8: {
                object = this.do_getLong(n2);
                break;
            }
            case 9: {
                object = this.do_getBigDecimal(n2);
                break;
            }
            case 10: {
                object = Float.valueOf(this.do_getFloat(n2));
                break;
            }
            case 11: {
                object = this.do_getDouble(n2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                object = this.do_getTIMESTAMP(n2);
                break;
            }
            case 17: 
            case 18: {
                object = this.do_getBytes(n2);
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(parameter.type, parameter.scale)) {
                    byArray = this.getOutParamData(n2);
                    object = byArray != null ? DB2J.toComplexType(byArray, parameter, this.connection, map) : null;
                    break;
                }
                if (StringUtil.equalsIgnoreCase(parameter.typeName, "LONGVARBINARY")) {
                    object = this.do_getBytes(n2);
                    break;
                }
                object = this.do_getBlob(n2);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                object = this.do_getString(n2);
                if (object == null || !DmdbType.isBFile(parameter.type, parameter.prec, parameter.scale)) break;
                object = new DmdbBFile((String)object);
                break;
            }
            case 19: {
                object = StringUtil.equalsIgnoreCase(parameter.typeName, "LONGVARCHAR") ? this.do_getString(n2) : this.do_getClob(n2);
                break;
            }
            case 20: {
                object = this.do_getINTERVALYM(n2);
                break;
            }
            case 21: {
                object = this.do_getINTERVALDT(n2);
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                byArray = this.getOutParamData(n2);
                object = byArray != null ? DB2J.toComplexType(byArray, parameter, this.connection, map) : null;
                break;
            }
            case 120: {
                object = this.do_getCursor(n2);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return this.wasNull ? null : object;
    }

    public URL do_getURL(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public Ref do_getRef(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public ResultSet do_getCursor(int n2) {
        this.checkIsOutParam(n2);
        if (this.execParams[n2 - 1].type != 120) {
            DBError.ECJDBC_PTYPE_NOT_CURSOR.throwException(new String[0]);
        }
        DmdbStatement dmdbStatement = this.execParams[n2 - 1].cursorStmt;
        dmdbStatement.clearResultSets();
        ExecuteRetInfo executeRetInfo = this.connection.dbAccess.a(dmdbStatement, (short)1);
        if (executeRetInfo.hasResultSet) {
            this.wasNull = false;
            dmdbStatement.curResultSet = new DmdbResultSet(1, dmdbStatement, executeRetInfo);
            return dmdbStatement.curResultSet;
        }
        this.wasNull = true;
        return null;
    }

    public DmdbIntervalYM do_getINTERVALYM(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? new DmdbIntervalYM(byArray) : null;
    }

    public DmdbIntervalDT do_getINTERVALDT(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? new DmdbIntervalDT(byArray) : null;
    }

    public DmdbTimestamp do_getTIMESTAMP(int n2) {
        byte[] byArray = this.getOutParamData(n2);
        return byArray != null ? DB2J.toDmdbTimestamp(byArray, this.execParams[n2 - 1], this.connection) : null;
    }

    public String do_getNString(int n2) {
        return this.do_getString(n2);
    }

    public DmdbReader do_getNCharacterStream(int n2) {
        return this.do_getCharacterStream(n2);
    }

    public DmdbRowId do_getRowId(int n2) {
        long l2 = this.do_getLong(n2);
        String string = this.execParams[n2 - 1].schemaName;
        String string2 = this.execParams[n2 - 1].tableName;
        return new DmdbRowId(l2, string, string2);
    }

    public NClob do_getNClob(int n2) {
        return (NClob)((Object)this.do_getClob(n2));
    }

    public SQLXML do_getSQLXML(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public Object do_getObject(int n2, Class clazz) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public void registerOutParameter(int n2, int n3) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(n2, n3);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, n2, n3);
        }
    }

    @Override
    public void registerOutParameter(int n2, int n3, int n4) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(n2, n3, n4);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, n2, n3, n4);
        }
    }

    @Override
    public boolean wasNull() {
        if (this.filterChain == null) {
            return this.do_wasNull();
        }
        return this.filterChain.reset().CallableStatement_wasNull(this);
    }

    @Override
    public String getString(int n2) {
        if (this.filterChain == null) {
            return this.do_getString(n2);
        }
        return this.filterChain.reset().CallableStatement_getString(this, n2);
    }

    @Override
    public boolean getBoolean(int n2) {
        if (this.filterChain == null) {
            return this.do_getBoolean(n2);
        }
        return this.filterChain.reset().CallableStatement_getBoolean(this, n2);
    }

    @Override
    public byte getByte(int n2) {
        if (this.filterChain == null) {
            return this.do_getByte(n2);
        }
        return this.filterChain.reset().CallableStatement_getByte(this, n2);
    }

    @Override
    public short getShort(int n2) {
        if (this.filterChain == null) {
            return this.do_getShort(n2);
        }
        return this.filterChain.reset().CallableStatement_getShort(this, n2);
    }

    @Override
    public int getInt(int n2) {
        if (this.filterChain == null) {
            return this.do_getInt(n2);
        }
        return this.filterChain.reset().CallableStatement_getInt(this, n2);
    }

    @Override
    public long getLong(int n2) {
        if (this.filterChain == null) {
            return this.do_getLong(n2);
        }
        return this.filterChain.reset().CallableStatement_getLong(this, n2);
    }

    @Override
    public float getFloat(int n2) {
        if (this.filterChain == null) {
            return this.do_getFloat(n2);
        }
        return this.filterChain.reset().CallableStatement_getFloat(this, n2);
    }

    @Override
    public double getDouble(int n2) {
        if (this.filterChain == null) {
            return this.do_getDouble(n2);
        }
        return this.filterChain.reset().CallableStatement_getDouble(this, n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) {
        if (this.filterChain == null) {
            return this.do_getBigDecimal(n2, n3);
        }
        return this.filterChain.reset().CallableStatement_getBigDecimal(this, n2, n3);
    }

    @Override
    public byte[] getBytes(int n2) {
        if (this.filterChain == null) {
            return this.do_getBytes(n2);
        }
        return this.filterChain.reset().CallableStatement_getBytes(this, n2);
    }

    @Override
    public Date getDate(int n2) {
        if (this.filterChain == null) {
            return this.do_getDate(n2);
        }
        return this.filterChain.reset().CallableStatement_getDate(this, n2);
    }

    @Override
    public Time getTime(int n2) {
        if (this.filterChain == null) {
            return this.do_getTime(n2);
        }
        return this.filterChain.reset().CallableStatement_getTime(this, n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) {
        if (this.filterChain == null) {
            return this.do_getTimestamp(n2);
        }
        return this.filterChain.reset().CallableStatement_getTimestamp(this, n2);
    }

    @Override
    public Object getObject(int n2) {
        if (this.filterChain == null) {
            return this.do_getObject(n2);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) {
        if (this.filterChain == null) {
            return this.do_getBigDecimal(n2);
        }
        return this.filterChain.reset().CallableStatement_getBigDecimal(this, n2);
    }

    public Object getObject(int n2, Map map) {
        if (this.filterChain == null) {
            return this.do_getObject(n2, map);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, n2, map);
    }

    @Override
    public Ref getRef(int n2) {
        if (this.filterChain == null) {
            return this.do_getRef(n2);
        }
        return this.filterChain.reset().CallableStatement_getRef(this, n2);
    }

    @Override
    public Blob getBlob(int n2) {
        if (this.filterChain == null) {
            return this.do_getBlob(n2);
        }
        return this.filterChain.reset().CallableStatement_getBlob(this, n2);
    }

    @Override
    public Clob getClob(int n2) {
        if (this.filterChain == null) {
            return this.do_getClob(n2);
        }
        return this.filterChain.reset().CallableStatement_getClob(this, n2);
    }

    @Override
    public Array getArray(int n2) {
        if (this.filterChain == null) {
            return this.do_getArray(n2);
        }
        return this.filterChain.reset().CallableStatement_getArray(this, n2);
    }

    @Override
    public Date getDate(int n2, Calendar calendar) {
        if (this.filterChain == null) {
            return this.do_getDate(n2, calendar);
        }
        return this.filterChain.reset().CallableStatement_getDate(this, n2, calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) {
        if (this.filterChain == null) {
            return this.do_getTime(n2, calendar);
        }
        return this.filterChain.reset().CallableStatement_getTime(this, n2, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) {
        if (this.filterChain == null) {
            return this.do_getTimestamp(n2, calendar);
        }
        return this.filterChain.reset().CallableStatement_getTimestamp(this, n2, calendar);
    }

    @Override
    public void registerOutParameter(int n2, int n3, String string) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(n2, n3, string);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, n2, n3, string);
        }
    }

    @Override
    public void registerOutParameter(String string, int n2) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(string, n2);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, string, n2);
        }
    }

    @Override
    public void registerOutParameter(String string, int n2, int n3) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(string, n2, n3);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, string, n2, n3);
        }
    }

    @Override
    public void registerOutParameter(String string, int n2, String string2) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(string, n2, string2);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, string, n2, string2);
        }
    }

    @Override
    public URL getURL(int n2) {
        if (this.filterChain == null) {
            return this.do_getURL(n2);
        }
        return this.filterChain.reset().CallableStatement_getURL(this, n2);
    }

    @Override
    public void setURL(String string, URL uRL) {
        if (this.filterChain == null) {
            this.do_setURL(string, uRL);
        } else {
            this.filterChain.reset().CallableStatement_setURL(this, string, uRL);
        }
    }

    @Override
    public void setNull(String string, int n2) {
        if (this.filterChain == null) {
            this.do_setNull(string, n2);
        } else {
            this.filterChain.reset().CallableStatement_setNull(this, string, n2);
        }
    }

    @Override
    public void setBoolean(String string, boolean bl) {
        if (this.filterChain == null) {
            this.do_setBoolean(string, bl);
        } else {
            this.filterChain.reset().CallableStatement_setBoolean(this, string, bl);
        }
    }

    @Override
    public void setByte(String string, byte by) {
        if (this.filterChain == null) {
            this.do_setByte(string, by);
        } else {
            this.filterChain.reset().CallableStatement_setByte(this, string, by);
        }
    }

    @Override
    public void setShort(String string, short s2) {
        if (this.filterChain == null) {
            this.do_setShort(string, s2);
        } else {
            this.filterChain.reset().CallableStatement_setShort(this, string, s2);
        }
    }

    @Override
    public void setInt(String string, int n2) {
        if (this.filterChain == null) {
            this.do_setInt(string, n2);
        } else {
            this.filterChain.reset().CallableStatement_setInt(this, string, n2);
        }
    }

    @Override
    public void setLong(String string, long l2) {
        if (this.filterChain == null) {
            this.do_setLong(string, l2);
        } else {
            this.filterChain.reset().CallableStatement_setLong(this, string, l2);
        }
    }

    @Override
    public void setFloat(String string, float f2) {
        if (this.filterChain == null) {
            this.do_setFloat(string, f2);
        } else {
            this.filterChain.reset().CallableStatement_setFloat(this, string, f2);
        }
    }

    @Override
    public void setDouble(String string, double d2) {
        if (this.filterChain == null) {
            this.do_setDouble(string, d2);
        } else {
            this.filterChain.reset().CallableStatement_setDouble(this, string, d2);
        }
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) {
        if (this.filterChain == null) {
            this.do_setBigDecimal(string, bigDecimal);
        } else {
            this.filterChain.reset().CallableStatement_setBigDecimal(this, string, bigDecimal);
        }
    }

    @Override
    public void setString(String string, String string2) {
        if (this.filterChain == null) {
            this.do_setString(string, string2);
        } else {
            this.filterChain.reset().CallableStatement_setString(this, string, string2);
        }
    }

    @Override
    public void setBytes(String string, byte[] byArray) {
        if (this.filterChain == null) {
            this.do_setBytes(string, byArray);
        } else {
            this.filterChain.reset().CallableStatement_setBytes(this, string, byArray);
        }
    }

    @Override
    public void setDate(String string, Date date) {
        if (this.filterChain == null) {
            this.do_setDate(string, date);
        } else {
            this.filterChain.reset().CallableStatement_setDate(this, string, date);
        }
    }

    @Override
    public void setTime(String string, Time time) {
        if (this.filterChain == null) {
            this.do_setTime(string, time);
        } else {
            this.filterChain.reset().CallableStatement_setTime(this, string, time);
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) {
        if (this.filterChain == null) {
            this.do_setTimestamp(string, timestamp);
        } else {
            this.filterChain.reset().CallableStatement_setTimestamp(this, string, timestamp);
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(string, inputStream, n2);
        } else {
            this.filterChain.reset().CallableStatement_setAsciiStream(this, string, inputStream, n2);
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(string, inputStream, n2);
        } else {
            this.filterChain.reset().CallableStatement_setBinaryStream(this, string, inputStream, n2);
        }
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) {
        if (this.filterChain == null) {
            this.do_setObject(string, object, n2, n3);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, string, object, n2, n3);
        }
    }

    @Override
    public void setObject(String string, Object object, int n2) {
        if (this.filterChain == null) {
            this.do_setObject(string, object, n2);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, string, object, n2);
        }
    }

    @Override
    public void setObject(String string, Object object) {
        if (this.filterChain == null) {
            this.do_setObject(string, object);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, string, object);
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(string, reader, n2);
        } else {
            this.filterChain.reset().CallableStatement_setCharacterStream(this, string, reader, n2);
        }
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setDate(string, date, calendar);
        } else {
            this.filterChain.reset().CallableStatement_setDate(this, string, date, calendar);
        }
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setTime(string, time, calendar);
        } else {
            this.filterChain.reset().CallableStatement_setTime(this, string, time, calendar);
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) {
        if (this.filterChain == null) {
            this.do_setTimestamp(string, timestamp, calendar);
        } else {
            this.filterChain.reset().CallableStatement_setTimestamp(this, string, timestamp, calendar);
        }
    }

    @Override
    public void setNull(String string, int n2, String string2) {
        if (this.filterChain == null) {
            this.do_setNull(string, n2, string2);
        } else {
            this.filterChain.reset().CallableStatement_setNull(this, string, n2, string2);
        }
    }

    @Override
    public String getString(String string) {
        if (this.filterChain == null) {
            return this.do_getString(string);
        }
        return this.filterChain.reset().CallableStatement_getString(this, string);
    }

    @Override
    public boolean getBoolean(String string) {
        if (this.filterChain == null) {
            return this.do_getBoolean(string);
        }
        return this.filterChain.reset().CallableStatement_getBoolean(this, string);
    }

    @Override
    public byte getByte(String string) {
        if (this.filterChain == null) {
            return this.do_getByte(string);
        }
        return this.filterChain.reset().CallableStatement_getByte(this, string);
    }

    @Override
    public short getShort(String string) {
        if (this.filterChain == null) {
            return this.do_getShort(string);
        }
        return this.filterChain.reset().CallableStatement_getShort(this, string);
    }

    @Override
    public int getInt(String string) {
        if (this.filterChain == null) {
            return this.do_getInt(string);
        }
        return this.filterChain.reset().CallableStatement_getInt(this, string);
    }

    @Override
    public long getLong(String string) {
        if (this.filterChain == null) {
            return this.do_getLong(string);
        }
        return this.filterChain.reset().CallableStatement_getLong(this, string);
    }

    @Override
    public float getFloat(String string) {
        if (this.filterChain == null) {
            return this.do_getFloat(string);
        }
        return this.filterChain.reset().CallableStatement_getFloat(this, string);
    }

    @Override
    public double getDouble(String string) {
        if (this.filterChain == null) {
            return this.do_getDouble(string);
        }
        return this.filterChain.reset().CallableStatement_getDouble(this, string);
    }

    @Override
    public byte[] getBytes(String string) {
        if (this.filterChain == null) {
            return this.do_getBytes(string);
        }
        return this.filterChain.reset().CallableStatement_getBytes(this, string);
    }

    @Override
    public Date getDate(String string) {
        if (this.filterChain == null) {
            return this.do_getDate(string);
        }
        return this.filterChain.reset().CallableStatement_getDate(this, string);
    }

    @Override
    public Time getTime(String string) {
        if (this.filterChain == null) {
            return this.do_getTime(string);
        }
        return this.filterChain.reset().CallableStatement_getTime(this, string);
    }

    @Override
    public Timestamp getTimestamp(String string) {
        if (this.filterChain == null) {
            return this.do_getTimestamp(string);
        }
        return this.filterChain.reset().CallableStatement_getTimestamp(this, string);
    }

    @Override
    public Object getObject(String string) {
        if (this.filterChain == null) {
            return this.do_getObject(string);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, string);
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        if (this.filterChain == null) {
            return this.do_getBigDecimal(string);
        }
        return this.filterChain.reset().CallableStatement_getBigDecimal(this, string);
    }

    public Object getObject(String string, Map map) {
        if (this.filterChain == null) {
            return this.do_getObject(string, map);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, string, map);
    }

    @Override
    public Ref getRef(String string) {
        if (this.filterChain == null) {
            return this.do_getRef(string);
        }
        return this.filterChain.reset().CallableStatement_getRef(this, string);
    }

    @Override
    public Blob getBlob(String string) {
        if (this.filterChain == null) {
            return this.do_getBlob(string);
        }
        return this.filterChain.reset().CallableStatement_getBlob(this, string);
    }

    @Override
    public Clob getClob(String string) {
        if (this.filterChain == null) {
            return this.do_getClob(string);
        }
        return this.filterChain.reset().CallableStatement_getClob(this, string);
    }

    @Override
    public Array getArray(String string) {
        if (this.filterChain == null) {
            return this.do_getArray(string);
        }
        return this.filterChain.reset().CallableStatement_getArray(this, string);
    }

    @Override
    public Date getDate(String string, Calendar calendar) {
        if (this.filterChain == null) {
            return this.do_getDate(string, calendar);
        }
        return this.filterChain.reset().CallableStatement_getDate(this, string, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) {
        if (this.filterChain == null) {
            return this.do_getTime(string, calendar);
        }
        return this.filterChain.reset().CallableStatement_getTime(this, string, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) {
        if (this.filterChain == null) {
            return this.do_getTimestamp(string, calendar);
        }
        return this.filterChain.reset().CallableStatement_getTimestamp(this, string, calendar);
    }

    @Override
    public URL getURL(String string) {
        if (this.filterChain == null) {
            return this.do_getURL(string);
        }
        return this.filterChain.reset().CallableStatement_getURL(this, string);
    }

    @Override
    public RowId getRowId(int n2) {
        if (this.filterChain == null) {
            return this.do_getRowId(n2);
        }
        return this.filterChain.reset().CallableStatement_getRowId(this, n2);
    }

    @Override
    public RowId getRowId(String string) {
        if (this.filterChain == null) {
            return this.do_getRowId(string);
        }
        return this.filterChain.reset().CallableStatement_getRowId(this, string);
    }

    @Override
    public void setRowId(String string, RowId rowId) {
        if (this.filterChain == null) {
            this.do_setRowId(string, rowId);
        } else {
            this.filterChain.reset().CallableStatement_setRowId(this, string, rowId);
        }
    }

    @Override
    public void setNString(String string, String string2) {
        if (this.filterChain == null) {
            this.do_setNString(string, string2);
        } else {
            this.filterChain.reset().CallableStatement_setNString(this, string, string2);
        }
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setNCharacterStream(string, reader, l2);
        } else {
            this.filterChain.reset().CallableStatement_setNCharacterStream(this, string, reader, l2);
        }
    }

    @Override
    public void setNClob(String string, NClob nClob) {
        if (this.filterChain == null) {
            this.do_setNClob(string, nClob);
        } else {
            this.filterChain.reset().CallableStatement_setNClob(this, string, nClob);
        }
    }

    @Override
    public void setClob(String string, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setClob(string, reader, l2);
        } else {
            this.filterChain.reset().CallableStatement_setClob(this, string, reader, l2);
        }
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setBlob(string, inputStream, l2);
        } else {
            this.filterChain.reset().CallableStatement_setBlob(this, string, inputStream, l2);
        }
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setNClob(string, reader, l2);
        } else {
            this.filterChain.reset().CallableStatement_setNClob(this, string, reader, l2);
        }
    }

    @Override
    public NClob getNClob(int n2) {
        if (this.filterChain == null) {
            return this.do_getNClob(n2);
        }
        return this.filterChain.reset().CallableStatement_getNClob(this, n2);
    }

    @Override
    public NClob getNClob(String string) {
        if (this.filterChain == null) {
            return this.do_getNClob(string);
        }
        return this.filterChain.reset().CallableStatement_getNClob(this, string);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) {
        if (this.filterChain == null) {
            this.do_setSQLXML(string, sQLXML);
        } else {
            this.filterChain.reset().CallableStatement_setSQLXML(this, string, sQLXML);
        }
    }

    @Override
    public SQLXML getSQLXML(int n2) {
        if (this.filterChain == null) {
            return this.do_getSQLXML(n2);
        }
        return this.filterChain.reset().CallableStatement_getSQLXML(this, n2);
    }

    @Override
    public SQLXML getSQLXML(String string) {
        if (this.filterChain == null) {
            return this.do_getSQLXML(string);
        }
        return this.filterChain.reset().CallableStatement_getSQLXML(this, string);
    }

    @Override
    public String getNString(int n2) {
        if (this.filterChain == null) {
            return this.do_getNString(n2);
        }
        return this.filterChain.reset().CallableStatement_getNString(this, n2);
    }

    @Override
    public String getNString(String string) {
        if (this.filterChain == null) {
            return this.do_getNString(string);
        }
        return this.filterChain.reset().CallableStatement_getNString(this, string);
    }

    @Override
    public Reader getNCharacterStream(int n2) {
        if (this.filterChain == null) {
            return this.do_getNCharacterStream(n2);
        }
        return this.filterChain.reset().CallableStatement_getNCharacterStream(this, n2);
    }

    @Override
    public Reader getNCharacterStream(String string) {
        if (this.filterChain == null) {
            return this.do_getNCharacterStream(string);
        }
        return this.filterChain.reset().CallableStatement_getNCharacterStream(this, string);
    }

    @Override
    public Reader getCharacterStream(int n2) {
        if (this.filterChain == null) {
            return this.do_getCharacterStream(n2);
        }
        return this.filterChain.reset().CallableStatement_getCharacterStream(this, n2);
    }

    @Override
    public Reader getCharacterStream(String string) {
        if (this.filterChain == null) {
            return this.do_getCharacterStream(string);
        }
        return this.filterChain.reset().CallableStatement_getCharacterStream(this, string);
    }

    @Override
    public void setBlob(String string, Blob blob) {
        if (this.filterChain == null) {
            this.do_setBlob(string, blob);
        } else {
            this.filterChain.reset().CallableStatement_setBlob(this, string, blob);
        }
    }

    @Override
    public void setClob(String string, Clob clob) {
        if (this.filterChain == null) {
            this.do_setClob(string, clob);
        } else {
            this.filterChain.reset().CallableStatement_setClob(this, string, clob);
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(string, inputStream, l2);
        } else {
            this.filterChain.reset().CallableStatement_setAsciiStream(this, string, inputStream, l2);
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l2) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(string, inputStream, l2);
        } else {
            this.filterChain.reset().CallableStatement_setBinaryStream(this, string, inputStream, l2);
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l2) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(string, reader, l2);
        } else {
            this.filterChain.reset().CallableStatement_setCharacterStream(this, string, reader, l2);
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setAsciiStream(string, inputStream);
        } else {
            this.filterChain.reset().CallableStatement_setAsciiStream(this, string, inputStream);
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setBinaryStream(string, inputStream);
        } else {
            this.filterChain.reset().CallableStatement_setBinaryStream(this, string, inputStream);
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader) {
        if (this.filterChain == null) {
            this.do_setCharacterStream(string, reader);
        } else {
            this.filterChain.reset().CallableStatement_setCharacterStream(this, string, reader);
        }
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) {
        if (this.filterChain == null) {
            this.do_setNCharacterStream(string, reader);
        } else {
            this.filterChain.reset().CallableStatement_setNCharacterStream(this, string, reader);
        }
    }

    @Override
    public void setClob(String string, Reader reader) {
        if (this.filterChain == null) {
            this.do_setClob(string, reader);
        } else {
            this.filterChain.reset().CallableStatement_setClob(this, string, reader);
        }
    }

    @Override
    public void setBlob(String string, InputStream inputStream) {
        if (this.filterChain == null) {
            this.do_setBlob(string, inputStream);
        } else {
            this.filterChain.reset().CallableStatement_setBlob(this, string, inputStream);
        }
    }

    @Override
    public void setNClob(String string, Reader reader) {
        if (this.filterChain == null) {
            this.do_setNClob(string, reader);
        } else {
            this.filterChain.reset().CallableStatement_setNClob(this, string, reader);
        }
    }

    public Object getObject(int n2, Class clazz) {
        if (this.filterChain == null) {
            return this.do_getObject(n2, clazz);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, n2, clazz);
    }

    public Object getObject(String string, Class clazz) {
        if (this.filterChain == null) {
            return this.do_getObject(string, clazz);
        }
        return this.filterChain.reset().CallableStatement_getObject(this, string, clazz);
    }

    public void setObject(String string, Object object, dm.java.sql.a a2, int n2) {
        if (this.filterChain == null) {
            this.do_setObject(string, object, a2, n2);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, string, object, a2, n2);
        }
    }

    public void setObject(String string, Object object, dm.java.sql.a a2) {
        if (this.filterChain == null) {
            this.do_setObject(string, object, a2);
        } else {
            this.filterChain.reset().CallableStatement_setObject(this, string, object, a2);
        }
    }

    public void registerOutParameter(int n2, dm.java.sql.a a2) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(n2, a2);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, n2, a2);
        }
    }

    public void registerOutParameter(int n2, dm.java.sql.a a2, int n3) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(n2, a2, n3);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, n2, a2, n3);
        }
    }

    public void registerOutParameter(int n2, dm.java.sql.a a2, String string) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(n2, a2, string);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, n2, a2, string);
        }
    }

    public void registerOutParameter(String string, dm.java.sql.a a2) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(string, a2);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, string, a2);
        }
    }

    public void registerOutParameter(String string, dm.java.sql.a a2, int n2) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(string, a2, n2);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, string, a2, n2);
        }
    }

    public void registerOutParameter(String string, dm.java.sql.a a2, String string2) {
        if (this.filterChain == null) {
            this.do_registerOutParameter(string, a2, string2);
        } else {
            this.filterChain.reset().CallableStatement_registerOutParameter(this, string, a2, string2);
        }
    }

    public DmdbIntervalYM getINTERVALYM(int n2) {
        if (this.filterChain == null) {
            return this.do_getINTERVALYM(n2);
        }
        return this.filterChain.reset().CallableStatement_getINTERVALYM(this, n2);
    }

    public DmdbIntervalYM getINTERVALYM(String string) {
        if (this.filterChain == null) {
            return this.do_getINTERVALYM(string);
        }
        return this.filterChain.reset().CallableStatement_getINTERVALYM(this, string);
    }

    public DmdbIntervalDT getINTERVALDT(int n2) {
        if (this.filterChain == null) {
            return this.do_getINTERVALDT(n2);
        }
        return this.filterChain.reset().CallableStatement_getINTERVALDT(this, n2);
    }

    public DmdbIntervalDT getINTERVALDT(String string) {
        if (this.filterChain == null) {
            return this.do_getINTERVALDT(string);
        }
        return this.filterChain.reset().CallableStatement_getINTERVALDT(this, string);
    }

    public DmdbTimestamp getTIMESTAMP(int n2) {
        if (this.filterChain == null) {
            return this.do_getTIMESTAMP(n2);
        }
        return this.filterChain.reset().CallableStatement_getTIMESTAMP(this, n2);
    }

    public DmdbTimestamp getTIMESTAMP(String string) {
        if (this.filterChain == null) {
            return this.do_getTIMESTAMP(string);
        }
        return this.filterChain.reset().CallableStatement_getTIMESTAMP(this, string);
    }

    public void setTIMESTAMP(String string, DmdbTimestamp dmdbTimestamp) {
        if (this.filterChain == null) {
            this.do_setTIMESTAMP(string, dmdbTimestamp);
        } else {
            this.filterChain.reset().CallableStatement_setTIMESTAMP(this, string, dmdbTimestamp);
        }
    }

    public void setINTERVALDT(String string, DmdbIntervalDT dmdbIntervalDT) {
        if (this.filterChain == null) {
            this.do_setINTERVALDT(string, dmdbIntervalDT);
        } else {
            this.filterChain.reset().CallableStatement_setINTERVALDT(this, string, dmdbIntervalDT);
        }
    }

    public void setINTERVALYM(String string, DmdbIntervalYM dmdbIntervalYM) {
        if (this.filterChain == null) {
            this.do_setINTERVALYM(string, dmdbIntervalYM);
        } else {
            this.filterChain.reset().CallableStatement_setINTERVALYM(this, string, dmdbIntervalYM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCursor(n2);
            }
            return this.filterChain.reset().CallableStatement_getCursor(this, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCursor(string);
            }
            return this.filterChain.reset().CallableStatement_getCursor(this, string);
        }
    }

    @Override
    public void resetParams(DmdbStatement dmdbStatement) {
        super.resetParams(dmdbStatement);
        if (dmdbStatement instanceof DmdbCallableStatement) {
            DmdbCallableStatement dmdbCallableStatement = (DmdbCallableStatement)dmdbStatement;
            if (dmdbCallableStatement.nameBindParamMap != null && dmdbCallableStatement.nameBindParamMap.size() > 0) {
                this.nameBindParamMap.clear();
                this.nameBindParamMap.putAll(dmdbCallableStatement.nameBindParamMap);
            }
        }
    }
}

